/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.vcsgis.lib.VCSGisPreparedWorkingCopyInformation;
import org.gvsig.vcsgis.lib.VCSGisPreparedWorkspaceInformationImpl;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AbstractRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.tables.ConfigRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisListWCRequest;
import org.gvsig.vcsgis.lib.requests.ListWCRequestHelper;

public class ListWCRequestLocaldb
extends AbstractRequestLocaldb
implements VCSGisListWCRequest {
    public ListWCRequestLocaldb(VCSGisRepositoryLocaldbImpl repository) {
        super(new ListWCRequestHelper(repository));
    }

    @Override
    public ListWCRequestHelper helper() {
        return (ListWCRequestHelper)super.helper();
    }

    public List<VCSGisPreparedWorkingCopyInformation> getWorkingCopiesInformation() {
        return this.helper().workingCopiesInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        String folder_s;
        block7: {
            if (!this.isAuthorized()) {
                return this.getLastErrorCode();
            }
            LOGGER.info("Process request: " + this.getRequestName() + " user '" + this.getUserCode() + "'.");
            ConfigRepoTable configTable = new ConfigRepoTable();
            folder_s = configTable.get(this.getRepository(), "PREPARED_WORKING_COPIES_FOLDER");
            if (!StringUtils.isBlank((CharSequence)folder_s)) break block7;
            this.helper().workingCopiesInformation = Collections.EMPTY_LIST;
            int n = this.error(0);
            return n;
        }
        try {
            File folder = new File(folder_s);
            ArrayList<VCSGisPreparedWorkingCopyInformation> l = new ArrayList<VCSGisPreparedWorkingCopyInformation>();
            Collection preparedwcs = FileUtils.listFiles((File)folder, (String[])new String[]{"zip"}, (boolean)false);
            for (File preparedwc : preparedwcs) {
                VCSGisPreparedWorkspaceInformationImpl info = new VCSGisPreparedWorkspaceInformationImpl();
                info.setName(FilenameUtils.removeExtension((String)preparedwc.getName()));
                info.setDate(new Timestamp(preparedwc.lastModified()));
                info.setLocation("preparedwcs/" + preparedwc.getName());
                info.setNumParts(this.calculateNumParts(preparedwc));
                l.add(info);
            }
            this.helper().workingCopiesInformation = l;
            int n = this.error(0);
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve entities from '" + this.getRepository().getLabel() + "'.", (Throwable)ex);
            int n = this.error(250, "Can't retrieve entities from '" + this.getRepository().getLabel() + "'.");
            return n;
        }
    }

    private int calculateNumParts(File zip) {
        return 1;
    }
}

