/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AbstractRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.tables.DataRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.EntitiesRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.RevisionsRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRowIsOutofdateRequest;
import org.gvsig.vcsgis.lib.requests.RowIsOutofdateRequestHelper;

public class RowIsOutofdateRequestLocaldb
extends AbstractRequestLocaldb
implements VCSGisRowIsOutofdateRequest {
    public RowIsOutofdateRequestLocaldb(VCSGisRepositoryLocaldbImpl repository, String entityName, String localRevisionCode, String recordCode) {
        super(new RowIsOutofdateRequestHelper(repository, entityName, localRevisionCode, recordCode));
    }

    @Override
    public RowIsOutofdateRequestHelper helper() {
        return (RowIsOutofdateRequestHelper)super.helper();
    }

    public String getEntityName() {
        return this.helper().getEntityName();
    }

    public String getLocalRevisionCode() {
        return this.helper().getLocalRevisionCode();
    }

    public String getRecordCode() {
        return this.helper().getRecordCode();
    }

    public boolean isOutdated() {
        return this.helper().isOutdated();
    }

    public int execute() {
        LOGGER.info("Process request: " + this.getRequestName() + " user '" + this.getUserCode() + "' Entity '" + this.helper().entityName + "', LocalRevisionCode'" + this.helper().localRevisionCode + "', RecordCode'" + this.helper().recordCode + "'.");
        EntitiesRepoTable entitiesTable = new EntitiesRepoTable();
        EntitiesRepoTable.EntityRepoRow entityRow = entitiesTable.getByEntityName(this.getRepository(), this.helper().entityName);
        if (entityRow == null) {
            LOGGER.warn("Process request: " + this.getRequestName() + " entity '" + this.helper().entityName + "' not found.");
            return this.error(240, "Entity '" + this.helper().entityName + "' not exists.");
        }
        if (!this.isAuthorized((VCSGisEntity)entityRow)) {
            return this.getLastErrorCode();
        }
        RevisionsRepoTable revisionsTable = new RevisionsRepoTable();
        RevisionsRepoTable.RevisionRepoRow localRevisionRow = revisionsTable.getByRevisionCode(this.getRepository(), this.helper().localRevisionCode);
        if (localRevisionRow == null) {
            LOGGER.warn("Process request: " + this.getRequestName() + " entity '" + this.helper().entityName + "' revision '" + this.helper().localRevisionCode + "' not found.");
            return this.error(16, "Entity '" + this.helper().entityName + "' revision '" + this.helper().localRevisionCode + "' not found.");
        }
        DataRepoTable dataTable = this.getRepository().getDataRepoTable(entityRow.getDataTableName());
        DataRepoTable.DataRepoRow recordDataRow = dataTable.getLastDataOfRecord(this.getRepository(), entityRow.getDataTableName(), this.helper().recordCode);
        if (recordDataRow == null) {
            LOGGER.warn("Process request: " + this.getRequestName() + " record Code '" + this.helper().recordCode + "' not found.");
            return this.error(35, "Record Code '" + this.helper().recordCode + "' not found.");
        }
        this.helper().outdated = recordDataRow.getRevisionNumber() > localRevisionRow.getNumber();
        return 0;
    }

    public void notifyObservers(String tableName, String operation) {
    }

    public void addObserver(String tableName, String type, String operation, String command) {
    }
}

