/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlan;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanImpl;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AbstractRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.tables.TopologyplanRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisTopologyPlansRequest;
import org.gvsig.vcsgis.lib.requests.TopologyPlansRequestHelper;

public class TopologyPlansRequestLocaldb
extends AbstractRequestLocaldb
implements VCSGisTopologyPlansRequest {
    public TopologyPlansRequestLocaldb(VCSGisRepositoryLocaldbImpl repository) {
        super(new TopologyPlansRequestHelper(repository));
    }

    @Override
    public TopologyPlansRequestHelper helper() {
        return (TopologyPlansRequestHelper)super.helper();
    }

    public List<VCSGisTopologyPlan> getTopologyPlans() {
        return this.helper().getTopologyPlans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        int n;
        if (!this.isAuthorized()) {
            return this.getLastErrorCode();
        }
        LOGGER.info("Process request: " + this.getRequestName() + " user '" + this.getUserCode() + "'.");
        DisposableFeatureSetIterable topologyPlansTable_it = null;
        try {
            TopologyplanRepoTable topologyPlansTable = new TopologyplanRepoTable();
            ArrayList<VCSGisTopologyPlan> list = new ArrayList<VCSGisTopologyPlan>();
            topologyPlansTable_it = topologyPlansTable.getAll(this.getRepository());
            for (Feature ftopologyPlan : topologyPlansTable_it) {
                VCSGisTopologyPlanImpl topologyPlan = new VCSGisTopologyPlanImpl();
                topologyPlan.copyFrom(new TopologyplanRepoTable.TopologyplanRow(this.getRepository(), ftopologyPlan));
                list.add(topologyPlan);
            }
            this.helper().topologyplans = list;
            n = this.error(0);
        }
        catch (Exception ex) {
            int n2;
            try {
                LOGGER.warn("Can't retrieve topology plans from '" + this.getRepository().getLabel() + "'.", (Throwable)ex);
                n2 = this.error(31, "Can't retrieve topology plans from '" + this.getRepository().getLabel() + "'.");
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(topologyPlansTable_it);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)topologyPlansTable_it);
            return n2;
        }
        DisposeUtils.disposeQuietly((Disposable)topologyPlansTable_it);
        return n;
    }
}

