/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient.requests;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Writer;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.IOUtils;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.AbstractRequestClient;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisAuthenticateRequest;
import org.gvsig.vcsgis.lib.requests.AuthenticateRequestHelper;

public class AuthenticateRequestClient
extends AbstractRequestClient
implements VCSGisAuthenticateRequest {
    public AuthenticateRequestClient(VCSGisRepositoryClientImpl repository) {
        super(new AuthenticateRequestHelper(repository), "authenticate");
    }

    @Override
    public AuthenticateRequestHelper helper() {
        return (AuthenticateRequestHelper)super.helper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestProducer(Writer out) {
        try {
            LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 1");
            JsonObjectBuilder parametersBuilder = Json.createObjectBuilder();
            parametersBuilder.add("UserId", this.getUserName());
            parametersBuilder.add("Password", this.getPassword());
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("Parameters", (javax.json.JsonObjectBuilder)parametersBuilder);
            IOUtils.write((String)builder.toString(), (Writer)out);
            this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't produce Json data for " + this.getRequestName() + ".", (Throwable)ex);
            this.error(600, "Can't produce Json data for " + this.getRequestName() + ". " + ex.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Writer)out);
        }
    }

    @Override
    public void responseConsumer(BufferedReader dataReader) {
        JsonReader reader = Json.createReader((Reader)dataReader);
        JsonObject jsonResponse = reader.readObject();
        JsonObject parameters = jsonResponse.getJsonObject("Parameters");
        this.error(parameters.getInt("StatusCode", 0), parameters.getString("StatusMessage", null));
        this.helper().setAuthenticationToken(parameters.getString("AuthenticationToken", null));
        this.helper().setUserCode(parameters.getString("UserCode", null));
        this.notifyResponseConsumers();
    }

    public String getUserName() {
        return this.helper().getUserName();
    }

    public String getPassword() {
        return this.helper().getPassword();
    }

    public void setUserName(String id) {
        this.helper().setUserName(id);
    }

    public void setPassword(String password) {
        this.helper().setPassword(password);
    }
}

