/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient.requests;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.gvsig.vcsgis.lib.EntityEditableImpl;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.AbstractRequestClient;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisEntitiesRequest;
import org.gvsig.vcsgis.lib.requests.EntitiesRequestHelper;

public class EntitiesRequestClient
extends AbstractRequestClient
implements VCSGisEntitiesRequest {
    public EntitiesRequestClient(VCSGisRepositoryClientImpl repository) {
        super(new EntitiesRequestHelper(repository), "entities");
    }

    @Override
    public EntitiesRequestHelper helper() {
        return (EntitiesRequestHelper)super.helper();
    }

    public List<VCSGisEntity> getRepositoryEntities() {
        return this.helper().getRepositoryEntities();
    }

    @Override
    public void requestProducer(Writer out) {
        this.error(0);
    }

    @Override
    public void responseConsumer(BufferedReader inputData) {
        try {
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer");
            ArrayList<VCSGisEntity> theEntities = new ArrayList<VCSGisEntity>();
            JsonReader reader = Json.createReader((Reader)inputData);
            JsonObject jsonResponse = reader.readObject();
            JsonObject jsonParameters = jsonResponse.getJsonObject("Parameters");
            int statusCode = jsonParameters.getInt("StatusCode", 250);
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer status code " + statusCode);
            if (statusCode != 0) {
                this.error(statusCode, jsonParameters.getString("StatusMessage", VCSGisUtils.getErrorMessage(statusCode)));
                return;
            }
            this.cleanLastError();
            JsonArray jsonEntities = jsonParameters.getJsonArray("Entities");
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer entitities " + jsonEntities.size());
            for (JsonValue x : jsonEntities) {
                EntityEditableImpl entity = new EntityEditableImpl((JsonObject)x);
                LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer entity " + entity.getEntityName());
                theEntities.add((VCSGisEntity)entity);
            }
            this.helper().entities = theEntities;
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer ok");
            this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve entities from '" + this.getRequestUrl() + "'.", (Throwable)ex);
            this.error(250, "Can't retrieve entities from '" + this.getRequestUrl() + "'.");
        }
    }
}

