/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient.requests;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.IOUtils;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.AbstractRequestClient;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisPrepareWCRequest;
import org.gvsig.vcsgis.lib.requests.PrepareWCRequestHelper;

public class PrepareWCRequestClient
extends AbstractRequestClient
implements VCSGisPrepareWCRequest {
    public PrepareWCRequestClient(VCSGisRepositoryClientImpl repository) {
        super(new PrepareWCRequestHelper(repository), "preparewc");
    }

    @Override
    public PrepareWCRequestHelper helper() {
        return (PrepareWCRequestHelper)super.helper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestProducer(Writer out) {
        try {
            LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 1");
            JsonObjectBuilder parametersBuilder = org.gvsig.json.Json.createObjectBuilder();
            parametersBuilder.add("name", this.getName());
            parametersBuilder.add("label", this.getLabel());
            parametersBuilder.add("categories", this.getCategories());
            parametersBuilder.add("username", this.getUserName());
            parametersBuilder.add("userpass", this.getUserPass());
            JsonObjectBuilder builder = org.gvsig.json.Json.createObjectBuilder();
            builder.add("Parameters", (javax.json.JsonObjectBuilder)parametersBuilder);
            IOUtils.write((String)builder.toString(), (Writer)out);
            this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't produce Json data for " + this.getRequestName() + " request.", (Throwable)ex);
            this.error(600, "Can't produce Json data for " + this.getRequestName() + " request. " + ex.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Writer)out);
        }
    }

    @Override
    public void responseConsumer(BufferedReader inputData) {
        try {
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer");
            ArrayList theWorkspaces = new ArrayList();
            JsonReader reader = Json.createReader((Reader)inputData);
            JsonObject jsonResponse = reader.readObject();
            JsonObject jsonParameters = jsonResponse.getJsonObject("Parameters");
            int statusCode = jsonParameters.getInt("StatusCode", 250);
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer status code " + statusCode);
            if (statusCode != 0) {
                this.error(statusCode, jsonParameters.getString("StatusMessage", VCSGisUtils.getErrorMessage(statusCode)));
                return;
            }
            this.cleanLastError();
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer ok");
            this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve entities from '" + this.getRequestUrl() + "'.", (Throwable)ex);
            this.error(250, "Can't retrieve prepared workspaces from '" + this.getRequestUrl() + "'.");
        }
    }

    public String getName() {
        return this.helper().getName();
    }

    public String getLabel() {
        return this.helper().getLabel();
    }

    public String getCategories() {
        return this.helper().getCategories();
    }

    public String getUserName() {
        return this.helper().getUserName();
    }

    public String getUserPass() {
        return this.helper().getUserPass();
    }

    public void setCategories(String categories) {
        this.helper().setCategories(categories);
    }

    public void setLabel(String label) {
        this.helper().setLabel(label);
    }

    public void setName(String name) {
        this.helper().setName(name);
    }

    public void setUserPass(String pass) {
        this.helper().setUserPass(pass);
    }

    public void setUserName(String user) {
        this.helper().setUserName(user);
    }
}

