/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.requests;

import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisEntityEditable;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisUpdateRequest;
import org.gvsig.vcsgis.lib.requests.AbstractRequestHelper;

public class UpdateRequestHelper
extends AbstractRequestHelper
implements VCSGisUpdateRequest {
    private static final String REQUEST_NAME = "Update";
    public String entityName;
    public String localRevisionCode;
    public VCSGisEntityEditable entity;
    public DisposableIterable<VCSGisRepositoryData> data;
    public String usersHashCode;
    public String topologyPlansHashCode;

    public UpdateRequestHelper(VCSGisRepository repository, String entityName) {
        super(repository, REQUEST_NAME);
        this.entityName = entityName;
        this.localRevisionCode = null;
        this.entity = null;
        this.data = null;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getLocalRevisionCode() {
        return this.localRevisionCode;
    }

    public void setLocalRevisionCode(String revisionCode) {
        this.localRevisionCode = revisionCode;
    }

    public DisposableIterable<VCSGisRepositoryData> getData() {
        if (this.data == null) {
            throw new IllegalStateException("The request needs to be executed before calling this method.");
        }
        return this.data;
    }

    public VCSGisEntity getEntity() {
        if (this.data == null) {
            throw new IllegalStateException("The request needs to be executed before calling this method.");
        }
        return this.entity;
    }

    @Override
    public void dispose() {
        super.dispose();
        DisposeUtils.disposeQuietly(this.data);
        this.data = null;
        this.entity = null;
        this.entityName = null;
        this.localRevisionCode = null;
    }

    public String getUsersHashCode() {
        return this.usersHashCode;
    }

    public String getTopologyPlansHashCode() {
        return this.topologyPlansHashCode;
    }
}

