/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.handlers;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.json.Json;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisLogRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisUpdateRequest;
import org.gvsig.vcsgis.lib.server.handlers.AbstractVCSGisServertHandler;

public class LogHandler
extends AbstractVCSGisServertHandler {
    private static final String REQUEST_NAME = "Log";

    public LogHandler(VCSGisRepository repository) {
        super(repository, REQUEST_NAME);
    }

    @Override
    protected void requestProducer(MutableObject<VCSGisRequest> req, Map<String, String> params, Reader request_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 1");
        JsonObject jsonParameters = null;
        try {
            JsonReader reader = Json.createReader((Reader)request_contents);
            JsonObject jsonRequest = reader.readObject();
            jsonParameters = jsonRequest.getJsonObject("Parameters");
        }
        catch (JsonException reader) {
            // empty catch block
        }
        String entityName = params.get("EntityName");
        if (jsonParameters != null) {
            entityName = jsonParameters.getString("EntityName", entityName);
        }
        VCSGisLogRequest request = this.getRepository().createLogRequest(entityName);
        request.setAuthenticationTokenAndUser(params);
        if (jsonParameters == null) {
            request.setFeatureRelatedCode(params.get("FeatureRelatedCode"));
        } else {
            request.setFeatureRelatedCode(jsonParameters.getString("FeatureRelatedCode", params.get("FeatureRelatedCode")));
        }
        req.setValue((Object)request);
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 2 notifyRequestConsumers");
        this.notifyRequestConsumers();
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 3 return");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void responseProducer(VCSGisRequest req, Writer response_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] responseProducer 1");
        VCSGisUpdateRequest request = (VCSGisUpdateRequest)req;
        JsonGenerator gen = null;
        try {
            JsonGeneratorFactory genFactory = Json.createGeneratorFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
            gen = genFactory.createGenerator(response_contents);
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 2");
            gen.writeStartObject();
            gen.writeStartObject("Parameters");
            gen.write("StatusCode", request.getLastErrorCode());
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 3");
            this.notifyResponseConsumers();
            gen.flush();
            if (StringUtils.isBlank((CharSequence)request.getLastErrorMessage())) {
                gen.writeNull("StatusMessage");
            } else {
                gen.write("StatusMessage", request.getLastErrorMessage());
            }
            gen.write("EntityName", request.getEntityName());
            gen.writeEnd();
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 4");
            gen.writeStartArray("Data");
            for (VCSGisRepositoryData data : request.getData()) {
                gen.write((JsonValue)data.toJson());
                gen.flush();
            }
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 5");
            gen.writeEnd();
            gen.writeEnd();
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 6 gen.flush()");
            gen.flush();
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 7 response_contents.flush()");
            response_contents.flush();
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 8 end");
        }
        catch (Exception ex) {
            LOGGER.warn("Can't produce Json data for " + this.getName() + " response.", (Throwable)ex);
        }
        finally {
            LOGGER.debug("===: [" + this.getName() + "] responseProducer finally");
            IOUtils.closeQuietly((Closeable)gen);
        }
    }
}

