/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.handlers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRowCreateRequest;
import org.gvsig.vcsgis.lib.server.handlers.AbstractVCSGisServertHandler;

public class RowCreateHandler
extends AbstractVCSGisServertHandler {
    private static final String REQUEST_NAME = "RowCreate";

    public RowCreateHandler(VCSGisRepository repository) {
        super(repository, REQUEST_NAME);
    }

    @Override
    protected void requestProducer(MutableObject<VCSGisRequest> req, Map<String, String> params, Reader request_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 1");
        JsonReader reader = Json.createReader((Reader)request_contents);
        JsonObject jsonRequest = reader.readObject();
        LOGGER.info("===: [" + this.getName() + "] " + jsonRequest.toString());
        String entityName = jsonRequest.getString("EntityName");
        String localRevisionCode = jsonRequest.getString("LocalRevisionCode");
        VCSGisRowCreateRequest request = this.getRepository().createRowCreateRequest(entityName, localRevisionCode);
        request.setAuthenticationTokenAndUser(params);
        request.setEfectiveDate(jsonRequest.getString("EfectiveDate", null));
        request.setComment(jsonRequest.getString("Comment", null));
        request.setData(jsonRequest.getString("Data", null));
        req.setValue((Object)request);
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 2 notifyRequestConsumers");
        this.notifyRequestConsumers();
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 3 return");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void responseProducer(VCSGisRequest req, Writer response_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] responseProducer 1");
        VCSGisRowCreateRequest request = (VCSGisRowCreateRequest)req;
        try {
            JsonObjectBuilder jsonbuilder = Json.createObjectBuilder();
            JsonObjectBuilder jsonParams = Json.createObjectBuilder();
            jsonParams.add("StatusCode", request.getLastErrorCode());
            jsonParams.add("StatusMessage", request.getLastErrorMessage());
            jsonParams.add("RelatedFeatureCode", request.getRelatedFeatureCode());
            jsonParams.add("EntityName", request.getEntityName());
            jsonParams.add("EntityCode", request.getEntityCode());
            jsonParams.add("RevisionCode", request.getEntityRevisionCode());
            jsonbuilder.add("Parameters", (javax.json.JsonObjectBuilder)jsonParams);
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 2 notifyResponseConsumers");
            this.notifyResponseConsumers();
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 3 write json to response");
            IOUtils.write((String)jsonbuilder.toString(), (Writer)response_contents);
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 4 flush");
            response_contents.flush();
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 5 return");
        }
        catch (Exception ex) {
            LOGGER.warn("Can't produce Json data for " + this.getName() + " response.", (Throwable)ex);
        }
        finally {
            LOGGER.debug("===: [" + this.getName() + "] responseProducer  6 close response_contents");
            IOUtils.closeQuietly((Writer)response_contents);
            LOGGER.debug("===: [" + this.getName() + "] responseProducer  7");
        }
    }
}

