/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.workspace.tables;

import java.security.MessageDigest;
import java.util.List;
import javax.json.JsonObject;
import org.apache.commons.codec.binary.Hex;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.VCSGisUserEditable;
import org.gvsig.vcsgis.lib.VCSGisUserImpl;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.tables.AbstractTable;

public class UsersTable
extends AbstractTable {
    public static final String TABLE_NAME = "VCSGIS_USERS";
    public static final String COD_USER = "COD_USER";
    public static final String USER_ID = "USER_ID";
    private static final String USER_ALLOWED_OPERATIONS = "USER_ALLOWEDOPERATIONS";
    private static final String USER_ROLES = "USER_ROLES";
    private static final String USER_DESCRIPTION = "USER_DESCRIPTION";

    public static final FeatureType featureType() {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("VCSGIS Users");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.add(COD_USER, 8).setTag("dynform.readonly", (Object)true).setSize(60).setIsPrimaryKey(true).setLabel("Code").setReadOnly(false).setDefaultFieldValue((Object)"<%=replace(UUID(),'-','')%>");
        ft.add(USER_ID, 8).setIsIndexed(true).setAllowIndexDuplicateds(false).setSize(50).setLabel("Identifier");
        ft.add(USER_ALLOWED_OPERATIONS, 8).setDataProfileName("Text").setIsIndexed(false).setSize(200).setLabel("Allowed operations").setDescription("Comma separated operation names without spaces (add,entities,commit,update,checkout,history,topologyplans,users)");
        ft.add(USER_ROLES, 8).setDataProfileName("Text").setIsIndexed(false).setSize(200).setLabel("Roles").setDescription("Comma separated role names without spaces (admin,...)");
        ft.add(USER_DESCRIPTION, 8).setDataProfileName("Text").setSize(4096).setLabel("Description");
        return ft.getNotEditableCopy();
    }

    public UsersTable() {
        super(TABLE_NAME, UsersTable.featureType());
    }

    public String getHashCode(VCSGisWorkspace workspace) {
        String string;
        FeatureStore store = null;
        DisposableFeatureSetIterable changes = null;
        try {
            String hash;
            MessageDigest md = MessageDigest.getInstance("MD5");
            store = workspace.getFeatureStore(TABLE_NAME);
            changes = store.getFeatureSet().iterable();
            for (Feature change : changes) {
                VCSGisUtils.updateMessageDigest(md, change, COD_USER);
                VCSGisUtils.updateMessageDigest(md, change, USER_ID);
                VCSGisUtils.updateMessageDigest(md, change, USER_ALLOWED_OPERATIONS);
                VCSGisUtils.updateMessageDigest(md, change, USER_ROLES);
                VCSGisUtils.updateMessageDigest(md, change, USER_DESCRIPTION);
            }
            string = hash = Hex.encodeHexString((byte[])md.digest());
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve hash of users.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.dispose(changes);
                DisposeUtils.dispose(store);
                throw throwable;
            }
        }
        DisposeUtils.dispose((Disposable)changes);
        DisposeUtils.dispose((Disposable)store);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCSGisUser getUserByIdentifier(VCSGisWorkspace workspace, String identifier) {
        FeatureStore store = null;
        try {
            UserRow row;
            store = workspace.getFeatureStore(TABLE_NAME);
            Feature f = store.findFirst("\"USER_ID\"='" + identifier + "'");
            if (f == null) {
                VCSGisUser vCSGisUser = null;
                return vCSGisUser;
            }
            UserRow userRow = row = new UserRow(workspace, f);
            return userRow;
        }
        catch (Exception ex) {
            VCSGisUser vCSGisUser = null;
            return vCSGisUser;
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCSGisUser getUserByCode(VCSGisWorkspace workspace, String code) {
        FeatureStore store = null;
        try {
            UserRow row;
            store = workspace.getFeatureStore(TABLE_NAME);
            Feature f = store.findFirst("\"COD_USER\"='" + code + "'");
            if (f == null) {
                VCSGisUser vCSGisUser = null;
                return vCSGisUser;
            }
            UserRow userRow = row = new UserRow(workspace, f);
            return userRow;
        }
        catch (Exception ex) {
            VCSGisUser vCSGisUser = null;
            return vCSGisUser;
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public static class UserRow
    extends AbstractTable.AbstractRow
    implements VCSGisUserEditable {
        private List<String> operations_list;
        private List<String> roles_list;

        public UserRow(VCSGisWorkspace workspace) {
            super(workspace, UsersTable.TABLE_NAME, UsersTable.COD_USER);
        }

        public UserRow(VCSGisWorkspace workspace, Feature feature) {
            super(workspace, UsersTable.TABLE_NAME, UsersTable.COD_USER, feature);
        }

        public String getUserCode() {
            return this.getString(UsersTable.COD_USER);
        }

        public String getIdentifier() {
            return this.getString(UsersTable.USER_ID);
        }

        public String getDescription() {
            return this.getString(UsersTable.USER_DESCRIPTION);
        }

        public String getAllowedOperations() {
            return "";
        }

        @Override
        public void setUserCode(String userCode) {
            this.set(UsersTable.COD_USER, userCode);
        }

        @Override
        public void setAllowedOperations(String roles) {
        }

        @Override
        public void setDescription(String description) {
            this.set(UsersTable.USER_DESCRIPTION, description);
        }

        @Override
        public void setIdentifier(String identifier) {
            this.set(UsersTable.USER_ID, identifier);
        }

        @Override
        public void copy(VCSGisUser source, VCSGisUser target) {
            VCSGisUserImpl.copyUser(source, (VCSGisUserEditable)target);
        }

        @Override
        public VCSGisUser clone() {
            try {
                VCSGisUserEditable other = (VCSGisUserEditable)super.clone();
                VCSGisUserImpl.copyUser(this, other);
                return other;
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }

        public void copyFrom(VCSGisUser other) {
            VCSGisUserImpl.copyUser(other, this);
        }

        public List<String> getAllowedOperationsAsList() {
            if (this.operations_list == null) {
                this.operations_list = VCSGisUserImpl.getAllowedOperationsAsList(this);
            }
            return this.operations_list;
        }

        public boolean isAllowedOperation(String roleid) {
            return VCSGisUserImpl.isAllowedOperation(this, roleid);
        }

        public void fromJson(JsonObject json) {
            VCSGisUserImpl.fromJson(this, json);
        }

        public JsonObject toJson() {
            return this.toJsonBuilder().build();
        }

        public JsonObjectBuilder toJsonBuilder() {
            return VCSGisUserImpl.toJsonBuilder(this);
        }

        public String toString() {
            return VCSGisUserImpl.toString(this);
        }

        public String getRoles() {
            return "";
        }

        public List<String> getRolesAsList() {
            if (this.roles_list == null) {
                this.roles_list = VCSGisUserImpl.getRolesAsList(this);
            }
            return this.roles_list;
        }

        @Override
        public void setRoles(String roles) {
            this.set(UsersTable.USER_ROLES, roles);
        }
    }
}

