/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.extendline.operation;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.vectorediting.lib.prov.extendline.operation.ExtendLineOperation;
import org.gvsig.vectorediting.lib.prov.extendline.operation.ExtendLineOperationUtils;

public class CurveExtendLineOperation
implements ExtendLineOperation {
    @Override
    public Curve extendLine(Curve lineToExtend, Point insertedPoint, FeatureSelection boundaryObjects) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException, GeometryException {
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        int subtype = lineToExtend.getGeometryType().getSubType();
        Line extendedLine = geoManager.createLine(subtype);
        Point startVertex = lineToExtend.getVertex(0);
        Point endVertex = lineToExtend.getVertex(lineToExtend.getNumVertices() - 1);
        Point startIntersectionPoint = null;
        Point endIntersectionPoint = null;
        if (insertedPoint.distance((Geometry)startVertex) < insertedPoint.distance((Geometry)endVertex)) {
            startIntersectionPoint = ExtendLineOperationUtils.curveIntersection(lineToExtend, "start", boundaryObjects);
        } else {
            endIntersectionPoint = ExtendLineOperationUtils.curveIntersection(lineToExtend, "end", boundaryObjects);
        }
        if (startIntersectionPoint != null) {
            extendedLine.addVertex(startIntersectionPoint);
        }
        for (int i = 0; i < lineToExtend.getNumVertices(); ++i) {
            extendedLine.addVertex(lineToExtend.getVertex(i));
        }
        if (endIntersectionPoint != null) {
            extendedLine.addVertex(endIntersectionPoint);
        }
        return extendedLine;
    }

    @Override
    public Curve extendLine(Curve lineToExtend, Point insertedPoint, Geometry boundaryObject) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException, GeometryException {
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        int subtype = lineToExtend.getGeometryType().getSubType();
        Line extendedLine = geoManager.createLine(subtype);
        Point startVertex = lineToExtend.getVertex(0);
        Point endVertex = lineToExtend.getVertex(lineToExtend.getNumVertices() - 1);
        Point startIntersectionPoint = null;
        Point endIntersectionPoint = null;
        if (insertedPoint.distance((Geometry)startVertex) < insertedPoint.distance((Geometry)endVertex)) {
            startIntersectionPoint = ExtendLineOperationUtils.curveIntersection(lineToExtend, "start", boundaryObject);
        } else {
            endIntersectionPoint = ExtendLineOperationUtils.curveIntersection(lineToExtend, "end", boundaryObject);
        }
        if (startIntersectionPoint != null) {
            extendedLine.addVertex(startIntersectionPoint);
        }
        for (int i = 0; i < lineToExtend.getNumVertices(); ++i) {
            extendedLine.addVertex(lineToExtend.getVertex(i));
        }
        if (endIntersectionPoint != null) {
            extendedLine.addVertex(endIntersectionPoint);
        }
        return extendedLine;
    }
}

