/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.japura.MethodNotImplementedException;
import org.japura.controller.AbstractController;
import org.japura.controller.ChildController;
import org.japura.controller.ControllerException;
import org.japura.controller.ControllerManager;
import org.japura.controller.ControllerManagerListener;
import org.japura.controller.ControllerMockFactory;
import org.japura.controller.ControllerModel;
import org.japura.controller.InvalidControllerClassException;
import org.japura.controller.Link;
import org.japura.controller.Message;
import org.japura.controller.MessageFilter;

abstract class AbstractControllerManager
implements ControllerManager {
    ArrayList<ControllerModel> controllers = new ArrayList();
    List<ControllerManagerListener> listeners;
    private List<Link> links = new ArrayList<Link>();
    private ControllerMockFactory controllerMockFactory;

    AbstractControllerManager() {
        this.listeners = new ArrayList<ControllerManagerListener>();
    }

    ControllerMockFactory getControllerMockFactory() {
        return this.controllerMockFactory;
    }

    void setControllerMockFactory(ControllerMockFactory controllerMockFactory) {
        this.controllerMockFactory = controllerMockFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addListener(ControllerManagerListener listener) {
        List<ControllerManagerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeListener(ControllerManagerListener listener) {
        List<ControllerManagerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<ControllerManagerListener> getListeners() {
        List<ControllerManagerListener> list = this.listeners;
        synchronized (list) {
            return Collections.unmodifiableList(this.listeners);
        }
    }

    final void methodNotImplemented() {
        throw new MethodNotImplementedException();
    }

    final void testControllerModel(Class<?> clss) {
        if (!ControllerModel.class.isAssignableFrom(clss)) {
            throw new InvalidControllerClassException(clss);
        }
    }

    @Override
    public final boolean existsLink(ControllerModel controller1, ControllerModel controller2) {
        if (controller1 == null || controller2 == null) {
            return false;
        }
        for (Link link : this.links) {
            if (!link.contains(controller1) || !link.contains(controller2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean existsLink(ControllerModel controller, Class<?> clss) {
        this.testControllerModel(clss);
        if (controller == null || clss == null || controller.getClass().equals(clss)) {
            return false;
        }
        for (Link link : this.links) {
            if (!link.contains(controller) || !link.contains(clss)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void link(ControllerModel controller1, ControllerModel controller2) {
        if (controller1 == null || controller2 == null) {
            throw new ControllerException("Null controller");
        }
        if (controller1.getClass().equals(controller2.getClass())) {
            throw new ControllerException("Can not link two controllers from the same class");
        }
        if (controller1.equals(controller2)) {
            throw new ControllerException("Can not link the same controller");
        }
        for (Link link : this.links) {
            if (link.contains(controller1)) {
                throw new ControllerException("Already exists a link for " + controller1.getClass().getName() + " [" + controller1.getControllerId() + "]");
            }
            if (!link.contains(controller2)) continue;
            throw new ControllerException("Already exists a link for " + controller2.getClass().getName() + " [" + controller2.getControllerId() + "]");
        }
        this.links.add(new Link(controller1, controller2));
    }

    @Override
    public final void unlink(ControllerModel controller1, ControllerModel controller2) {
        if (controller1 == null || controller2 == null) {
            return;
        }
        if (controller1.getClass().equals(controller2.getClass())) {
            return;
        }
        if (controller1.equals(controller2)) {
            return;
        }
        Link link = null;
        for (Link l : this.links) {
            if (!l.contains(controller1) || !l.contains(controller2)) continue;
            link = l;
            break;
        }
        if (link != null) {
            this.links.remove(link);
        }
    }

    @Override
    public final void remove(String id) {
        this.remove(id, true);
    }

    @Override
    public final void remove(String id, boolean cancelTaskExecution) {
        if (id != null) {
            for (ControllerModel controller : this.controllers) {
                if (!controller.getControllerId().equals(id)) continue;
                this.remove(controller, cancelTaskExecution);
                break;
            }
        }
    }

    @Override
    public final void removeGroup(String groupdId) {
        ArrayList<String> ids = new ArrayList<String>();
        for (ControllerModel controller : this.controllers) {
            if (!controller.getGroupId().equals(groupdId)) continue;
            ids.add(controller.getControllerId());
        }
        for (String id : ids) {
            this.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeAll(Class<?> clss) {
        this.testControllerModel(clss);
        List<ControllerManagerListener> list = this.listeners;
        synchronized (list) {
            for (ControllerManagerListener listener : this.listeners) {
                listener.attemptToRemove(clss);
            }
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (ControllerModel controller : this.controllers) {
            if (!clss.isAssignableFrom(controller.getClass())) continue;
            ids.add(controller.getControllerId());
        }
        for (String id : ids) {
            this.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeAllFromGroup(String groupId, Class<?> clss) {
        this.testControllerModel(clss);
        if (groupId != null) {
            List<ControllerManagerListener> list = this.listeners;
            synchronized (list) {
                for (ControllerManagerListener listener : this.listeners) {
                    listener.attemptToRemove(groupId, clss);
                }
            }
            ArrayList<String> ids = new ArrayList<String>();
            for (ControllerModel controller : this.controllers) {
                if (!controller.getGroupId().equals(groupId) || !clss.isAssignableFrom(controller.getClass())) continue;
                ids.add(controller.getControllerId());
            }
            for (String id : ids) {
                this.remove(id);
            }
        }
    }

    @Override
    public final boolean isInstancied(Class<?> clss) {
        this.testControllerModel(clss);
        for (ControllerModel controller : this.controllers) {
            if (!clss.isAssignableFrom(controller.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isInstanciedInGroup(String groupId, Class<?> clss) {
        this.testControllerModel(clss);
        if (groupId != null) {
            for (ControllerModel controller : this.controllers) {
                if (!controller.getGroupId().equals(groupId) || !clss.isAssignableFrom(controller.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final void removeAll() {
        ArrayList<String> ids = new ArrayList<String>();
        for (ControllerModel controller : this.controllers) {
            ids.add(controller.getControllerId());
        }
        for (String id : ids) {
            this.remove(id);
        }
    }

    @Override
    public final int count(Class<?> clss) {
        this.testControllerModel(clss);
        int count = 0;
        for (ControllerModel controller : this.controllers) {
            if (!clss.isAssignableFrom(controller.getClass())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public final <E> E get(Class<E> clss) {
        this.testControllerModel(clss);
        ChildController cc = clss.getAnnotation(ChildController.class);
        if (cc != null && cc.getOnlyFromGroup()) {
            throw new ControllerException("You need get the child controller " + clss.getName() + " through the group. Use getGroup().get() or Controller.getFromGroup() method.");
        }
        for (ControllerModel controller : this.controllers) {
            if (!clss.isAssignableFrom(controller.getClass())) continue;
            return clss.cast(controller);
        }
        return this.newInstance(clss);
    }

    @Override
    public final <E> E newInstance(Class<E> clss) {
        E controller = null;
        if (this.getNewInstanceClass().isAssignableFrom(clss)) {
            try {
                if (this.getControllerMockFactory() != null) {
                    controller = this.getControllerMockFactory().create(clss);
                }
                controller = clss.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                AbstractController.newParentController = null;
                throw new RuntimeException(e);
            }
        } else {
            AbstractController.newParentController = null;
            throw new InvalidControllerClassException(clss);
        }
        return controller;
    }

    @Override
    public final <E> E get(String id, Class<E> clss) {
        if (id != null) {
            this.testControllerModel(clss);
            for (ControllerModel controller : this.controllers) {
                if (!controller.getControllerId().equals(id) || !clss.isAssignableFrom(controller.getClass())) continue;
                return clss.cast(controller);
            }
        }
        return null;
    }

    @Override
    public final <E> E getFromGroup(String groupId, Class<E> clss) {
        this.testControllerModel(clss);
        for (ControllerModel controller : this.controllers) {
            if (!controller.getGroupId().equals(groupId) || !clss.isAssignableFrom(controller.getClass())) continue;
            return clss.cast(controller);
        }
        return null;
    }

    @Override
    public final <E> E getFromGroup(String groupId, String id, Class<E> clss) {
        this.testControllerModel(clss);
        if (groupId != null && id != null) {
            for (ControllerModel controller : this.controllers) {
                if (!controller.getGroupId().equals(groupId) || !controller.getControllerId().equals(id) || !clss.isAssignableFrom(controller.getClass())) continue;
                return clss.cast(controller);
            }
        }
        return null;
    }

    @Override
    public final ControllerModel getFromGroup(String groupId, String id) {
        if (groupId != null && id != null) {
            for (ControllerModel controller : this.controllers) {
                if (!controller.getGroupId().equals(groupId) || !controller.getControllerId().equals(id)) continue;
                return controller;
            }
        }
        return null;
    }

    @Override
    public final <E> List<E> getAllFromGroup(String groupId, Class<E> clss) {
        this.testControllerModel(clss);
        ArrayList<E> list = new ArrayList<E>();
        if (groupId != null) {
            for (ControllerModel controller : this.controllers) {
                if (!controller.getGroupId().equals(groupId) || !clss.isAssignableFrom(controller.getClass())) continue;
                list.add(clss.cast(controller));
            }
        }
        return list;
    }

    @Override
    public final List<ControllerModel> getAllFromGroup(String groupId) {
        ArrayList<ControllerModel> list = new ArrayList<ControllerModel>();
        if (groupId != null) {
            for (ControllerModel controller : this.controllers) {
                if (!controller.getGroupId().equals(groupId)) continue;
                list.add(controller);
            }
        }
        return list;
    }

    @Override
    public final ControllerModel get(String id) {
        if (id != null) {
            for (ControllerModel controller : this.controllers) {
                if (!controller.getControllerId().equals(id)) continue;
                return controller;
            }
        }
        return null;
    }

    @Override
    public final <E> List<E> getAll(Class<E> clss) {
        this.testControllerModel(clss);
        ArrayList<E> list = new ArrayList<E>();
        for (ControllerModel controller : this.controllers) {
            if (!clss.isAssignableFrom(controller.getClass())) continue;
            list.add(clss.cast(controller));
        }
        return list;
    }

    @Override
    public final List<ControllerModel> getAll() {
        return new ArrayList<ControllerModel>(this.controllers);
    }

    @Override
    public final boolean contains(ControllerModel controller) {
        if (controller.isRemoved()) {
            return false;
        }
        return this.controllers.contains(controller);
    }

    @Override
    public final void printAllControllers() {
        for (ControllerModel controller : this.controllers) {
            System.out.println("Id: " + controller.getControllerId() + " GroupId: " + controller.getGroupId() + " Class: " + controller.getClass().getName());
        }
    }

    @Override
    public final ControllerModel getRoot(String groupId) {
        if (groupId != null) {
            for (ControllerModel controller : this.controllers) {
                if (!controller.getGroupId().equals(groupId)) continue;
                return controller.getRoot();
            }
        }
        return null;
    }

    @Override
    public final <E> E getFromLink(ControllerModel controllerInLink, Class<E> clss) {
        this.testControllerModel(clss);
        if (controllerInLink == null || clss == null) {
            return null;
        }
        if (controllerInLink.getClass().equals(clss)) {
            return null;
        }
        for (Link link : this.links) {
            if (!link.contains(controllerInLink)) continue;
            return link.get(clss);
        }
        return null;
    }

    @Override
    public final void unlink(ControllerModel controller) {
        Link link = null;
        for (Link l : this.links) {
            if (!l.contains(controller)) continue;
            link = l;
            break;
        }
        if (link != null) {
            this.links.remove(link);
        }
    }

    @Override
    public final void fetchHierarchy(ControllerModel parentController, List<ControllerModel> list) {
        List<ControllerModel> children = parentController.getChildren();
        Iterator<ControllerModel> i$ = children.iterator();
        while (i$.hasNext()) {
            ControllerModel child;
            ControllerModel c = child = i$.next();
            list.add(c);
            this.fetchHierarchy(c, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void add(ControllerModel controller) {
        this.controllers.add(controller);
        List<ControllerManagerListener> list = this.listeners;
        synchronized (list) {
            for (ControllerManagerListener listener : this.listeners) {
                listener.added(controller);
            }
        }
    }

    @Override
    public final void publishToAll(Message message) {
        for (ControllerModel controller : this.getAll()) {
            if (message.isConsumed()) break;
            if (message.getPublisher() != null && message.isIgnorePublisher() && message.getPublisher().getControllerId().equals(controller.getControllerId()) || !this.acceptsMessage(controller, message) || !message.acceptsController(controller)) continue;
            controller.subscribe(message);
        }
    }

    @Override
    public boolean acceptsMessage(ControllerModel controller, Message message) {
        for (MessageFilter filter : controller.getMessageFilters()) {
            if (filter.accepts(message)) continue;
            return false;
        }
        return true;
    }
}

