/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.japura.controller.ControllerModel;

class Link
implements Comparator<ControllerModel> {
    private List<ControllerModel> controllers = new ArrayList<ControllerModel>();

    public Link(ControllerModel ... array) {
        for (ControllerModel controller : array) {
            if (this.controllers.contains(controller)) continue;
            this.controllers.add(controller);
        }
        Collections.sort(this.controllers, this);
    }

    public <E> E get(Class<E> cl) {
        for (ControllerModel controller : this.controllers) {
            if (!cl.isAssignableFrom(controller.getClass())) continue;
            return cl.cast(controller);
        }
        return null;
    }

    @Override
    public int compare(ControllerModel o1, ControllerModel o2) {
        if (o1.getCreationDate() > o2.getCreationDate()) {
            return 1;
        }
        if (o1.getCreationDate() < o2.getCreationDate()) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.controllers == null ? 0 : ((Object)this.controllers).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Link other = (Link)obj;
        return !(this.controllers == null ? other.controllers != null : !((Object)this.controllers).equals(other.controllers));
    }

    public boolean contains(ControllerModel controller) {
        return this.controllers.contains(controller);
    }

    public boolean contains(Class<?> clss) {
        for (ControllerModel controller : this.controllers) {
            if (!controller.getClass().equals(clss)) continue;
            return true;
        }
        return false;
    }
}

