/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.japura.controller.ControllerModel;
import org.japura.controller.SubscriberFilter;

public class Message {
    private List<SubscriberFilter> filters;
    private int type;
    private ControllerModel publisher;
    private boolean consumed;
    private boolean controllerConsumed;
    private boolean ignorePublisher;

    public Message() {
        this(-1);
    }

    public Message(int type) {
        this.type = type;
        this.filters = new ArrayList<SubscriberFilter>();
    }

    public List<SubscriberFilter> getSubscriberFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public void removeSubscriberFilters() {
        this.filters.clear();
    }

    public void removeSubscriberFilter(SubscriberFilter filter) {
        if (filter != null) {
            this.filters.remove(filter);
        }
    }

    public boolean containsSubscriberFilter(SubscriberFilter filter) {
        if (filter != null) {
            return this.filters.contains(filter);
        }
        return false;
    }

    boolean acceptsController(ControllerModel controller) {
        for (SubscriberFilter filter : this.filters) {
            if (filter.accepts(controller)) continue;
            return false;
        }
        return true;
    }

    public void addSubscriberFilter(SubscriberFilter filter) {
        if (filter != null && !this.filters.contains(filter)) {
            this.filters.add(filter);
        }
    }

    void setPublisher(ControllerModel publisher) {
        this.publisher = publisher;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public ControllerModel getPublisher() {
        return this.publisher;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isControllerConsumed() {
        return this.controllerConsumed;
    }

    public void consumeController() {
        this.controllerConsumed = true;
    }

    public void setIgnorePublisher(boolean ignorePublisher) {
        this.ignorePublisher = ignorePublisher;
    }

    public boolean isIgnorePublisher() {
        return this.ignorePublisher;
    }

    public boolean isPublisherAssignableFrom(Class<?> cls) {
        if (this.getPublisher() != null) {
            return cls.isAssignableFrom(this.getPublisher().getClass());
        }
        return false;
    }
}

