/*
 * Decompiled with CFR 0.152.
 */
package org.japura.debug;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.japura.debug.DebugComponent;
import org.japura.util.WeakList;

public final class DebugWindow
extends JDialog {
    private static Map<Class<?>, Integer> tabsIndex = new HashMap();
    private static WeakList<DebugComponent> components = new WeakList();
    private static DebugWindow debugWindow;
    private static final long serialVersionUID = 1966734031063184108L;
    private JTabbedPane tabbedPane;

    static void updateTabTitles() {
        if (components.isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (debugWindow != null) {
                    for (DebugComponent component : components) {
                        int index = (Integer)tabsIndex.get(component.getClass());
                        String title = component.getTitle();
                        debugWindow.getTabbedPane().setTitleAt(index, title);
                    }
                }
            }
        });
    }

    public static void showDebugWindow(final DebugComponent component) {
        try {
            if (tabsIndex.containsKey(component.getClass())) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DebugWindow.getDebugWindow().setLocation(20, 20);
                    DebugWindow.getDebugWindow().setVisible(true);
                    DebugWindow.getDebugWindow().addTab(component);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static DebugWindow getDebugWindow() {
        if (debugWindow == null) {
            debugWindow = new DebugWindow();
        }
        return debugWindow;
    }

    public static void closeDebugWindow() {
        try {
            if (debugWindow != null) {
                debugWindow.dispose();
                debugWindow = null;
                components.clear();
                tabsIndex.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DebugWindow() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DebugWindow.closeDebugWindow();
            }
        });
        this.setModal(false);
        this.setSize(550, 400);
        this.setTitle("Japura - Debug");
        this.add(this.getTabbedPane());
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
        }
        return this.tabbedPane;
    }

    private void addTab(DebugComponent component) {
        if (!tabsIndex.containsKey(component.getClass())) {
            this.getTabbedPane().addTab("", component);
            components.add(component);
            int index = this.tabbedPane.getTabCount() - 1;
            tabsIndex.put(component.getClass(), index);
            this.getTabbedPane().setSelectedIndex(index);
        }
    }
}

