/*
 * Decompiled with CFR 0.152.
 */
package org.japura.dialogs;

import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.japura.dialogs.DefaultMessageDialog;
import org.japura.dialogs.MessageDialogButton;
import org.japura.dialogs.MessageType;
import org.japura.dialogs.MessagesDialogs;
import org.japura.dialogs.PromptType;
import org.japura.gui.Images;
import org.japura.i18n.I18nManager;
import org.japura.i18n.I18nStringKeys;

public class DefaultMessagesDialogs
implements MessagesDialogs {
    public DefaultMessageDialog buildDialog(Component owner, String title, Image dialogIcon, Image icon, String msg, List<MessageDialogButton> buttons) {
        return this.buildDialog(owner, title, dialogIcon, icon, msg, null, buttons);
    }

    public DefaultMessageDialog buildDialog(Component owner, String title, Image dialogIcon, Image icon, String msg, String detailedMsg, List<MessageDialogButton> buttons) {
        Window window = null;
        if (owner != null) {
            window = SwingUtilities.getWindowAncestor(owner);
        }
        return new DefaultMessageDialog(window, title, dialogIcon, icon, msg, detailedMsg, buttons);
    }

    @Override
    public Boolean showDialog(MessageType messageType, PromptType promptType, Component owner, String title, String msg, String detailedMsg, String ... buttonsTexts) {
        Image icon;
        if (buttonsTexts == null) {
            throw new RuntimeException("No buttonsTexts");
        }
        if (promptType.getButtonsCount() != buttonsTexts.length) {
            throw new RuntimeException("Amount of text buttons incompatible with PromptType");
        }
        Image dialogIcon = icon = this.getIcon(messageType);
        ArrayList<MessageDialogButton> buttons = new ArrayList<MessageDialogButton>();
        if (promptType.equals((Object)PromptType.YES)) {
            buttons.add(new MessageDialogButton(buttonsTexts[0], new Boolean(true)));
        } else if (promptType.equals((Object)PromptType.YES_NO)) {
            buttons.add(new MessageDialogButton(buttonsTexts[0], new Boolean(true)));
            buttons.add(new MessageDialogButton(buttonsTexts[1], new Boolean(false)));
        } else if (promptType.equals((Object)PromptType.YES_NO_CANCEL)) {
            buttons.add(new MessageDialogButton(buttonsTexts[0], new Boolean(true)));
            buttons.add(new MessageDialogButton(buttonsTexts[1], new Boolean(false)));
            buttons.add(new MessageDialogButton(buttonsTexts[2], null));
        }
        DefaultMessageDialog dialog = this.buildDialog(owner, title, dialogIcon, icon, msg, detailedMsg, buttons);
        dialog.setVisible(true);
        return (Boolean)dialog.getResult();
    }

    private Image getIcon(MessageType messageType) {
        if (messageType.equals((Object)MessageType.ERROR)) {
            return new ImageIcon(Images.ERROR).getImage();
        }
        if (messageType.equals((Object)MessageType.INFO)) {
            return new ImageIcon(Images.INFORMATION).getImage();
        }
        if (messageType.equals((Object)MessageType.QUESTION)) {
            return new ImageIcon(Images.QUESTION).getImage();
        }
        if (messageType.equals((Object)MessageType.WARN)) {
            return new ImageIcon(Images.WARNING).getImage();
        }
        return null;
    }

    @Override
    public Boolean showDialog(MessageType messageType, PromptType promptType, Component owner, String title, String msg, String ... buttonsTexts) {
        return this.showDialog(messageType, promptType, owner, title, msg, (String)null, buttonsTexts);
    }

    @Override
    public Boolean showQuestionDialog(Component owner, String title, String msg) {
        String yes = I18nManager.getString(I18nStringKeys.YES.getKey());
        String no = I18nManager.getString(I18nStringKeys.NO.getKey());
        return this.showDialog(MessageType.QUESTION, PromptType.YES_NO, owner, title, msg, (String)null, new String[]{yes, no});
    }

    @Override
    public Boolean showQuestionDialog(Component owner, String title, String msg, String detailedMsg) {
        String yes = I18nManager.getString(I18nStringKeys.YES.getKey());
        String no = I18nManager.getString(I18nStringKeys.NO.getKey());
        return this.showDialog(MessageType.QUESTION, PromptType.YES_NO, owner, title, msg, detailedMsg, new String[]{yes, no});
    }

    @Override
    public Boolean showQuestionDialog(Component owner, String title, String msg, String detailedMsg, String yesButtonText, String noButtonText) {
        return this.showDialog(MessageType.QUESTION, PromptType.YES_NO, owner, title, msg, detailedMsg, new String[]{yesButtonText, noButtonText});
    }

    @Override
    public Boolean showWarnDialog(Component owner, String title, String msg, String detailedMsg) {
        String close = I18nManager.getString(I18nStringKeys.CLOSE.getKey());
        return this.showDialog(MessageType.WARN, PromptType.YES, owner, title, msg, detailedMsg, new String[]{close});
    }

    @Override
    public Boolean showWarnDialog(Component owner, String title, String msg) {
        String close = I18nManager.getString(I18nStringKeys.CLOSE.getKey());
        return this.showDialog(MessageType.WARN, PromptType.YES, owner, title, msg, (String)null, new String[]{close});
    }

    @Override
    public Boolean showErrorDialog(Component owner, String title, String msg, String detailedMsg) {
        String close = I18nManager.getString(I18nStringKeys.CLOSE.getKey());
        return this.showDialog(MessageType.ERROR, PromptType.YES, owner, title, msg, detailedMsg, new String[]{close});
    }

    @Override
    public Boolean showErrorDialog(Component owner, String title, String msg) {
        String close = I18nManager.getString(I18nStringKeys.CLOSE.getKey());
        return this.showDialog(MessageType.ERROR, PromptType.YES, owner, title, msg, (String)null, new String[]{close});
    }

    @Override
    public Boolean showInfoDialog(Component owner, String title, String msg, String detailedMsg) {
        String close = I18nManager.getString(I18nStringKeys.CLOSE.getKey());
        return this.showDialog(MessageType.INFO, PromptType.YES, owner, title, msg, detailedMsg, new String[]{close});
    }

    @Override
    public Boolean showInfoDialog(Component owner, String title, String msg) {
        String close = I18nManager.getString(I18nStringKeys.CLOSE.getKey());
        return this.showDialog(MessageType.INFO, PromptType.YES, owner, title, msg, (String)null, new String[]{close});
    }
}

