/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.japura.Application;
import org.japura.controller.ControllerModel;
import org.japura.debug.DebugResult;
import org.japura.task.CancelToken;
import org.japura.task.TaskDebugLog;
import org.japura.task.TaskEvent;
import org.japura.task.TaskExeception;
import org.japura.task.TaskSession;
import org.japura.task.ui.TaskExecutionUI;

public class Task<T>
implements Runnable {
    private CancelToken cancelToken;
    private ControllerModel rootControllerModel;
    private TaskSession session;
    private boolean submitted;
    private boolean parallel;
    private boolean hasException;
    private boolean executed;
    private boolean canceled;
    private Exception exception;
    private T result;
    private String name;
    private String message;
    private boolean waitForEDT = false;
    private String id = Application.buildId();
    private boolean priority;
    private long backgroundTimeSpent;
    private List<Task<?>> nestedTasks = new ArrayList();
    private TaskExecutionUI taskExecutionUI;

    public Task(String name) {
        this();
        this.setName(name);
    }

    public Task() {
        this.setName(this.getClass().getName());
    }

    void setSession(TaskSession session) {
        this.session = session;
    }

    public TaskSession getSession() {
        return this.session;
    }

    public <E> E getSession(Class<E> clss) {
        if (this.getSession() != null && this.getSession().getClass().equals(clss)) {
            return clss.cast(this.getSession());
        }
        return null;
    }

    public final synchronized List<Task<?>> removeNestedTasks() {
        ArrayList list = new ArrayList(this.nestedTasks);
        this.nestedTasks.clear();
        return list;
    }

    public final synchronized List<Task<?>> getNestedTasks() {
        return Collections.unmodifiableList(this.nestedTasks);
    }

    protected final synchronized void addNestedTask(Task<?> task) {
        if (!this.nestedTasks.contains(task)) {
            this.nestedTasks.add(task);
        }
    }

    void setBackgroundTimeSpent(long backgroundTimeSpent) {
        this.backgroundTimeSpent = backgroundTimeSpent;
    }

    public long getBackgroundTimeSpent() {
        return this.backgroundTimeSpent;
    }

    public final String getId() {
        return this.id;
    }

    void setCancelToken(CancelToken cancelToken) {
        this.cancelToken = cancelToken;
    }

    void clearCancelToken() {
        this.cancelToken = null;
    }

    void setHasException(boolean hasException) {
        this.hasException = hasException;
    }

    boolean hasException() {
        return this.hasException;
    }

    public void handleException(Exception e) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.getRootModel() != null) {
            String groupdId = this.getRootModel().getGroupId();
            String controllerId = this.getRootModel().getControllerId();
            parameters.put("CONTROLLER_GROUP_ID", groupdId);
            parameters.put("CONTROLLER_ID", controllerId);
        }
        Application.getHandlerExceptionManager().handle(this.getException(), parameters);
    }

    public final void setRootModel(ControllerModel controllerModel) {
        this.rootControllerModel = controllerModel;
    }

    public final ControllerModel getRootModel() {
        return this.rootControllerModel;
    }

    public final <E> E rootModelTo(Class<E> clss) {
        return clss.cast(this.getRootModel());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isWaitForEDT() {
        return this.waitForEDT;
    }

    public void setWaitForEDT(boolean waitForEDT) {
        this.waitForEDT = waitForEDT;
    }

    public void canceled() {
    }

    void setSubmitted(boolean submitted) {
        this.submitted = submitted;
    }

    public final boolean isSubmitted() {
        return this.submitted;
    }

    public void cancel() {
        if (!this.isExecuted()) {
            this.canceled = true;
        }
    }

    public T getResult() {
        return this.result;
    }

    protected void setResult(T result) {
        this.result = result;
    }

    void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isCanceled() {
        return this.canceled || this.cancelToken != null && this.cancelToken.cancel;
    }

    protected void submitted() {
    }

    protected void willExecute() throws Exception {
    }

    public void done() {
    }

    void setExecuted() {
        if (!this.isCanceled()) {
            this.executed = true;
        }
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void retry() {
        if (!this.hasException) {
            throw new TaskExeception("Task without exception");
        }
        this.setSubmitted(false);
        this.setHasException(false);
        this.setPriority();
        Application.getTaskManager().submit(this);
    }

    void setPriority() {
        this.priority = true;
    }

    boolean isPriority() {
        return this.priority;
    }

    void clearPriority() {
        this.priority = false;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (this.isCanceled() || this.hasException()) {
            return;
        }
        long s = System.currentTimeMillis();
        List<DebugResult> taskDebugLogs = null;
        try {
            taskDebugLogs = Application.getTaskManager().addToDebugWindow(this, TaskEvent.DO_IN_BACKGROUND);
            this.doInBackground();
        }
        catch (Exception e) {
            this.setHasException(true);
            this.setException(e);
        }
        finally {
            this.setBackgroundTimeSpent(System.currentTimeMillis() - s);
            if (taskDebugLogs != null) {
                for (DebugResult dr : taskDebugLogs) {
                    if (!(dr instanceof TaskDebugLog)) continue;
                    TaskDebugLog tdl = (TaskDebugLog)dr;
                    tdl.setTimeSpent(this.getBackgroundTimeSpent());
                }
            }
            this.setExecuted();
        }
    }

    public void doInBackground() throws Exception {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Task other = (Task)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getId() + "]";
    }

    public TaskExecutionUI getTaskExecutionUI() {
        return this.taskExecutionUI;
    }

    public void setTaskExecutionUI(TaskExecutionUI taskExecutionUI) {
        this.taskExecutionUI = taskExecutionUI;
    }
}

