/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.japura.task.Task;
import org.japura.task.ui.TaskExecutionUI;
import org.japura.util.InputEventBlocker;

public abstract class AbstractTaskExecutionUI
implements TaskExecutionUI {
    private int delay = 500;
    private int count;
    private Starter starter;
    private InputEventBlocker eventHook = new InputEventBlocker();

    public void setDelay(int delay) {
        this.delay = delay = Math.max(delay, 0);
    }

    public int getDelay() {
        return this.delay;
    }

    protected abstract void initialize();

    protected abstract void delayedStart();

    protected abstract void update(Task<?> var1);

    protected abstract void finish();

    @Override
    public void submitted(Task<?> task) {
        ++this.count;
        if (this.count == 1) {
            this.eventHook.apply();
            this.initialize();
            this.starter = new Starter();
            this.starter.start();
        }
    }

    @Override
    public void beforeExecute(final Task<?> task) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractTaskExecutionUI.this.update(task);
            }
        });
    }

    @Override
    public void afterExecute(Task<?> task) {
        --this.count;
        if (this.count == 0) {
            this.starter.stop();
            this.starter = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractTaskExecutionUI.this.eventHook.remove();
                    AbstractTaskExecutionUI.this.finish();
                }
            });
        }
    }

    private class Starter
    extends Timer
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private boolean stop;

        public Starter() {
            super(AbstractTaskExecutionUI.this.getDelay(), null);
            this.addActionListener(this);
            this.setRepeats(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.stop) {
                AbstractTaskExecutionUI.this.delayedStart();
                AbstractTaskExecutionUI.this.eventHook.remove();
            }
        }

        @Override
        public void stop() {
            this.stop = true;
            super.stop();
        }
    }
}

