/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task.ui;

import javax.swing.Icon;
import javax.swing.JLayeredPane;
import org.japura.controller.Controller;
import org.japura.controller.ControllerModel;
import org.japura.gui.ExecutionPanel;
import org.japura.task.Task;
import org.japura.task.ui.AbstractTaskExecutionUI;

public class ModalProgressBarUI
extends AbstractTaskExecutionUI {
    private String groupId;
    private Icon progressBarIcon;
    private ExecutionPanel panel;

    public ModalProgressBarUI(String groupId) {
        this(groupId, null);
    }

    public ModalProgressBarUI(String groupId, Icon progressBarIcon) {
        this.groupId = groupId;
        this.progressBarIcon = progressBarIcon;
    }

    @Override
    protected void initialize() {
        this.panel = new ExecutionPanel("", this.progressBarIcon);
    }

    @Override
    protected void delayedStart() {
        ControllerModel controller = Controller.getRoot(this.groupId);
        if (controller != null) {
            controller.addModal(this.panel, null, JLayeredPane.POPUP_LAYER + 1);
            this.panel.start();
        }
    }

    @Override
    public void update(Task<?> task) {
        if (task.getMessage() != null) {
            this.panel.setText(task.getMessage());
        }
    }

    @Override
    protected void finish() {
        this.panel.stop();
        ControllerModel rootController = Controller.getRoot(this.groupId);
        if (rootController != null) {
            rootController.closeModal(this.panel);
        }
        this.panel = null;
    }
}

