/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.store.db.AbstractDBStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.tools.util.CompareUtils;

public class JDBCStoreParametersBase
extends AbstractDBStoreParameters
implements JDBCStoreParameters {
    public JDBCStoreParametersBase() {
        super("JDBC2StoreParameters", "JDBC2");
    }

    protected JDBCStoreParametersBase(String parametersDefinitionName) {
        super(parametersDefinitionName, "JDBC2");
    }

    public JDBCStoreParametersBase(String parametersDefinitionName, String providerName) {
        super(parametersDefinitionName, providerName);
    }

    public boolean isValid() {
        return this.getHost() != null;
    }

    public String getHost() {
        return (String)this.getDynValue("host");
    }

    public Integer getPort() {
        return (Integer)this.getDynValue("port");
    }

    public int getBatchSize() {
        try {
            return (Integer)this.getDynValue("batchSize");
        }
        catch (Exception ex) {
            return 500;
        }
    }

    public String getDBName() {
        return (String)this.getDynValue("dbname");
    }

    public String getUser() {
        return (String)this.getDynValue("dbuser");
    }

    public String getPassword() {
        return (String)this.getDynValue("password");
    }

    public void setHost(String host) {
        this.setDynValue("host", host);
    }

    public void setPort(int port) {
        this.setDynValue("port", port);
    }

    public void setPort(Integer port) {
        this.setDynValue("port", port);
    }

    public void setDBName(String dbName) {
        this.setDynValue("dbname", dbName);
    }

    public void setUser(String user) {
        this.setDynValue("dbuser", user);
    }

    public void setPassword(String password) {
        this.setDynValue("password", password);
    }

    public void setJDBCDriverClassName(String className) {
        this.setDynValue("jdbcdriverclass", className);
    }

    public String getJDBCDriverClassName() {
        return (String)this.getDynValue("jdbcdriverclass");
    }

    public String getCatalog() {
        return (String)this.getDynValue("catalog");
    }

    public void setCatalog(String catalog) {
        this.setDynValue("catalog", catalog);
    }

    public String getSchema() {
        return (String)this.getDynValue("schema");
    }

    public void setSchema(String schema) {
        this.setDynValue("schema", schema);
    }

    public String getTable() {
        return (String)this.getDynValue("Table");
    }

    public void setTable(String table) {
        this.setDynValue("Table", table);
    }

    public String getFieldsString() {
        return (String)this.getDynValue("Fields");
    }

    public String[] getFields() {
        String fields = (String)this.getDynValue("Fields");
        if (fields == null) {
            return null;
        }
        return fields.split(",");
    }

    public void setFields(String fields) {
        this.setDynValue("Fields", fields);
    }

    public void setFields(String[] fields) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < fields.length - 1; ++i) {
            str.append(fields[i]);
            str.append(",");
        }
        str.append(fields[fields.length - 1]);
        this.setDynValue("Fields", str.toString());
    }

    public String getSQL() {
        return (String)this.getDynValue("SQL");
    }

    public void setSQL(String sql) {
        this.setDynValue("SQL", sql);
    }

    public String getBaseFilter() {
        return (String)this.getDynValue("BaseFilter");
    }

    public void setBaseFilter(String initialFilter) {
        this.setDynValue("BaseFilter", initialFilter);
    }

    public String getBaseOrder() {
        return (String)this.getDynValue("BaseOrder");
    }

    public void setBaseOrder(String order) {
        this.setDynValue("BaseOrder", order);
    }

    public String getPkFieldsString() {
        return (String)this.getDynValue("PKFields");
    }

    public String[] getPkFields() {
        String fields = (String)this.getDynValue("PKFields");
        if (fields == null) {
            return null;
        }
        return fields.split(",");
    }

    public void setPkFields(String fields) {
        this.setDynValue("PKFields", fields);
    }

    public void setPkFields(String[] fields) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < fields.length - 1; ++i) {
            str.append(fields[i]);
            str.append(",");
        }
        str.append(fields[fields.length - 1]);
        this.setDynValue("PKFields", str.toString());
    }

    public String tableID() {
        if (StringUtils.isEmpty((CharSequence)this.getSchema())) {
            return this.escapeName(this.getTable());
        }
        return this.escapeName(this.getSchema()) + "." + this.escapeName(this.getTable());
    }

    protected String escapeName(String name) {
        return "\"".concat(name).concat("\"");
    }

    public String getUrl() {
        return (String)this.getDynValue("url");
    }

    public void setUrl(String url) {
        this.setDynValue("url", url);
    }

    public JDBCStoreParametersBase getCopy() {
        return (JDBCStoreParametersBase)super.getCopy();
    }

    public void setBatchSize(int batchSize) {
        this.setDynValue("batchSize", batchSize);
    }

    public boolean isTheSameStore(DataStoreParameters params) {
        if (!(params instanceof JDBCStoreParametersBase)) {
            return false;
        }
        if (!this.isTheSameExplorer(params)) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)((JDBCStoreParametersBase)params).getTable(), (CharSequence)this.getTable())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)((JDBCStoreParametersBase)params).getSchema(), (CharSequence)this.getSchema())) {
            return false;
        }
        return StringUtils.equals((CharSequence)((JDBCStoreParametersBase)params).getSQL(), (CharSequence)this.getSQL());
    }

    public boolean isTheSameExplorer(DataStoreParameters params) {
        if (!(params instanceof JDBCStoreParametersBase)) {
            return false;
        }
        JDBCStoreParametersBase jdbcParams = (JDBCStoreParametersBase)params;
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.getHost(), (CharSequence)jdbcParams.getHost())) {
            return false;
        }
        if (CompareUtils.compare((Comparable)this.getPort(), (Comparable)jdbcParams.getPort()) != 0) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)this.getDBName(), (CharSequence)jdbcParams.getDBName());
    }

    public String getSourceId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getTable());
        builder.append("(");
        boolean needComma = false;
        if (StringUtils.isNotBlank((CharSequence)this.getHost())) {
            builder.append("host=");
            builder.append(this.getHost());
            needComma = true;
        }
        if (this.getPort() > 0) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("port=");
            builder.append(this.getPort());
            needComma = true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDBName())) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("db=");
            builder.append(this.getDBName());
            needComma = true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.getSchema())) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("schema=");
            builder.append(this.getSchema());
            needComma = true;
        }
        builder.append(")");
        return builder.toString();
    }
}

