/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.expressionbuilder.formatters;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.geom.Geometry;

public class $Constant
implements Formatter<ExpressionBuilder.Value> {
    private final SQLBuilder sqlbuilder;
    private final Formatter<ExpressionBuilder.Value> formatter;

    public $Constant(SQLBuilder sqlbuilder, Formatter<ExpressionBuilder.Value> formatter) {
        this.sqlbuilder = sqlbuilder;
        this.formatter = formatter;
    }

    public boolean canApply(ExpressionBuilder.Value value) {
        if (value instanceof ExpressionBuilder.Function) {
            return StringUtils.equalsIgnoreCase((CharSequence)"$CONSTANT", (CharSequence)((ExpressionBuilder.Function)value).name());
        }
        return false;
    }

    public String format(ExpressionBuilder.Value value) {
        return $Constant.resolve(this.sqlbuilder, this.formatter, value);
    }

    public static boolean isConstant(ExpressionBuilder.Value value) {
        if (value instanceof ExpressionBuilder.Constant) {
            return true;
        }
        return value instanceof ExpressionBuilder.Function && StringUtils.equalsIgnoreCase((CharSequence)((ExpressionBuilder.Function)value).name(), (CharSequence)"$CONSTANT");
    }

    public static String resolve(SQLBuilder sqlbuilder, Formatter<ExpressionBuilder.Value> formatter, ExpressionBuilder.Value value) {
        GeometryExpressionBuilder builder = sqlbuilder.expression();
        if (value instanceof ExpressionBuilder.Constant) {
            Object x = ((ExpressionBuilder.Constant)value).value();
            return builder.constant(x).toString(formatter);
        }
        if (value instanceof ExpressionBuilder.Function && StringUtils.equalsIgnoreCase((CharSequence)((ExpressionBuilder.Function)value).name(), (CharSequence)"$CONSTANT")) {
            SymbolTable symbolTable = (SymbolTable)value.getProperty("SymbolTable");
            Object x = ExpressionUtils.evaluate((SymbolTable)symbolTable, (String)value.toString());
            if (x instanceof Geometry && builder instanceof GeometryExpressionBuilder) {
                GeometryExpressionBuilder gbuilder = builder;
                Geometry geom = (Geometry)x;
                String hexwkb = geom.convertToHexWKBQuietly();
                ExpressionBuilder.Function v = gbuilder.ST_GeomFromWKB((ExpressionBuilder.Value)gbuilder.decode((ExpressionBuilder.Value)gbuilder.constant((Object)hexwkb), (ExpressionBuilder.Value)gbuilder.constant((Object)"hex")), (ExpressionBuilder.Value)gbuilder.constant(sqlbuilder.srs_id(geom.getProjection())));
                return v.toString(formatter);
            }
            return builder.constant(x).toString(formatter);
        }
        throw new RuntimeException("Expected constant value or $$CONSTANT function (" + Objects.toString(value) + ").");
    }

    public static ExpressionBuilder.Constant resolveAsConstant(SQLBuilder sqlbuilder, Formatter<ExpressionBuilder.Value> formatter, ExpressionBuilder.Value value) {
        GeometryExpressionBuilder builder = sqlbuilder.expression();
        if (value instanceof ExpressionBuilder.Constant) {
            Object x = ((ExpressionBuilder.Constant)value).value();
            return builder.constant(x);
        }
        if (value instanceof ExpressionBuilder.Function && StringUtils.equalsIgnoreCase((CharSequence)((ExpressionBuilder.Function)value).name(), (CharSequence)"$CONSTANT")) {
            SymbolTable symbolTable = (SymbolTable)value.getProperty("SymbolTable");
            Object x = ExpressionUtils.evaluate((SymbolTable)symbolTable, (String)value.toString());
            return builder.constant(x);
        }
        throw new RuntimeException("Expected constant value or $$CONSTANT function (" + Objects.toString(value) + ").");
    }
}

