/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AbstractConnectionOperation;

public class ExecuteOperation
extends AbstractConnectionOperation {
    private final String sql;

    public ExecuteOperation(JDBCHelper helper, String sql) {
        super(helper);
        this.sql = sql;
    }

    @Override
    public final Object perform(JDBCConnection conn) throws DataException {
        return this.execute(this.sql);
    }

    public Object execute(String sql) {
        Statement st = null;
        ResultSet rs = null;
        try {
            String mode;
            try {
                String sqltrim = sql.trim();
                mode = StringUtils.left((String)sqltrim, (int)sqltrim.indexOf(32)).toLowerCase();
            }
            catch (Exception e) {
                mode = "unknown";
            }
            switch (mode) {
                case "select": {
                    st = this.getConnection().createStatement(sql, 1004, 1007);
                    rs = JDBCUtils.executeQuery(st, sql);
                    break;
                }
                case "update": {
                    st = this.getConnection().createStatement(sql);
                    JDBCUtils.executeUpdate(st, sql);
                    break;
                }
                default: {
                    st = this.getConnection().createStatement(sql);
                    JDBCUtils.execute(st, sql);
                }
            }
            if (rs == null) {
                JDBCUtils.closeQuietly(st);
                return null;
            }
            if (rs.getMetaData().getColumnCount() > 1) {
                return rs;
            }
            if (!rs.next()) {
                rs.close();
                JDBCUtils.closeQuietly(st);
                return null;
            }
            if (rs.isFirst() && rs.isLast()) {
                Object res = rs.getObject(1);
                rs.close();
                JDBCUtils.closeQuietly(st);
                return res;
            }
            rs.previous();
            return rs;
        }
        catch (Exception ex) {
            JDBCUtils.closeQuietly(rs);
            JDBCUtils.closeQuietly(st);
            throw new RuntimeException("Can't execute query [" + sql + "].", ex);
        }
    }

    @Override
    protected void closeConnection(Object result) throws Exception {
        if (!(result instanceof ResultSet)) {
            this.getConnection().close();
            this.conn = null;
        }
    }
}

