/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCSQLException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AbstractConnectionOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.ResultSetForSetProviderOperation;

public class FetchFeatureProviderByReferenceOperation
extends AbstractConnectionOperation {
    private final FeatureType featureType;
    private final FeatureReferenceProviderServices reference;
    private final OperationsFactory.TableReference table;

    public FetchFeatureProviderByReferenceOperation(JDBCHelper helper, FeatureReferenceProviderServices reference, FeatureType featureType, OperationsFactory.TableReference table) {
        super(helper);
        this.reference = reference;
        this.table = table;
        this.featureType = featureType;
    }

    @Override
    public final Object perform(JDBCConnection conn) throws DataException {
        FeatureProvider feature = this.fetchFeatureProviderByReference(conn);
        return feature;
    }

    public String getSQL() {
        ArrayList<FeatureAttributeDescriptor> columns = new ArrayList<FeatureAttributeDescriptor>();
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        String sql = this.getSQL(sqlbuilder, columns);
        return sql;
    }

    public String getSQL(JDBCSQLBuilderBase sqlbuilder, List<FeatureAttributeDescriptor> columns) {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        for (String primaryKey : this.reference.getKeyNames()) {
            primaryKeys.add(primaryKey);
        }
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        expbuilder.setProperty("FeatureType", (Object)this.featureType);
        expbuilder.setProperty("Table", (Object)this.table);
        expbuilder.setProperty("TableName", (Object)this.table.getTable());
        expbuilder.setProperty("JDBCHelper", (Object)this.helper);
        SQLBuilder.SelectBuilder select = sqlbuilder.select();
        select.from().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        ResultSetForSetProviderOperation.process1_SimpleFields(this.helper, this.featureType, null, (SQLBuilder)sqlbuilder, select, columns, primaryKeys, null);
        ResultSetForSetProviderOperation.process2_ComputedFields(this.helper, this.featureType, null, (SQLBuilder)sqlbuilder, select, null);
        for (String name : primaryKeys) {
            Object value;
            if (!select.has_column(name)) {
                select.column().name(name);
                columns.add(this.featureType.getAttributeDescriptor(name));
            }
            if ((value = this.reference.getKeyValue(name)) == null) {
                select.where().and((ExpressionBuilder.Value)expbuilder.is_null((ExpressionBuilder.Value)select.column(name)));
                continue;
            }
            select.where().and((ExpressionBuilder.Value)expbuilder.eq((ExpressionBuilder.Value)select.column(name), (ExpressionBuilder.Value)expbuilder.parameter(name).value(value)));
        }
        select.limit(1L);
        sqlbuilder.setProperties(null, new Object[]{"FeatureType", this.featureType, "Table", this.table, "JDBCHelper", this.helper});
        this.helper.expandCalculedColumns(sqlbuilder);
        this.helper.processSpecialFunctions((SQLBuilder)sqlbuilder, this.featureType, null, null);
        String sql = StringUtils.trim((String)sqlbuilder.toString());
        return sql;
    }

    public FeatureProvider fetchFeatureProviderByReference(JDBCConnection conn) throws DataException {
        FeatureProvider featureProvider;
        ResultSet rs;
        PreparedStatement st;
        String sql;
        ArrayList<FeatureAttributeDescriptor> columns;
        block5: {
            columns = new ArrayList<FeatureAttributeDescriptor>();
            JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
            sql = this.getSQL(sqlbuilder, columns);
            st = null;
            rs = null;
            st = conn.prepareStatement(sql);
            sqlbuilder.setParameters(st);
            rs = JDBCUtils.executeQuery(st, sql);
            if (rs.next()) break block5;
            FeatureProvider featureProvider2 = null;
            JDBCUtils.closeQuietly(st);
            JDBCUtils.closeQuietly(rs);
            return featureProvider2;
        }
        try {
            FeatureProvider data = this.helper.createFeature(this.featureType);
            this.helper.fetchFeature(data, rs, columns.toArray(new FeatureAttributeDescriptor[columns.size()]), null);
            featureProvider = data;
        }
        catch (SQLException ex) {
            try {
                throw new JDBCSQLException(ex, sql);
            }
            catch (Throwable throwable) {
                JDBCUtils.closeQuietly(st);
                JDBCUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        JDBCUtils.closeQuietly(st);
        JDBCUtils.closeQuietly(rs);
        return featureProvider;
    }
}

