/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCExecuteSQLException;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCSQLException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AbstractConnectionWritableOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.FetchFeatureTypeOperation;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.util.Bitmask;
import org.gvsig.tools.util.Invocable;

public class PerformChangesOperation
extends AbstractConnectionWritableOperation {
    protected OperationsFactory.TableReference table;
    protected FeatureType featureType;
    protected FeatureType featureTypeSource;
    protected FeatureType featureTypeTarget;
    protected Iterator<FeatureReferenceProviderServices> deleteds;
    protected Iterator<FeatureProvider> updateds;
    protected Iterator<FeatureProvider> inserteds;
    protected boolean typeChanged = false;
    protected final FeatureStoreProviderServices storeServices;

    public PerformChangesOperation(JDBCHelper helper) {
        this(helper, null, null, null, null, null, null, null);
    }

    public PerformChangesOperation(JDBCHelper helper, OperationsFactory.TableReference table, FeatureType featureType, Iterator<FeatureReferenceProviderServices> deleteds, Iterator<FeatureProvider> inserteds, Iterator<FeatureProvider> updateds, Iterator<FeatureType.FeatureTypeChanged> featureTypesChanged, FeatureStoreProviderServices storeServices) {
        super(helper);
        this.deleteds = deleteds;
        this.inserteds = inserteds;
        this.updateds = updateds;
        this.table = table;
        this.featureType = featureType;
        if (featureTypesChanged.hasNext()) {
            FeatureType.FeatureTypeChanged item = featureTypesChanged.next();
            this.featureTypeSource = item.getSource();
            this.featureTypeTarget = item.getTarget();
            this.typeChanged = true;
        } else {
            this.featureTypeSource = null;
            this.featureTypeTarget = null;
            this.typeChanged = false;
        }
        this.storeServices = storeServices;
    }

    public boolean isTypeChanged() {
        return this.typeChanged;
    }

    @Override
    public Object perform(JDBCConnection conn) throws DataException {
        if (this.typeChanged) {
            this.performUpdateTable(conn);
        }
        if (this.inserteds.hasNext()) {
            this.performInserts(conn);
        }
        if (this.updateds.hasNext()) {
            this.performUpdates(conn);
        }
        if (this.deleteds.hasNext()) {
            this.performDeletes(conn);
        }
        return true;
    }

    public String getDeleteSQL() {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        return this.getDeleteSQL(sqlbuilder);
    }

    public String getDeleteSQL(JDBCSQLBuilderBase sqlbuilder) {
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        sqlbuilder.delete().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        for (FeatureAttributeDescriptor attr : this.featureType) {
            if (!attr.isPrimaryKey()) continue;
            sqlbuilder.delete().where().and((ExpressionBuilder.Value)expbuilder.eq((ExpressionBuilder.Value)expbuilder.column(attr.getName()), (ExpressionBuilder.Value)expbuilder.parameter(attr.getName()).as_variable()));
        }
        if (!sqlbuilder.delete().has_where()) {
            throw new RuntimeException("Operation requires missing pk");
        }
        sqlbuilder.setProperties(ExpressionBuilder.Variable.class, new Object[]{"Table", this.table});
        String sql = sqlbuilder.delete().toString();
        return sql;
    }

    public void performDeletes(JDBCConnection conn) throws DataException {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        String sql = this.getDeleteSQL(sqlbuilder);
        this.perform_batchmode(conn, this.deleteds, sqlbuilder, sql, new Invocable(){

            public Object call(Object ... args) {
                JDBCSQLBuilderBase sqlbuilder = (JDBCSQLBuilderBase)((Object)args[0]);
                PreparedStatement preparedStatement = (PreparedStatement)args[1];
                FeatureReference reference = (FeatureReference)args[2];
                Disposable theParametersDisposable = sqlbuilder.setParameters(preparedStatement, reference);
                return theParametersDisposable;
            }
        });
    }

    public String getInsertSQL() {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        return this.getInsertSQL(sqlbuilder);
    }

    public String getInsertSQL(JDBCSQLBuilderBase sqlbuilder) {
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        sqlbuilder.insert().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        for (FeatureAttributeDescriptor attr : this.featureType) {
            if (attr.isComputed()) continue;
            if (attr.getType() == 66) {
                sqlbuilder.insert().column().name(attr.getName()).with_value((ExpressionBuilder.Value)expbuilder.parameter(attr.getName()).as_variable().srs((ExpressionBuilder.Value)expbuilder.parameter().value((Object)attr.getSRS()).as_constant()));
                continue;
            }
            sqlbuilder.insert().column().name(attr.getName()).with_value((ExpressionBuilder.Value)expbuilder.parameter(attr.getName()));
        }
        sqlbuilder.setProperties(ExpressionBuilder.Variable.class, new Object[]{"FeatureType", this.featureType, "Table", this.table});
        sqlbuilder.setProperties(ExpressionBuilder.Parameter.class, new Object[]{"FeatureType", this.featureType, "Table", this.table});
        String sql = sqlbuilder.insert().toString();
        return sql;
    }

    public void performInserts(JDBCConnection conn) throws DataException {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        String sql = this.getInsertSQL(sqlbuilder);
        this.perform_batchmode(conn, this.inserteds, sqlbuilder, sql, new Invocable(){

            public Object call(Object ... args) {
                JDBCSQLBuilderBase sqlbuilder = (JDBCSQLBuilderBase)((Object)args[0]);
                PreparedStatement preparedStatement = (PreparedStatement)args[1];
                FeatureProvider feature = (FeatureProvider)args[2];
                Disposable theParametersDisposable = sqlbuilder.setParameters(preparedStatement, feature);
                return theParametersDisposable;
            }
        });
    }

    public String getUpdateSQL() {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        return this.getUpdateSQL(sqlbuilder);
    }

    public String getUpdateSQL(JDBCSQLBuilderBase sqlbuilder) {
        if (!this.featureType.hasPrimaryKey()) {
            throw new RuntimeException("Operation requires missing pk");
        }
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        sqlbuilder.update().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        for (FeatureAttributeDescriptor attr : this.featureType) {
            if (attr.isPrimaryKey()) {
                sqlbuilder.update().where().and((ExpressionBuilder.Value)expbuilder.eq((ExpressionBuilder.Value)expbuilder.column(attr.getName()), (ExpressionBuilder.Value)expbuilder.parameter(attr.getName()).as_variable()));
                continue;
            }
            if (attr.isAutomatic() || attr.isReadOnly() || attr.isComputed()) continue;
            if (attr.getType() == 66) {
                if (attr.getSRS() == null) {
                    throw new RuntimeException("Geometries with null srs are not valid. SRS is required in " + this.table.toString() + "in the field:" + attr.getName());
                }
                sqlbuilder.update().column().name(attr.getName()).with_value((ExpressionBuilder.Value)expbuilder.parameter(attr.getName()).as_geometry_variable().srs((ExpressionBuilder.Value)expbuilder.parameter().value((Object)attr.getSRS()).as_constant()));
                continue;
            }
            sqlbuilder.update().column().name(attr.getName()).with_value((ExpressionBuilder.Value)expbuilder.parameter(attr.getName()).as_variable());
        }
        if (!sqlbuilder.update().has_where()) {
            throw new RuntimeException("Operation requires missing pk");
        }
        sqlbuilder.setProperties(ExpressionBuilder.Variable.class, new Object[]{"FeatureType", this.featureType, "Table", this.table});
        sqlbuilder.setProperties(ExpressionBuilder.Parameter.class, new Object[]{"FeatureType", this.featureType, "Table", this.table});
        String sql = sqlbuilder.update().toString();
        return sql;
    }

    public void performUpdates(JDBCConnection conn) throws DataException {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        String sql = this.getUpdateSQL(sqlbuilder);
        this.perform_batchmode(conn, this.updateds, sqlbuilder, sql, new Invocable(){

            public Object call(Object ... args) {
                JDBCSQLBuilderBase sqlbuilder = (JDBCSQLBuilderBase)((Object)args[0]);
                PreparedStatement preparedStatement = (PreparedStatement)args[1];
                FeatureProvider feature = (FeatureProvider)args[2];
                Disposable theParametersDisposable = sqlbuilder.setParameters(preparedStatement, feature);
                return theParametersDisposable;
            }
        });
    }

    private void perform_batchmode(JDBCConnection conn, Iterator elements, JDBCSQLBuilderBase sqlbuilder, String sql, Invocable fillPreparedStatement) throws DataException {
        int batchSize = this.helper.getConnectionParameters().getBatchSize();
        if (batchSize == 0) {
            try {
                PreparedStatement preparedStatement = conn.prepareStatement(sql);
                while (elements.hasNext()) {
                    Object element = elements.next();
                    Disposable theParametersDisposable = (Disposable)fillPreparedStatement.call(new Object[]{sqlbuilder, preparedStatement, element});
                    JDBCUtils.execute(preparedStatement, sql);
                    DisposeUtils.disposeQuietly((Disposable)theParametersDisposable);
                }
            }
            catch (Exception ex) {
                throw new JDBCExecuteSQLException(sql + " (" + Objects.toString(elements) + ")", ex);
            }
        }
        try {
            PreparedStatement preparedStatement = conn.prepareStatement(sql);
            if (batchSize < 1) {
                batchSize = 200;
            }
            int batchCount = 0;
            Disposable[] disposableParameters = new Disposable[batchSize];
            while (elements.hasNext()) {
                Object element = elements.next();
                Disposable theParametersDisposable = (Disposable)fillPreparedStatement.call(new Object[]{sqlbuilder, preparedStatement, element});
                JDBCUtils.addBatch(preparedStatement, sql);
                disposableParameters[batchCount++] = theParametersDisposable;
                if (batchCount < batchSize && (elements.hasNext() || batchCount <= 0)) continue;
                int[] status = JDBCUtils.executeBatch(preparedStatement, sql);
                preparedStatement.clearParameters();
                preparedStatement.clearBatch();
                for (int i = 0; i < batchCount && i < disposableParameters.length; ++i) {
                    DisposeUtils.dispose((Disposable)disposableParameters[i]);
                    disposableParameters[i] = null;
                }
                batchCount = 0;
                for (int n : status) {
                    if (n > -3) continue;
                    throw new RuntimeException("Can't process element (n=" + n + ").");
                }
            }
        }
        catch (Exception ex) {
            throw new JDBCExecuteSQLException(sql, ex);
        }
    }

    protected FeatureType getCurrentFeatureTypeDB() {
        if (this.storeServices == null) {
            return this.featureTypeSource;
        }
        try {
            JDBCStoreParameters params = (JDBCStoreParameters)this.storeServices.getFeatureStore().getParameters();
            EditableFeatureType type = this.storeServices.createFeatureType(this.storeServices.getName());
            FetchFeatureTypeOperation fetchFeatureType = this.helper.getOperations().createFetchFeatureType(type, this.table, params.getPkFields() == null ? null : Arrays.asList(params.getPkFields()), params.getDefaultGeometryField(), params.getCRS(), params.getGeometryType(), params.getGeometrySubtype());
            fetchFeatureType.perform(this.getConnection());
            return type;
        }
        catch (Throwable t) {
            LOGGER.warn("Can't get current feature type from database of table = " + Objects.toString(this.table), t);
            return this.featureTypeSource;
        }
    }

    public List<String> getUpdateTableSQLs() {
        FeatureType currentFeatureTypeDB = this.getCurrentFeatureTypeDB();
        Map<String, Bitmask> changes = this.getUpdateTableChanges(currentFeatureTypeDB);
        List<String> sqls = this.getUpdateTableSQLs(currentFeatureTypeDB, changes);
        return sqls;
    }

    public List<String> getUpdateTableSQLs(FeatureType currentFeatureTypeDB, Map<String, Bitmask> changes) {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        SQLBuilder.AlterTableBuilder alter_table = sqlbuilder.alter_table();
        alter_table.setProperty("FeatureType", (Object)this.featureTypeTarget);
        alter_table.table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        for (FeatureAttributeDescriptor attrOriginal : currentFeatureTypeDB) {
            if (attrOriginal.isComputed()) continue;
            FeatureAttributeDescriptor attrTarget = this.featureTypeTarget.getAttributeDescriptor(attrOriginal.getName());
            if (attrTarget == null) {
                sqlbuilder.alter_table().drop_column(attrOriginal.getName());
                continue;
            }
            Bitmask changesAttr = changes.get(attrOriginal.getName());
            if (changesAttr.isEmpty()) continue;
            if (attrTarget.getType() == 66) {
                sqlbuilder.alter_table().alter_geometry_column(changesAttr, attrTarget.getName(), attrTarget.getGeomType().getType(), attrTarget.getGeomType().getSubType(), attrTarget.getSRS(), attrTarget.isIndexed(), attrTarget.allowNull());
                continue;
            }
            Object defaultValue = attrTarget.getDefaultValue();
            if (defaultValue instanceof CharSequence && ExpressionUtils.isDynamicText((String)defaultValue.toString())) {
                defaultValue = null;
            }
            sqlbuilder.alter_table().alter_column(changesAttr, attrTarget.getName(), attrTarget.getType(), attrTarget.getSize(), attrTarget.getPrecision(), attrTarget.getScale(), attrTarget.isPrimaryKey(), attrTarget.isIndexed(), attrTarget.allowNull(), attrTarget.isAutomatic(), defaultValue, attrTarget.allowIndexDuplicateds());
        }
        for (FeatureAttributeDescriptor attrTarget : this.featureTypeTarget) {
            FeatureAttributeDescriptor attrOriginal;
            if (attrTarget.isComputed() || (attrOriginal = currentFeatureTypeDB.getAttributeDescriptor(attrTarget.getName())) != null) continue;
            if (attrTarget.getType() == 66) {
                sqlbuilder.alter_table().add_geometry_column(attrTarget.getName(), attrTarget.getGeomType().getType(), attrTarget.getGeomType().getSubType(), attrTarget.getSRS(), attrTarget.isIndexed(), attrTarget.allowNull());
                continue;
            }
            Object defaultValue = attrTarget.getDefaultValue();
            if (defaultValue instanceof CharSequence && ExpressionUtils.isDynamicText((String)defaultValue.toString())) {
                defaultValue = null;
            }
            sqlbuilder.alter_table().add_column(attrTarget.getName(), attrTarget.getType(), attrTarget.getSize(), attrTarget.getPrecision(), attrTarget.getScale(), attrTarget.isPrimaryKey(), attrTarget.isIndexed(), attrTarget.allowNull(), attrTarget.isAutomatic(), defaultValue, attrTarget.allowIndexDuplicateds());
        }
        sqlbuilder.setProperties(ExpressionBuilder.Variable.class, new Object[]{"Table", this.table});
        List sqls = sqlbuilder.alter_table().toStrings();
        return sqls;
    }

    public Map<String, Bitmask> getUpdateTableChanges(FeatureType currentFeatureTypeDB) {
        Bitmask changesAttr;
        HashMap<String, Bitmask> changes = new HashMap<String, Bitmask>();
        for (FeatureAttributeDescriptor attrOriginal : currentFeatureTypeDB) {
            if (attrOriginal.isComputed()) continue;
            FeatureAttributeDescriptor attrTarget = this.featureTypeTarget.getAttributeDescriptor(attrOriginal.getName());
            if (attrTarget == null) {
                changesAttr = Bitmask.createBitmask((int)0);
                changesAttr.setBit(10);
                changes.put(attrOriginal.getName(), changesAttr);
                continue;
            }
            changesAttr = this.getAlterTableChanges(attrOriginal, attrTarget);
            changes.put(attrOriginal.getName(), changesAttr);
        }
        for (FeatureAttributeDescriptor attrTarget : this.featureTypeTarget) {
            FeatureAttributeDescriptor attrOriginal;
            if (attrTarget.isComputed() || (attrOriginal = currentFeatureTypeDB.getAttributeDescriptor(attrTarget.getName())) != null) continue;
            changesAttr = Bitmask.createBitmask((int)0);
            changesAttr.setBit(11);
            changes.put(attrTarget.getName(), changesAttr);
        }
        return changes;
    }

    protected Bitmask getAlterTableChanges(FeatureAttributeDescriptor src, FeatureAttributeDescriptor target) {
        Bitmask changes = Bitmask.createBitmask((int)0);
        if (src.getType() != target.getType()) {
            changes.setBit(5);
        }
        if (src.getPrecision() != target.getPrecision()) {
            changes.setBit(5);
        }
        if (src.getScale() != target.getScale()) {
            changes.setBit(5);
        }
        if (src.getSize() != target.getSize()) {
            changes.setBit(5);
        }
        if (src.isPrimaryKey() != target.isPrimaryKey()) {
            if (target.isPrimaryKey()) {
                changes.setBit(6);
            } else {
                changes.setBit(7);
            }
        }
        if (src.isIndexed() != target.isIndexed()) {
            if (target.isIndexed()) {
                changes.setBit(8);
            } else {
                changes.setBit(9);
            }
        }
        if (src.isAutomatic() != target.isAutomatic()) {
            changes.setBit(5);
        }
        if (src.allowNull() != target.allowNull()) {
            changes.setBit(4);
        }
        if (src.getDefaultValue() != target.getDefaultValue()) {
            changes.setBit(3);
        }
        return changes;
    }

    public void performUpdateTable(JDBCConnection conn) throws DataException {
        List<String> sqls = this.getUpdateTableSQLs();
        if (!CollectionUtils.isEmpty(sqls)) {
            Statement st = null;
            String currentsql = null;
            try {
                st = conn.createStatement();
                Iterator<String> iterator = sqls.iterator();
                while (iterator.hasNext()) {
                    String sql;
                    currentsql = sql = iterator.next();
                    if (StringUtils.isBlank((CharSequence)sql)) continue;
                    JDBCUtils.execute(st, sql);
                }
            }
            catch (SQLException e) {
                throw new JDBCSQLException(e, currentsql);
            }
            finally {
                JDBCUtils.closeQuietly(st);
            }
        }
    }
}

