/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tasseledcap.swing.impl.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.BasicAPISwingPanel;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.RasterSwingManager;
import org.gvsig.raster.swing.newlayer.CreateNewLayerPanel;
import org.gvsig.raster.swing.pagedtable.ModelLoader;
import org.gvsig.raster.swing.pagedtable.PagedTable;
import org.gvsig.raster.swing.pagedtable.TableModel;
import org.gvsig.raster.tasseledcap.swing.impl.main.BandTableModel;
import org.gvsig.raster.tasseledcap.swing.impl.main.CheckBoxColumnEditor;
import org.gvsig.raster.tasseledcap.swing.impl.main.CheckBoxColumnRenderer;

public class TasseledCapMainPanelImpl
extends JPanel
implements BasicAPISwingPanel {
    private static final long serialVersionUID = 1L;
    private String layerName = null;
    private CreateNewLayerPanel newLayerPanel = null;
    private Object inputStore = null;
    private PagedTable table = null;
    private JCheckBox roisCheck = null;
    private int bandList = 0;
    private String roisEPSG = null;
    private JRadioButton landsatMS = null;
    private JRadioButton landsatTM = null;
    private JRadioButton landsatETM = null;

    public TasseledCapMainPanelImpl(Object inputStore, String layerName, int bandList, String roisEPSG) {
        this.inputStore = inputStore;
        this.layerName = layerName;
        this.bandList = bandList;
        this.roisEPSG = roisEPSG;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        this.add((Component)this.getLayerPanel(), gridBagConstraints1);
        gridBagConstraints1.gridy = 2;
        this.add((Component)this.getOptionsPanel(), gridBagConstraints1);
        gridBagConstraints1.gridy = 3;
        this.add((Component)((JComponent)this.getCreateNewLayerPanel()), gridBagConstraints1);
        if (this.roisEPSG != null) {
            gridBagConstraints1.gridy = 4;
            this.add((Component)this.getROIsCheck(), gridBagConstraints1);
        }
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.getInputsPanel(), gridBagConstraints1);
    }

    private JPanel getLayerPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"layer")));
        p.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        p.add((Component)new JLabel(this.layerName), gridBagConstraints1);
        return p;
    }

    private JPanel getInputsPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"bands")));
        p.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        p.add((Component)this.getPagedTable().getComponent(), "Center");
        return p;
    }

    public JComponent getComponent() {
        return this;
    }

    public PagedTable getPagedTable() {
        if (this.table == null) {
            RasterSwingManager manager = RasterSwingLocator.getSwingManager();
            String[] columnNames = new String[]{"", Messages.getText((String)"bands")};
            int[] columnSizes = new int[]{30, -1};
            BandTableModel model = new BandTableModel(columnNames);
            ModelLoader loader = manager.createModelLoader((TableModel)model);
            CheckBoxColumnRenderer render = new CheckBoxColumnRenderer(null);
            CheckBoxColumnEditor editor = new CheckBoxColumnEditor();
            loader.setRenderForColumn(0, (TableCellRenderer)render);
            loader.setCellEditorForColumn(0, (TableCellEditor)editor);
            loader.setColumnNames(columnNames);
            loader.setColumnWidths(columnSizes);
            this.table = manager.createPagedTable(loader);
            this.table.showControllerTable(false);
            this.table.showMoveRowsControls(false);
        }
        return this.table;
    }

    private JPanel getOptionsPanel() {
        JPanel p = new JPanel();
        ButtonGroup g = new ButtonGroup();
        g.add(this.getLandsatETMRadioButton());
        g.add(this.getLandsatTMRadioButton());
        g.add(this.getLandsatMSRadioButton());
        p.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"options")));
        p.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        p.add((Component)this.getLandsatMSRadioButton(), gridBagConstraints1);
        gridBagConstraints1.gridy = 1;
        p.add((Component)this.getLandsatTMRadioButton(), gridBagConstraints1);
        gridBagConstraints1.gridy = 2;
        p.add((Component)this.getLandsatETMRadioButton(), gridBagConstraints1);
        return p;
    }

    private JRadioButton getLandsatMSRadioButton() {
        if (this.landsatMS == null) {
            this.landsatMS = new JRadioButton("Landsat MS");
            this.landsatMS.setSelected(true);
        }
        return this.landsatMS;
    }

    private JRadioButton getLandsatTMRadioButton() {
        if (this.landsatTM == null) {
            this.landsatTM = new JRadioButton("Landsat TM");
        }
        return this.landsatTM;
    }

    private JRadioButton getLandsatETMRadioButton() {
        if (this.landsatETM == null) {
            this.landsatETM = new JRadioButton("Landsat ETM");
        }
        return this.landsatETM;
    }

    public DataProcess getResult() throws ProcessException {
        DataProcess task = RasterBaseAlgorithmLibrary.getManager().createRasterTask("TasseledCapProcess");
        List params = task.getRasterTaskInputParameters("TasseledCapProcess");
        for (int i = 0; i < params.size(); ++i) {
            String paramName = (String)params.get(i);
            Class paramType = task.getParameterTypeByProcess("TasseledCapProcess", paramName);
            if (paramType == RasterDataStore.class) {
                task.addParam(paramName, (Object)((RasterDataStore)this.inputStore));
            }
            if (paramName.equals("PATH")) {
                String filename = this.newLayerPanel.getDirectorySelected() + File.separator + this.newLayerPanel.getFileSelected();
                if (!filename.endsWith(".tif")) {
                    filename = filename + ".tif";
                }
                task.addParam(paramName, (Object)filename);
            }
            if (paramType == Boolean[].class) {
                boolean[] bands = new boolean[this.getPagedTable().getRowCount()];
                for (int j = 0; j < this.getPagedTable().getRowCount(); ++j) {
                    Object obj = this.getPagedTable().getValueAt(j, 0);
                    if (!(obj instanceof Boolean)) continue;
                    bands[j] = (Boolean)obj;
                }
                task.addParam(paramName, (Object)bands);
            }
            if (this.getROIsCheck().isSelected() && paramName.equals("ROI_EPSG")) {
                task.addParam(paramName, (Object)this.roisEPSG);
            }
            if (paramType != Integer.class) continue;
            int type = this.getSelectedLandsatType();
            task.addParam(paramName, (Object)type);
        }
        return task;
    }

    private int getSelectedLandsatType() {
        if (this.getLandsatMSRadioButton().isSelected()) {
            return 0;
        }
        if (this.getLandsatTMRadioButton().isSelected()) {
            return 1;
        }
        if (this.getLandsatETMRadioButton().isSelected()) {
            return 2;
        }
        return -1;
    }

    public JCheckBox getROIsCheck() {
        if (this.roisCheck == null) {
            this.roisCheck = new JCheckBox(Messages.getText((String)"use_rois"));
        }
        return this.roisCheck;
    }

    public CreateNewLayerPanel getCreateNewLayerPanel() {
        if (this.newLayerPanel == null) {
            this.newLayerPanel = RasterSwingLocator.getSwingManager().createNewLayerPanel();
        }
        return this.newLayerPanel;
    }

    public void initialize() {
        for (int i = 0; i < this.bandList; ++i) {
            this.getPagedTable().addRow(new Object[]{true, "B" + i});
        }
    }

    public int getComponentIDByObject(Object obj) {
        return -1;
    }

    public void addListener(EventListener listener) {
    }
}

