/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.legend.urbanhorizontalsignage.lib.impl.linelegend;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.concurrent.Callable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol_v2;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.UrbanHorizontalSignageLocator;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.UrbanHorizontalSignageManager;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.linelegend.UrbanHorizontalSignageData;
import org.gvsig.legend.urbanhorizontalsignage.lib.impl.linelegend.DefaultUrbanHorizontalSignageData;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractSymbol;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.swing.api.TransparencySupport;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrbanHorizontalSignageSymbol
extends AbstractSymbol
implements ISymbol_v2,
TransparencySupport {
    private static final Logger LOG = LoggerFactory.getLogger(UrbanHorizontalSignageSymbol.class);
    private static final String SYMBOL_NAME = "UrbanHorizontalSignageSymbol";
    private static final String URBAN_HORIZONTAL_SIGNAGE_SYMBOL_PERSISTENCE_DEFINITION_NAME = "UrbanHorizontalSignageSymbol";
    private static final String FIELD_WIDTH = "width";
    private static final String FIELD_CONTINUITY = "continuity";
    private static final String FIELD_SEGMENTS_COLOR = "segmentsColor";
    private static final String FIELD_SEGMENTS_LENGTH = "segmentsLength";
    private static final String FIELD_HOLES_COLOR = "holesColor";
    private static final String FIELD_HOLES_LENGTH = "holesLength";
    private static final String FIELD_PAINT_HOLES = "paintHoles";
    private static final String FIELD_GAP_WIDTH = "gapWidth";
    private static final String FIELD_ROUND_VERTEX = "roundVertex";
    private static final String FIELD_SEGMENTS_GEOMETRY = "segmentsGeometry";
    private static final String FIELD_HOLES_GEOMETRY = "holesGeometry";
    private static final String FIELD_TRANSPARENCY = "transparency";
    private static final String FIELD_MUST_DRAW_ORIGINAL_GEOMETRY = "mustDrawOriginalGeometry";
    private static final String FIELD_COLOR_FOR_ORIGINAL_GEOMETRY = "colorForOriginalGeometry";
    private UrbanHorizontalSignageData data;
    private transient UrbanHorizontalSignageSymbol symbolForSelection;
    private boolean mustDrawOriginalGeometry = false;
    private Color colorForOriginalGeometry;
    private double cartographicSize;
    private double transparency = 1.0;

    public void setData(UrbanHorizontalSignageData data) {
        this.data = data;
    }

    public UrbanHorizontalSignageData getData() {
        return this.data;
    }

    public void setTransparency(double transparency) {
        if (transparency < 0.0 || transparency > 1.0) {
            throw new IllegalArgumentException("Transparency value must be in [0.0, 1.0] (" + transparency + ")");
        }
        this.transparency = transparency;
    }

    public double getTransparency() {
        return this.transparency;
    }

    public ISymbol getSymbolForSelection(Color selectionColor) {
        if (this.symbolForSelection == null) {
            this.symbolForSelection = (UrbanHorizontalSignageSymbol)this.cloneForSelection();
            this.symbolForSelection.mustDrawOriginalGeometry = true;
        }
        this.symbolForSelection.setColor(selectionColor);
        return this.symbolForSelection;
    }

    protected Geometry getSampleGeometry(Rectangle r) {
        int hGap = (int)(r.getWidth() * 0.1);
        boolean vPos = true;
        int splitCount = 3;
        int splitHSize = (r.width - hGap - hGap) / 3;
        int hPos = hGap;
        boolean swap = false;
        Line geom = GeometryUtils.createLine((int)0);
        geom.addVertex((double)(r.x + hPos), (double)(r.y + r.height - 1));
        for (int i = 0; i < 3; ++i) {
            swap = !swap;
            geom.addVertex((double)(r.x + hPos + splitHSize), (double)((swap ? 1 : r.height - 1) + r.y));
            hPos += splitHSize;
        }
        return geom;
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry originalGeometry, Feature feature, Cancellable cancel, Rectangle r) {
        Color color;
        if (r != null) {
            originalGeometry = this.getSampleGeometry(r);
        }
        try {
            Geometry env = originalGeometry.getEnvelope().getGeometry();
            env.transform(affineTransform);
            Envelope env2 = env.getEnvelope();
            if (env2.getLength(0) < 1.5 && env2.getLength(1) < 1.5) {
                Color color2 = this.data.getSegmentsColor();
                Color transparentColor = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), (int)(this.transparency * (double)color2.getAlpha()));
                g.setColor(transparentColor);
                Point upperCorner = env2.getUpperCorner();
                int x = (int)upperCorner.getX();
                int y = (int)upperCorner.getY();
                g.drawLine(x, y, x, y);
                return;
            }
        }
        catch (Exception ex) {
            LOG.warn("Error optimizing the drawing of the geometry. Continues with normal drawing.", (Throwable)ex);
        }
        UrbanHorizontalSignageManager uhsManager = UrbanHorizontalSignageLocator.getUrbanHorizontalSignageManager();
        uhsManager.calculateGeometries(originalGeometry, this.data);
        MultiPolygon geom = this.data.getSegmentsGeometry();
        if (geom != null && geom.getPrimitivesNumber() > 0) {
            color = this.data.getSegmentsColor();
            Shape shape = geom.getShape(affineTransform);
            Color transparentColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(this.transparency * (double)color.getAlpha()));
            g.setColor(transparentColor);
            g.fill(shape);
            g.setColor(color.darker());
            g.draw(shape);
        }
        switch (this.data.getContinuity()) {
            case 2: 
            case 6: 
            case 9: 
            case 10: {
                if (!this.data.isPaintHoles() || (geom = this.data.getHolesGeometry()) == null || geom.getPrimitivesNumber() <= 0) break;
                color = this.data.getHolesColor();
                Color transparentColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(this.transparency * (double)color.getAlpha()));
                g.setColor(transparentColor);
                g.fill(geom.getShape(affineTransform));
            }
        }
        if (this.mustDrawOriginalGeometry) {
            g.setColor(this.getColor());
            g.draw(originalGeometry.getShape(affineTransform));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        UrbanHorizontalSignageSymbol copy = (UrbanHorizontalSignageSymbol)((Object)super.clone());
        if (this.symbolForSelection != null) {
            copy.symbolForSelection = (UrbanHorizontalSignageSymbol)((Object)this.symbolForSelection.clone());
        }
        return copy;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        DefaultUrbanHorizontalSignageData theData = new DefaultUrbanHorizontalSignageData();
        theData.setWidth(state.getDouble(FIELD_WIDTH, 0.15));
        theData.setContinuity(state.getInt(FIELD_CONTINUITY, 1));
        Color color = (Color)state.get(FIELD_SEGMENTS_COLOR);
        theData.setSegmentsColor(color != null ? color : UrbanHorizontalSignageData.DEFAULT_SEGMENT_COLOR_VALUE);
        theData.setSegmentsLength(state.getDouble(FIELD_SEGMENTS_LENGTH, 0.5));
        color = (Color)state.get(FIELD_HOLES_COLOR);
        theData.setHolesColor(color != null ? color : UrbanHorizontalSignageData.DEFAULT_HOLES_COLOR_VALUE);
        theData.setHolesLength(state.getDouble(FIELD_HOLES_LENGTH, 0.5));
        theData.setGapWidth(state.getDouble(FIELD_GAP_WIDTH, 0.15));
        theData.setRoundVertex(state.getBoolean(FIELD_ROUND_VERTEX, false));
        this.transparency = state.getDouble(FIELD_TRANSPARENCY, 1.0);
        this.mustDrawOriginalGeometry = state.getBoolean(FIELD_MUST_DRAW_ORIGINAL_GEOMETRY, false);
        color = (Color)state.get(FIELD_COLOR_FOR_ORIGINAL_GEOMETRY);
        this.colorForOriginalGeometry = color != null ? color : MapContext.DEFAULT_SELECTION_COLOR;
        this.data = theData;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        if (this.data != null) {
            state.set(FIELD_WIDTH, this.data.getWidth());
            state.set(FIELD_CONTINUITY, this.data.getContinuity());
            state.set(FIELD_SEGMENTS_COLOR, (Object)this.data.getSegmentsColor());
            state.set(FIELD_SEGMENTS_LENGTH, this.data.getSegmentsLength());
            state.set(FIELD_HOLES_COLOR, (Object)this.data.getHolesColor());
            state.set(FIELD_HOLES_LENGTH, this.data.getHolesLength());
            state.set(FIELD_PAINT_HOLES, this.data.isPaintHoles());
            state.set(FIELD_GAP_WIDTH, this.data.getGapWidth());
            state.set(FIELD_ROUND_VERTEX, this.data.isRoundVertex());
        }
        state.set(FIELD_MUST_DRAW_ORIGINAL_GEOMETRY, this.mustDrawOriginalGeometry);
        state.set(FIELD_COLOR_FOR_ORIGINAL_GEOMETRY, (Object)this.colorForOriginalGeometry);
        state.set(FIELD_TRANSPARENCY, this.getTransparency());
    }

    public int getSymbolType() {
        return 2;
    }

    public boolean isSuitableFor(Geometry geom) {
        return geom.getGeometryType().isTypeOf(2);
    }

    public Color getColor() {
        return this.colorForOriginalGeometry;
    }

    public void setColor(Color color) {
        this.colorForOriginalGeometry = color;
    }

    public static class RegisterSymbol
    implements Callable {
        public Object call() throws Exception {
            SymbolManager manager = MapContextLocator.getSymbolManager();
            int[] shapeTypes = new int[]{2, 12, 8, 23, 24, 14, 18, 21};
            manager.registerSymbol("UrbanHorizontalSignageSymbol", shapeTypes, UrbanHorizontalSignageSymbol.class);
            return Boolean.TRUE;
        }
    }
}

