/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.swing.impl.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.downloader.DownloaderAuthenticationConfig;
import org.gvsig.downloader.DownloaderAuthenticationFactory;
import org.gvsig.downloader.DownloaderCredentials;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.downloader.swing.DownloaderConfigPanel;
import org.gvsig.downloader.swing.impl.config.DownloaderConfigPanelView;
import org.gvsig.downloader.swing.impl.config.DownloaderConfigServicePanelImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloaderConfigPanelImpl
extends DownloaderConfigPanelView
implements DownloaderConfigPanel {
    public static final Logger LOGGER = LoggerFactory.getLogger(DownloaderConfigPanelImpl.class);

    public DownloaderConfigPanelImpl() {
        this.initComponents();
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        this.translate();
        this.tblAuthenticatedServices.setModel(new AuthenticatedServicesTableModel(downloader));
        this.tblCredentials.setModel(new CredentialsTableModel(downloader));
        DefaultListModel<DownloaderAuthenticationFactory> authenticationTypesModel = new DefaultListModel<DownloaderAuthenticationFactory>();
        for (DownloaderAuthenticationFactory authType : downloader.getAuthenticationTypes()) {
            authenticationTypesModel.addElement(authType);
        }
        this.lstAuthenticationTypes.setModel(authenticationTypesModel);
        this.lstAuthenticationTypes.addListSelectionListener(e -> this.doAuthenticationTypeSelected());
        this.btnAuthenticatedServicesAdd.addActionListener(e -> this.doAuthenticateServiceAdd());
        this.btnAuthenticatedServicesEdit.addActionListener(e -> this.doAuthenticateServiceEdit());
        this.btnAuthenticatedServicesRemove.addActionListener(e -> this.doAuthenticateServiceRemove());
        this.btnCredentialsRemove.addActionListener(e -> this.doCredentialRemove());
        this.tblCredentials.getSelectionModel().addListSelectionListener(e -> this.doCredentialSelectionChanged());
        this.doUpdateComponents();
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)25, (int)120, (int)30, (int)200);
    }

    private void doCredentialSelectionChanged() {
        int row = this.tblCredentials.getSelectedRow();
        if (row < 0) {
            return;
        }
        CredentialsTableModel model = (CredentialsTableModel)this.tblCredentials.getModel();
        DownloaderCredentials credentials = model.getCredentials(row);
        LOGGER.info(credentials.toString());
    }

    private void doUpdateComponents() {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        boolean hasDownloader = downloader != null;
        this.btnAuthenticatedServicesAdd.setEnabled(hasDownloader);
        this.btnAuthenticatedServicesEdit.setEnabled(hasDownloader);
        this.btnAuthenticatedServicesRemove.setEnabled(hasDownloader);
        this.btnCredentialsRemove.setEnabled(hasDownloader);
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.tabDownloaderConfig);
        toolsSwingManager.translate((AbstractButton)this.btnAuthenticatedServicesAdd);
        toolsSwingManager.translate((AbstractButton)this.btnAuthenticatedServicesEdit);
        toolsSwingManager.translate((AbstractButton)this.btnAuthenticatedServicesRemove);
        toolsSwingManager.translate((AbstractButton)this.btnCredentialsRemove);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        return new ImageIcon();
    }

    private void doAuthenticateServiceAdd() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        DownloaderConfigServicePanelImpl panel = new DownloaderConfigServicePanelImpl();
        Dialog dialog = winmanager.createDialog(panel.asJComponent(), i18n.getTranslation("_Add_service"), null, 3);
        dialog.setButtonEnabled(1, panel.isTheConfigurationValid());
        panel.addChangeListener(e -> dialog.setButtonEnabled(1, panel.isTheConfigurationValid()));
        dialog.addActionListener(e -> {
            if (dialog.getAction() != 1) {
                return;
            }
            DownloaderAuthenticationConfig config = panel.fetch();
            DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
            downloader.registerAuthenticationConfigurationService(config);
            this.tblAuthenticatedServices.setModel(new AuthenticatedServicesTableModel(downloader));
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    private DownloaderAuthenticationConfig getSelectedService() {
        AuthenticatedServicesTableModel model = (AuthenticatedServicesTableModel)this.tblAuthenticatedServices.getModel();
        int row = this.tblAuthenticatedServices.getSelectedRow();
        if (row < 0) {
            return null;
        }
        DownloaderAuthenticationConfig selectedConfig = model.getConfig(row);
        return selectedConfig;
    }

    private DownloaderCredentials getSelectedCredential() {
        CredentialsTableModel model = (CredentialsTableModel)this.tblCredentials.getModel();
        int row = this.tblCredentials.getSelectedRow();
        if (row < 0) {
            return null;
        }
        DownloaderCredentials selected = model.getCredentials(row);
        return selected;
    }

    private void doAuthenticateServiceEdit() {
        DownloaderAuthenticationConfig selectedConfig = this.getSelectedService();
        if (selectedConfig == null) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        DownloaderConfigServicePanelImpl panel = new DownloaderConfigServicePanelImpl();
        panel.put(selectedConfig);
        Dialog dialog = winmanager.createDialog(panel.asJComponent(), i18n.getTranslation("_Edit_service"), null, 3);
        dialog.setButtonEnabled(1, panel.isTheConfigurationValid());
        panel.addChangeListener(e -> dialog.setButtonEnabled(1, panel.isTheConfigurationValid()));
        dialog.addActionListener(e -> {
            if (dialog.getAction() != 1) {
                return;
            }
            DownloaderAuthenticationConfig config = panel.fetch();
            DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
            downloader.removeAuthenticationConfigurationService(selectedConfig);
            downloader.registerAuthenticationConfigurationService(config);
            this.tblAuthenticatedServices.setModel(new AuthenticatedServicesTableModel(downloader));
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    private void doAuthenticateServiceRemove() {
        DownloaderAuthenticationConfig selectedConfig = this.getSelectedService();
        if (selectedConfig == null) {
            return;
        }
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        downloader.removeAuthenticationConfigurationService(selectedConfig);
        this.tblAuthenticatedServices.setModel(new AuthenticatedServicesTableModel(downloader));
    }

    private void doCredentialRemove() {
        DownloaderCredentials selected = this.getSelectedCredential();
        if (selected == null) {
            return;
        }
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        downloader.removeCredentials(selected);
        this.tblCredentials.setModel(new CredentialsTableModel(downloader));
    }

    public void refresh() {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        this.tblAuthenticatedServices.setModel(new AuthenticatedServicesTableModel(downloader));
        this.tblCredentials.setModel(new CredentialsTableModel(downloader));
        DefaultListModel<DownloaderAuthenticationFactory> authenticationTypesModel = new DefaultListModel<DownloaderAuthenticationFactory>();
        for (DownloaderAuthenticationFactory authType : downloader.getAuthenticationTypes()) {
            authenticationTypesModel.addElement(authType);
        }
        this.lstAuthenticationTypes.setModel(authenticationTypesModel);
    }

    private void doAuthenticationTypeSelected() {
        DownloaderAuthenticationFactory item = (DownloaderAuthenticationFactory)this.lstAuthenticationTypes.getSelectedValue();
        if (item == null) {
            this.txtAuthenticationTypesDescription.setText("");
            return;
        }
        this.txtAuthenticationTypesDescription.setText(item.getDescription());
    }

    private static class CredentialsTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Servicio", "Autenticaci\u00f3n"};
        private final Class[] columnTypes = new Class[]{String.class, String.class};
        private List<DownloaderCredentials> credentials;

        public CredentialsTableModel(DownloaderManager downloader) {
            this.credentials = downloader == null ? Collections.EMPTY_LIST : new ArrayList<DownloaderCredentials>(downloader.getCredentials());
        }

        @Override
        public int getRowCount() {
            return this.credentials.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnTypes[columnIndex];
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0 || this.credentials == null || rowIndex >= this.credentials.size()) {
                return null;
            }
            DownloaderCredentials credentials = this.credentials.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return credentials.getServiceUrl();
                }
                case 1: {
                    return credentials.getProviderName();
                }
            }
            return null;
        }

        public DownloaderCredentials getCredentials(int index) {
            return this.credentials.get(index);
        }
    }

    private static class AuthenticatedServicesTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Servicio", "Autenticaci\u00f3n"};
        private final Class[] columnTypes = new Class[]{String.class, String.class};
        private List<DownloaderAuthenticationConfig> services;

        public AuthenticatedServicesTableModel(DownloaderManager downloader) {
            this.services = downloader == null ? Collections.EMPTY_LIST : new ArrayList<DownloaderAuthenticationConfig>(downloader.getAuthenticationConfigurationServices());
        }

        @Override
        public int getRowCount() {
            return this.services.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnTypes[columnIndex];
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                if (rowIndex < 0 || this.services == null || rowIndex >= this.services.size()) {
                    return null;
                }
                DownloaderAuthenticationConfig service = this.services.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return service.getServiceUrl();
                    }
                    case 1: {
                        return service.getFactory().getProviderName();
                    }
                }
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }

        private DownloaderAuthenticationConfig getConfig(int row) {
            return this.services.get(row);
        }
    }
}

