/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.rule;

import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.topology.lib.api.ExecuteTopologyRuleActionException;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyReport;
import org.gvsig.topology.lib.api.TopologyReportLine;
import org.gvsig.topology.lib.api.TopologyRule;
import org.gvsig.topology.lib.api.TopologyRuleAction;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.gvsig.topology.lib.spi.AbstractTopologyRule;
import org.gvsig.topology.lib.spi.AbstractTopologyRuleAction;

public class PolygonContainsPointRule
extends AbstractTopologyRule {
    private String geomName;
    private Expression expression = null;
    private GeometryExpressionBuilder expressionBuilder = null;

    public PolygonContainsPointRule() {
    }

    public PolygonContainsPointRule(TopologyRuleFactory factory, double tolerance, String dataSet1, String dataSet2) {
        super(factory, tolerance, dataSet1, dataSet2);
        this.addAction((TopologyRuleAction)new CreateFetureAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check(SimpleTaskStatus taskStatus, TopologyReport report, Feature feature1) throws Exception {
        Object set = null;
        try {
            TopologyDataSet theDataSet;
            FeatureStore store2 = this.getDataSet2().getFeatureStore();
            if (this.expression == null) {
                this.expression = ExpressionUtils.createExpression();
                this.expressionBuilder = GeometryExpressionUtils.createExpressionBuilder();
                this.geomName = store2.getDefaultFeatureType().getDefaultGeometryAttributeName();
            }
            double theTolerance = this.getTolerance();
            Geometry polygon = feature1.getDefaultGeometry();
            if (theTolerance > 0.0) {
                polygon = polygon.buffer(theTolerance);
            }
            if ((theDataSet = this.getDataSet2()).getSpatialIndex() != null) {
                boolean contains = false;
                for (FeatureReference featureReference : theDataSet.query(polygon)) {
                    Feature feature2 = featureReference.getFeature();
                    Geometry otherPoint = feature2.getDefaultGeometry();
                    if (otherPoint == null || !polygon.contains(otherPoint)) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    polygon = feature1.getDefaultGeometry();
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    report.addLine((TopologyRule)this, this.getDataSet1(), this.getDataSet2(), polygon, polygon, feature1.getReference(), null, false, i18n.getTranslation("_The_polygon_does_not_contain_any_points"));
                }
            } else {
                this.expression.setPhrase(this.expressionBuilder.ifnull((ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName), (ExpressionBuilder.Value)this.expressionBuilder.constant((Object)false), (ExpressionBuilder.Value)this.expressionBuilder.ST_Contains((ExpressionBuilder.Value)this.expressionBuilder.geometry(polygon), (ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName))).toString());
                if (theDataSet.findFirst(this.expression) == null) {
                    polygon = feature1.getDefaultGeometry();
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    report.addLine((TopologyRule)this, this.getDataSet1(), this.getDataSet2(), polygon, polygon, feature1.getReference(), null, false, i18n.getTranslation("_The_polygon_does_not_contain_any_points"));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't check feature.", (Throwable)ex);
            this.addCodeException(report, feature1, ex);
        }
        finally {
            if (set != null) {
                set.dispose();
            }
        }
    }

    private class CreateFetureAction
    extends AbstractTopologyRuleAction {
        public CreateFetureAction() {
            super("PolygonContainsPoint", "CreateFeature", "Create Feature", "The Create Feature fix creates a new point feature at the centroid of the polygon feature that is causing the error. The point feature that is created is guaranteed to be within the polygon feature.");
        }

        public int execute(TopologyRule rule, TopologyReportLine line, DynObject parameters) {
            try {
                Geometry polygon = line.getGeometry();
                Point point = polygon.centroid();
                if (!polygon.contains((Geometry)point)) {
                    point = polygon.getInteriorPoint();
                }
                TopologyDataSet dataSet = rule.getDataSet2();
                EditableFeature feature = dataSet.createNewFeature();
                feature.setDefaultGeometry((Geometry)point);
                dataSet.insert(feature);
                return 0;
            }
            catch (Exception ex) {
                throw new ExecuteTopologyRuleActionException(ex);
            }
        }
    }
}

