/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.raster.swing.impl.operations;

import java.util.List;
import java.util.Locale;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.fmap.mapcontext.raster.swing.impl.operations.OperationFactoryCellRenderer;
import org.gvsig.fmap.mapcontext.raster.swing.impl.operations.OperationSelectorPanelView;
import org.gvsig.fmap.mapcontext.raster.swing.operations.OperationSelectorPanel;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSelectorPanelController
extends OperationSelectorPanelView
implements OperationSelectorPanel,
ListSelectionListener {
    private static final long serialVersionUID = -419078249858416625L;
    private static final Logger LOG = LoggerFactory.getLogger(OperationSelectorPanelController.class);

    public OperationSelectorPanelController() {
        this.translate();
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.lstOperations.setSelectionMode(0);
        this.lstOperations.getSelectionModel().addListSelectionListener(this);
        DefaultListModel<OperationFactory> model = new DefaultListModel<OperationFactory>();
        List factories = BufferLocator.getOperationManager().getOperationFactories();
        for (OperationFactory operationFactory : factories) {
            model.addElement(operationFactory);
        }
        this.lstOperations.setModel(model);
        this.lstOperations.setCellRenderer(new OperationFactoryCellRenderer());
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lstOperations.setToolTipText(i18nManager.getTranslation(this.lstOperations.getToolTipText()));
    }

    public void setLocate(Locale locale) {
        Locale l = super.getLocale();
        if (!l.equals(locale)) {
            this.translate();
        }
        super.setLocale(locale);
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    public OperationFactory getSelected() {
        return (OperationFactory)this.lstOperations.getSelectedValue();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.lstOperations.getSelectionModel().addListSelectionListener(listener);
    }

    public void clearSelection() {
        this.lstOperations.clearSelection();
    }
}

