/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;
import org.gvsig.remoteclient.ILayer;
import org.gvsig.remoteclient.utils.BoundaryBox;
import org.gvsig.remoteclient.wms.WMSDimension;
import org.gvsig.remoteclient.wms.WMSStyle;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class WMSLayer
implements ILayer {
    protected ArrayList children;
    protected WMSLayer parent;
    private String layerAbstract;
    public ArrayList styles = new ArrayList();
    private String name;
    private String title;
    private ArrayList keywordList = new ArrayList();
    protected Vector srs = new Vector();
    private Hashtable bBoxes = new Hashtable();
    private BoundaryBox latLonBbox;
    private double scaleMin;
    private double scaleMax;
    protected ArrayList dimensions = new ArrayList();
    private boolean queryable = false;
    private boolean opaque = false;
    private boolean m_noSubSets = false;
    private int fixedWidth = 0;
    private int fixedHeight = 0;
    private boolean transparency;

    public abstract void parse(KXmlParser var1, TreeMap var2) throws IOException, XmlPullParserException;

    protected void addkeyword(String key) {
        this.keywordList.add(key);
    }

    public ArrayList getKeywords() {
        return this.keywordList;
    }

    public void addStyle(WMSStyle _style) {
        this.styles.add(_style);
    }

    public ArrayList getStyles() {
        ArrayList list = new ArrayList();
        if (this.styles != null) {
            list.addAll(this.styles);
        }
        if (this.getParent() != null && this.getParent().getStyles() != null) {
            list.addAll(this.getParent().getStyles());
        }
        return list;
    }

    public ArrayList getAllStyles(WMSLayer layer) {
        if (layer.getParent() != null) {
            ArrayList list = this.getAllStyles(layer.getParent());
            for (int i = 0; i < this.styles.size(); ++i) {
                list.add(this.styles.get(i));
            }
            return list;
        }
        return this.styles;
    }

    public void addBBox(BoundaryBox bbox) {
        this.bBoxes.put(bbox.getSrs(), bbox);
    }

    public BoundaryBox getBbox(String id) {
        BoundaryBox b = (BoundaryBox)this.bBoxes.get(id);
        if (b != null) {
            return b;
        }
        if ((id.compareToIgnoreCase("EPSG:4326") == 0 || id.compareToIgnoreCase("CRS:84") == 0) && this.latLonBbox != null) {
            return this.latLonBbox;
        }
        if (this.parent != null) {
            return this.parent.getBbox(id);
        }
        return null;
    }

    public Hashtable getBboxes() {
        return this.bBoxes;
    }

    public BoundaryBox getLatLonBox() {
        return this.latLonBbox;
    }

    public void setLatLonBox(BoundaryBox box) {
        this.latLonBbox = box;
    }

    public void addSrs(String srs) {
        if (!this.srs.contains(srs)) {
            this.srs.add(srs);
        }
    }

    public void removeSrs(String srs) {
        this.srs.remove(srs);
    }

    public Vector getAllSrs() {
        Vector mySRSs = (Vector)this.srs.clone();
        if (this.parent != null) {
            mySRSs.addAll(this.parent.getAllSrs());
        }
        return mySRSs;
    }

    public double getScaleMax() {
        return this.scaleMax;
    }

    public double getScaleMin() {
        return this.scaleMin;
    }

    public void setScaleMin(double scale) {
        this.scaleMin = scale;
    }

    public void setScaleMax(double scale) {
        this.scaleMax = scale;
    }

    public abstract ArrayList getDimensions();

    public WMSDimension getDimension(String name) {
        for (int i = 0; i < this.dimensions.size(); ++i) {
            if (((WMSDimension)this.dimensions.get(i)).getName().compareTo(name) != 0) continue;
            return (WMSDimension)this.dimensions.get(i);
        }
        return null;
    }

    public void addDimension(WMSDimension dimension) {
        this.dimensions.add(dimension);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAbstract() {
        return this.layerAbstract;
    }

    public void setAbstract(String _abstract) {
        this.layerAbstract = _abstract;
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList children) {
        this.children = children;
    }

    public WMSLayer getParent() {
        return this.parent;
    }

    public void setParent(WMSLayer parent) {
        this.parent = parent;
    }

    public String toString() {
        return this.getTitle();
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public void setQueryable(boolean queryable) {
        this.queryable = queryable;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    public boolean noSubSets() {
        return this.m_noSubSets;
    }

    public void setNoSubSets(boolean _noSubSets) {
        this.m_noSubSets = _noSubSets;
    }

    public void setfixedWidth(int w) {
        this.fixedWidth = w;
    }

    public int getfixedWidth() {
        return this.fixedWidth;
    }

    public void setfixedHeight(int h) {
        this.fixedHeight = h;
    }

    public int getfixedHeight() {
        return this.fixedHeight;
    }

    public boolean hasTransparency() {
        return this.transparency;
    }

    protected void parseKeywordList(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "KeywordList");
        int currentTag = parser.nextTag();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    String value;
                    if (parser.getName().compareTo("Keyword") != 0 || (value = parser.nextText()) == null || value.length() <= 0) break;
                    this.addkeyword(value);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("KeywordList") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
        parser.require(3, null, "KeywordList");
    }

    protected void readLayerAttributes(KXmlParser parser) {
        String value = new String();
        value = parser.getAttributeValue("", "queryable");
        if (value != null) {
            if (value.compareTo("0") == 0) {
                this.setQueryable(false);
            } else {
                this.setQueryable(true);
            }
        }
        if ((value = parser.getAttributeValue("", "opaque")) != null) {
            if (value.compareTo("0") == 0) {
                this.setOpaque(false);
            } else {
                this.setOpaque(true);
            }
        }
        if ((value = parser.getAttributeValue("", "noSubsets")) != null) {
            if (value.compareTo("0") == 0) {
                this.setNoSubSets(false);
            } else {
                this.setNoSubSets(true);
            }
        }
        if ((value = parser.getAttributeValue("", "fixedWidth")) != null) {
            this.setfixedWidth(Integer.parseInt(value));
        }
        if ((value = parser.getAttributeValue("", "fixedHeight")) != null) {
            this.setfixedHeight(Integer.parseInt(value));
        }
    }

    protected class DataURL {
        public String type = new String();
        public String format = new String();
        public String onlineResource_xlink = new String();
        public String onlineResource_type = new String();
        public String onlineResource_href = new String();
    }

    protected class MetadataURL {
        public String type = new String();
        public String format = new String();
        public String onlineResource_xlink = new String();
        public String onlineResource_type = new String();
        public String onlineResource_href = new String();
    }
}

