/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wms.wms_1_3_0.request;

import java.util.Vector;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.lang.StringUtils;
import org.gvsig.remoteclient.epsg.CrsAxisOrder;
import org.gvsig.remoteclient.utils.Utilities;
import org.gvsig.remoteclient.wms.WMSProtocolHandler;
import org.gvsig.remoteclient.wms.WMSStatus;
import org.gvsig.remoteclient.wms.request.WMSGetFeatureInfoRequest;

public class WMSGetFeatureInfoRequest1_1_3
extends WMSGetFeatureInfoRequest {
    private static final StringUtils stringUtils = CompatLocator.getStringUtils();

    public WMSGetFeatureInfoRequest1_1_3(WMSStatus status, WMSProtocolHandler protocolHandler, int x, int y) {
        super(status, protocolHandler, x, y);
    }

    protected String getHttpGetRequest(String onlineResource) {
        StringBuffer req = new StringBuffer();
        req.append(onlineResource);
        req.append("REQUEST=GetFeatureInfo&SERVICE=WMS&");
        req.append("QUERY_LAYERS=").append(Utilities.Vector2CS((Vector)this.status.getLayerNames()));
        req.append("&VERSION=").append(this.protocolHandler.getVersion()).append("&INFO_FORMAT=" + this.status.getInfoFormat() + "&");
        req.append(this.getPartialQuery(this.status)).append("&I=" + this.x + "&J=" + this.y);
        req.append("&FEATURE_COUNT=10000");
        req.append("&EXCEPTIONS=" + this.getExceptionsFormat());
        return req.toString();
    }

    @Override
    protected String getPartialQuery(WMSStatus status) {
        double coord4;
        double coord3;
        double coord2;
        double coord1;
        StringBuffer req = new StringBuffer();
        String epsgCode = status.getSrs();
        if (status.isXyAxisOrder() || CrsAxisOrder.isXyAxisOrder(epsgCode)) {
            coord1 = status.getExtent().getMinX();
            coord2 = status.getExtent().getMinY();
            coord3 = status.getExtent().getMaxX();
            coord4 = status.getExtent().getMaxY();
        } else {
            coord1 = status.getExtent().getMinY();
            coord2 = status.getExtent().getMinX();
            coord3 = status.getExtent().getMaxY();
            coord4 = status.getExtent().getMaxX();
        }
        req.append("LAYERS=" + Utilities.Vector2CS((Vector)status.getLayerNames())).append("&CRS=" + status.getSrs()).append("&BBOX=" + coord1 + ",").append(coord2 + ",").append(coord3 + ",").append(coord4).append("&WIDTH=" + status.getWidth()).append("&HEIGHT=" + status.getHeight()).append("&FORMAT=" + status.getFormat()).append("&STYLES=");
        Vector v = status.getStyles();
        if (v != null && v.size() > 0) {
            req.append(Utilities.Vector2CS((Vector)v));
        }
        if ((v = status.getDimensions()) != null && v.size() > 0) {
            req.append("&" + Utilities.Vector2URLParamString((Vector)v));
        }
        if (status.getTransparency()) {
            req.append("&TRANSPARENT=TRUE");
        }
        return req.toString();
    }

    protected String getExceptionsFormat() {
        return "XML";
    }
}

