/*
 * Decompiled with CFR 0.152.
 */
package com.github.tbekolay.jnumeric;

import com.github.tbekolay.jnumeric.FFT;
import com.github.tbekolay.jnumeric.PyMultiarrayPrinter;
import com.github.tbekolay.jnumeric.Umath;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyComplex;
import org.python.core.PyEllipsis;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PySlice;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.__builtin__;

public class PyMultiarray
extends PySequence {
    private static final long serialVersionUID = 4524353697384690762L;
    public static int maxLineWidth = 77;
    public static int precision = 8;
    public static boolean suppressSmall = false;
    public static final PyType ATYPE = PyType.fromClass(PyMultiarray.class);
    String docString = "PyMultiarray methods:\n\tastype(typecode)]\n\titemsize()\n\tbyteswapped()\n\tcopy()\n\ttypecode()\n\tiscontiguous()\n\ttostring()\n\ttolist()\n";
    Object data;
    char _typecode;
    int start;
    int[] dimensions;
    int[] strides;
    boolean isContiguous;
    private static final short INTEGER = 1;
    private static final short FLOATINGPOINT = 2;
    private static final short COMPLEX = 3;
    private static final short PYOBJECT = 4;

    public PyMultiarray(Object data, char _typecode, int start, int[] dimensions, int[] strides) {
        super(ATYPE);
        this.javaProxy = this;
        this.data = data;
        this._typecode = _typecode;
        this.start = start;
        this.dimensions = dimensions;
        this.strides = strides;
        this.isContiguous = true;
        this.setIsContiguous();
    }

    public PyMultiarray(PyObject seq, char typecode) {
        super(ATYPE);
        this.javaProxy = this;
        PyMultiarray a = PyMultiarray.array(seq, typecode);
        this.data = a.data;
        this._typecode = a._typecode;
        this.start = a.start;
        this.dimensions = a.dimensions;
        this.strides = a.strides;
        this.isContiguous = a.isContiguous;
    }

    public PyMultiarray(PyObject seq) {
        super(ATYPE);
        this.javaProxy = this;
        PyMultiarray a = PyMultiarray.array(seq, '\u0000');
        this.data = a.data;
        this._typecode = a._typecode;
        this.start = a.start;
        this.dimensions = a.dimensions;
        this.strides = a.strides;
        this.isContiguous = a.isContiguous;
    }

    private static PyMultiarray seqToMultiarray(PyObject seq, char typecode) {
        int i;
        int[] newShape = PyMultiarray.shapeOf(seq);
        PyObject[] flatData = PyMultiarray.seqToObjects(seq, PyMultiarray.shapeToNItems(newShape));
        typecode = typecode == '\u0000' ? PyMultiarray.objectsToType(flatData) : typecode;
        PyMultiarray newArray = PyMultiarray.zeros(PyMultiarray.shapeOf(seq), typecode);
        int size = PyMultiarray.typeToNElements(typecode);
        for (i = 0; i < flatData.length; ++i) {
            Array.set(newArray.data, size * i, PyMultiarray.objectToJava(flatData[i], typecode, true));
        }
        if (size == 2) {
            for (i = 0; i < flatData.length; ++i) {
                Array.set(newArray.data, size * i + 1, PyMultiarray.objectToJava(flatData[i], typecode, false));
            }
        }
        return newArray;
    }

    private static char arrayClassToType(Class<?> klass) {
        if (klass.isArray()) {
            return PyMultiarray.arrayClassToType(klass.getComponentType());
        }
        return PyMultiarray.classToType(klass);
    }

    private static int[] arrayDataToShape(Object data, int depth) {
        int length = Array.getLength(data);
        Class<?> klass = data.getClass().getComponentType();
        if (length != 0 && klass.isArray()) {
            int[] shape = PyMultiarray.arrayDataToShape(Array.get(data, 0), depth + 1);
            shape[depth] = length;
            for (int i = 0; i < length; ++i) {
                int[] shape2 = PyMultiarray.arrayDataToShape(Array.get(data, i), depth + 1);
                if (shape.length != shape2.length) {
                    throw Py.ValueError((String)"malformed array");
                }
                for (int j = depth + 1; j < shape.length; ++j) {
                    if (shape[j] == shape2[j]) continue;
                    throw Py.ValueError((String)"malformed array");
                }
            }
            return shape;
        }
        int[] shape = new int[depth + 1];
        shape[depth] = length;
        return shape;
    }

    private static int arrayDataToFlat(Object data, Object flat, int offset) {
        Class<?> klass = data.getClass().getComponentType();
        int length = Array.getLength(data);
        if (klass.isArray()) {
            for (int i = 0; i < length; ++i) {
                offset = PyMultiarray.arrayDataToFlat(Array.get(data, i), flat, offset);
            }
            return offset;
        }
        System.arraycopy(data, 0, flat, offset, length);
        return offset + length;
    }

    private static PyMultiarray arrayToMultiarray(PyArray seq, char typecode) {
        Object data = seq.__tojava__(Object.class);
        char type = PyMultiarray.arrayClassToType(data.getClass());
        int[] shape = PyMultiarray.arrayDataToShape(data, 0);
        int[] strides = PyMultiarray.shapeToStrides(shape, PyMultiarray.typeToNElements(type));
        if (shape.length > 1) {
            Object flat = Array.newInstance(PyMultiarray.typeToClass(type), PyMultiarray.shapeToNItems(shape));
            PyMultiarray.arrayDataToFlat(data, flat, 0);
            data = flat;
        }
        PyMultiarray ma = new PyMultiarray(data, type, 0, shape, strides);
        return typecode == '\u0000' || typecode == type ? ma : PyMultiarray.array((PyObject)ma, typecode);
    }

    public static PyMultiarray array(PyObject seq, char typecode) {
        if (seq instanceof PyMultiarray) {
            PyMultiarray a = (PyMultiarray)seq;
            PyMultiarray b = PyMultiarray.zeros(a.dimensions, typecode == '\u0000' ? a._typecode : typecode);
            PyMultiarray.copyAToB(a, b);
            return b;
        }
        if (seq instanceof PyArray) {
            PyArray copyOfSeq = (PyArray)seq.__getslice__(Py.None, Py.None, Py.None);
            return PyMultiarray.arrayToMultiarray(copyOfSeq, typecode);
        }
        return PyMultiarray.seqToMultiarray(seq, typecode);
    }

    public static PyMultiarray array(PyObject seq) {
        return PyMultiarray.array(seq, '\u0000');
    }

    public static PyMultiarray zeros(int[] shape, char typecode) {
        int length = PyMultiarray.typeToNElements(typecode) * PyMultiarray.shapeToNItems(shape);
        Object data = Array.newInstance(PyMultiarray.typeToClass(typecode), length);
        if (typecode == 'O') {
            for (int i = 0; i < Array.getLength(data); ++i) {
                Array.set(data, i, Py.Zero);
            }
        }
        int[] strides = PyMultiarray.shapeToStrides(shape, PyMultiarray.typeToNElements(typecode));
        return new PyMultiarray(data, typecode, 0, shape, strides);
    }

    public static PyMultiarray zeros(Object shape, char typecode) {
        return PyMultiarray.zeros(PyMultiarray.objectToInts(shape, true), typecode);
    }

    public static PyMultiarray zeros(PyObject shape) {
        return PyMultiarray.zeros(PyMultiarray.objectToInts(shape, true), PyMultiarray.asarray(shape).typecode());
    }

    static PyMultiarray arrayRange(double start, double stop, double step, char typecode) {
        int length = Math.max(0, (int)Math.ceil((stop - start) / step));
        PyMultiarray a = PyMultiarray.zeros(new int[]{length}, 'd');
        for (int i = 0; i < length; ++i) {
            Array.setDouble(a.data, i, (double)i * step + start);
        }
        return a.astype(typecode);
    }

    public static PyMultiarray arrayRange(PyObject start, PyObject stop, PyObject step, char typecode) {
        if (stop instanceof PyNone) {
            stop = start;
            start = Py.Zero;
        }
        if (typecode == '\u0000') {
            typecode = PyMultiarray.objectsToType(new PyObject[]{start, stop, step});
        }
        if (typecode != 'O') {
            return PyMultiarray.arrayRange(start.__float__().getValue(), stop.__float__().getValue(), step.__float__().getValue(), typecode);
        }
        PyObject lengthObject = stop._sub(start)._div(step);
        int length = Math.max(0, (int)Math.ceil(lengthObject.__float__().getValue()));
        start = __builtin__.coerce((PyObject)start, (PyObject)lengthObject).__getitem__(0);
        PyMultiarray a = PyMultiarray.zeros(new int[]{length}, 'O');
        for (int i = 0; i < length; ++i) {
            a.set(i, start);
            start = start._add(step);
        }
        return a;
    }

    public static PyMultiarray indices(PyObject o, char typecode) {
        int[] baseShape = PyMultiarray.objectToInts(o, true);
        int[] shape = new int[baseShape.length + 1];
        for (int i = 0; i < baseShape.length; ++i) {
            shape[i + 1] = baseShape[i];
        }
        shape[0] = baseShape.length;
        if (typecode == '\u0000') {
            typecode = PyMultiarray.asarray((PyObject)o)._typecode;
        }
        PyMultiarray result = PyMultiarray.zeros(shape, typecode);
        for (int i = 0; i < baseShape.length; ++i) {
            PyMultiarray subArray = PyMultiarray.swapAxes(PyMultiarray.asarray(result.get(i)), 0, i);
            subArray.__add__((PyObject)PyMultiarray.arrayRange(0.0, baseShape[i], 1.0, typecode), subArray);
        }
        return result;
    }

    public static PyMultiarray fromFunction(PyObject function, PyObject shape) {
        PyMultiarray index = PyMultiarray.indices(shape, '\u0000');
        PyMultiarray result = PyMultiarray.zeros(shape);
        PyMultiarray flatIndex = PyMultiarray.swapAxes(PyMultiarray.reshape((PyObject)index, new int[]{result.dimensions.length, -1}), 0, 1);
        PyMultiarray flatResult = PyMultiarray.reshape((PyObject)result, new int[]{-1});
        PyObject[] args = new PyObject[]{};
        String[] keywords = new String[]{};
        Class<?> objectArray = args.getClass();
        for (int i = 0; i < flatResult.dimensions[0]; ++i) {
            args = (PyObject[])((PyMultiarray)flatIndex.get(i)).tolist().__tojava__(objectArray);
            flatResult.set(i, function.__call__(args, keywords));
        }
        return result;
    }

    public static PyMultiarray fromString(String s, char type) {
        Object data;
        int itemsize = PyMultiarray.typeToNBytes(type) * PyMultiarray.typeToNElements(type);
        if (s.length() % itemsize != 0) {
            throw Py.ValueError((String)"string size must be a multiple of element size");
        }
        try {
            data = PyMultiarray.fromByteArray(s.getBytes("ISO-8859-1"), type);
        }
        catch (UnsupportedEncodingException e) {
            throw Py.RuntimeError((String)"ISO-LATIN-1 encoding unavailable, can't convert from string.");
        }
        return new PyMultiarray(data, type, 0, new int[]{Array.getLength(data) / PyMultiarray.typeToNElements(type)}, new int[]{PyMultiarray.typeToNElements(type)});
    }

    public static PyMultiarray asarray(PyObject seq, char typecode) {
        if (seq instanceof PyMultiarray && (typecode == '\u0000' || ((PyMultiarray)seq)._typecode == typecode)) {
            return (PyMultiarray)seq;
        }
        if (seq instanceof PyArray) {
            return PyMultiarray.arrayToMultiarray((PyArray)seq, typecode);
        }
        return PyMultiarray.array(seq, typecode);
    }

    public static PyMultiarray asarray(PyObject seq) {
        if (seq instanceof PyMultiarray) {
            return (PyMultiarray)seq;
        }
        return PyMultiarray.array(seq);
    }

    public static PyMultiarray ascontiguous(PyObject seq, char _typecode) {
        if (seq instanceof PyMultiarray && ((PyMultiarray)seq).isContiguous && ((PyMultiarray)seq)._typecode == _typecode) {
            return (PyMultiarray)seq;
        }
        return PyMultiarray.array(seq, _typecode);
    }

    public static PyMultiarray ascontiguous(PyObject seq) {
        if (seq instanceof PyMultiarray && ((PyMultiarray)seq).isContiguous) {
            return (PyMultiarray)seq;
        }
        return PyMultiarray.array(seq);
    }

    public char typecode() {
        return this._typecode;
    }

    public int itemsize() {
        return PyMultiarray.typeToNElements(this._typecode) * PyMultiarray.typeToNBytes(this._typecode);
    }

    public int iscontiguous() {
        return this.isContiguous ? 1 : 0;
    }

    public PyMultiarray astype(char type) {
        return PyMultiarray.asarray((PyObject)this, type);
    }

    public String tostring() {
        try {
            return new String(PyMultiarray.toByteArray(PyMultiarray.array((PyObject)this).data, this._typecode), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw Py.RuntimeError((String)"ISO-LATIN-1 encoding unavailable, can't convert to string.");
        }
    }

    public final PyMultiarray byteswapped() {
        PyMultiarray result = PyMultiarray.array((PyObject)this);
        byte[] bytes = PyMultiarray.toByteArray(result.data, this._typecode);
        short typesize = PyMultiarray.typeToNBytes(this._typecode);
        int swaps = typesize / 2;
        for (int i = 0; i < Array.getLength(result.data); ++i) {
            for (int j = 0; j < swaps; ++j) {
                byte temp = bytes[i * typesize + j];
                bytes[i * typesize + j] = bytes[i * typesize + (typesize - 1 - j)];
                bytes[i * typesize + (typesize - 1 - j)] = temp;
            }
        }
        result.data = PyMultiarray.fromByteArray(bytes, this._typecode);
        return result;
    }

    public final PyMultiarray copy() {
        return PyMultiarray.array((PyObject)this);
    }

    public final PyList tolist() {
        if (this.dimensions.length == 0) {
            throw Py.ValueError((String)"Can't convert a 0d array to a list");
        }
        PyObject[] items = new PyObject[this.dimensions[0]];
        if (this.dimensions.length == 1) {
            for (int i = 0; i < this.dimensions[0]; ++i) {
                items[i] = this.get(i);
            }
        } else {
            for (int i = 0; i < this.dimensions[0]; ++i) {
                items[i] = ((PyMultiarray)this.get(i)).tolist();
            }
        }
        return new PyList(items);
    }

    public static PyMultiarray reshape(PyObject o, int[] shape) {
        PyMultiarray a = PyMultiarray.ascontiguous(o);
        shape = PyMultiarray.fixedShape(shape, PyMultiarray.shapeToNItems(a.dimensions));
        int[] strides = PyMultiarray.shapeToStrides(shape, PyMultiarray.typeToNElements(a._typecode));
        return new PyMultiarray(a.data, a._typecode, a.start, shape, strides);
    }

    public static PyMultiarray resize(PyObject o, int[] shape) {
        PyMultiarray a = PyMultiarray.ascontiguous((PyObject)PyMultiarray.reshape((PyObject)PyMultiarray.asarray(o), new int[]{-1}));
        int nItems = PyMultiarray.shapeToNItems(shape);
        int nCopies = nItems / a.dimensions[0];
        int extra = nItems % a.dimensions[0];
        int nElements = PyMultiarray.typeToNElements(a._typecode);
        PyMultiarray result = PyMultiarray.zeros(shape, a._typecode);
        for (int i = 0; i < nCopies; ++i) {
            System.arraycopy(a.data, a.start, result.data, i * a.dimensions[0] * nElements, a.dimensions[0] * nElements);
        }
        System.arraycopy(a.data, a.start, result.data, nCopies * a.dimensions[0] * nElements, extra * nElements);
        return result;
    }

    public static PyMultiarray sort(PyObject o, int axis) {
        PyMultiarray a = PyMultiarray.array((PyObject)PyMultiarray.swapAxes(PyMultiarray.asarray(o), axis, -1));
        int stride = a.dimensions[a.dimensions.length - 1];
        block8: for (int i = 0; i < Array.getLength(a.data); i += stride) {
            switch (a._typecode) {
                case '1': {
                    Arrays.sort((byte[])a.data, i, i + stride);
                    continue block8;
                }
                case 's': {
                    Arrays.sort((short[])a.data, i, i + stride);
                    continue block8;
                }
                case 'i': {
                    Arrays.sort((int[])a.data, i, i + stride);
                    continue block8;
                }
                case 'l': {
                    Arrays.sort((long[])a.data, i, i + stride);
                    continue block8;
                }
                case 'f': {
                    Arrays.sort((float[])a.data, i, i + stride);
                    continue block8;
                }
                case 'd': {
                    Arrays.sort((double[])a.data, i, i + stride);
                    continue block8;
                }
                default: {
                    throw Py.ValueError((String)"unsortable array type");
                }
            }
        }
        return PyMultiarray.swapAxes(a, axis, -1);
    }

    public static PyMultiarray argSort(PyObject o, int axis) {
        PyMultiarray a = PyMultiarray.array((PyObject)PyMultiarray.swapAxes(PyMultiarray.asarray(o), axis, -1));
        if (a._typecode == 'F' || a._typecode == 'D' || a._typecode == 'O') {
            throw Py.ValueError((String)"unsortable array type");
        }
        int stride = a.dimensions[a.dimensions.length - 1];
        int size = Array.getLength(a.data);
        int[] data = new int[size];
        class IndexedArray {
            Number item;
            int index;

            IndexedArray() {
            }
        }
        IndexedArray[] ia = new IndexedArray[stride];
        for (int j = 0; j < stride; ++j) {
            ia[j] = new IndexedArray();
        }
        Comparator<IndexedArray> comp = new Comparator<IndexedArray>(){

            @Override
            public int compare(IndexedArray o1, IndexedArray o2) {
                double d2;
                if (o1.item.equals(o2.item)) {
                    return 0;
                }
                double d1 = o1.item.doubleValue();
                if (d1 > (d2 = o2.item.doubleValue())) {
                    return 1;
                }
                return -1;
            }
        };
        for (int i = 0; i < size; i += stride) {
            int j;
            for (j = 0; j < stride; ++j) {
                ia[j].item = (Number)Array.get(a.data, i + j);
                ia[j].index = j;
            }
            Arrays.sort(ia, comp);
            for (j = 0; j < stride; ++j) {
                data[i + j] = ia[j].index;
            }
        }
        a._typecode = (char)105;
        a.data = data;
        return PyMultiarray.swapAxes(a, axis, -1);
    }

    public static PyMultiarray transpose(PyObject o, int[] perms) {
        PyMultiarray a = PyMultiarray.asarray(o);
        boolean[] used = new boolean[perms.length];
        for (int i = 0; i < perms.length; ++i) {
            int axis = perms[i];
            int n = axis = axis < 0 ? a.dimensions.length + axis : axis;
            if (axis < 0 || axis >= a.dimensions.length || used[axis]) {
                throw Py.ValueError((String)"illegal permutation");
            }
            perms[i] = axis;
            used[axis] = true;
        }
        PyMultiarray ans = new PyMultiarray(a.data, a._typecode, a.start, (int[])a.dimensions.clone(), (int[])a.strides.clone());
        for (int i = 0; i < perms.length; ++i) {
            ans.dimensions[i] = a.dimensions[perms[i]];
            ans.strides[i] = a.strides[perms[i]];
        }
        ans.setIsContiguous();
        return ans;
    }

    public static PyMultiarray repeat(PyObject oA, PyObject oRepeats, int axis) {
        PyMultiarray a = PyMultiarray.asarray(oA);
        PyMultiarray repeats = PyMultiarray.asarray(oRepeats);
        if (axis < 0) {
            axis += a.dimensions.length;
        }
        if (axis < 0 || axis >= a.dimensions.length) {
            throw Py.ValueError((String)"illegal axis");
        }
        a = PyMultiarray.swapAxes(a, 0, axis);
        repeats = PyMultiarray.array((PyObject)repeats, 'i');
        if (repeats.dimensions.length != 1) {
            throw Py.ValueError((String)"wrong number of dimensions");
        }
        int[] dimensions = (int[])a.dimensions.clone();
        dimensions[0] = 0;
        for (int i = 0; i < repeats.dimensions[0]; ++i) {
            dimensions[0] = dimensions[0] + Array.getInt(repeats.data, i);
        }
        PyMultiarray result = PyMultiarray.zeros(dimensions, a._typecode);
        int location = 0;
        for (int i = 0; i < repeats.dimensions[0]; ++i) {
            PyObject chunk = a.get(i);
            for (int j = 0; j < Array.getInt(repeats.data, i); ++j) {
                result.set(location++, chunk);
            }
        }
        return PyMultiarray.swapAxes(result, 0, axis);
    }

    public static PyMultiarray take(PyObject oA, PyObject oIndices, int axis) {
        PyMultiarray a = PyMultiarray.asarray(oA);
        PyMultiarray indices = PyMultiarray.asarray(oIndices);
        if (axis < 0) {
            axis += a.dimensions.length;
        }
        if (axis < 0 || axis >= a.dimensions.length) {
            throw Py.ValueError((String)"illegal axis");
        }
        a = PyMultiarray.ascontiguous((PyObject)PyMultiarray.rotateAxes(a, -axis));
        indices = PyMultiarray.array((PyObject)indices, 'i');
        if (indices.dimensions.length != 1) {
            throw Py.ValueError((String)"wrong number of dimensions");
        }
        int[] dimensions = (int[])a.dimensions.clone();
        dimensions[0] = indices.dimensions[0];
        PyMultiarray result = PyMultiarray.zeros(dimensions, a._typecode);
        int stride = result.strides[0];
        int start = a.start;
        for (int i = 0; i < indices.dimensions[0]; ++i) {
            int item = Array.getInt(indices.data, i);
            for (int j = 0; j < stride; ++j) {
                Array.set(result.data, i * stride + j, Array.get(a.data, start + item * stride + j));
            }
        }
        return PyMultiarray.rotateAxes(result, axis);
    }

    public static PyMultiarray choose(PyObject oA, PyObject b) {
        PyMultiarray a = PyMultiarray.array(oA);
        boolean debug_this = false;
        int n = b.__len__();
        PyMultiarray[] bs = new PyMultiarray[n];
        for (int i = 0; i < n; ++i) {
            bs[i] = PyMultiarray.ascontiguous(b.__getitem__(i));
        }
        char type = n > 0 ? (char)bs[0]._typecode : (char)'i';
        for (int i = 1; i < n; ++i) {
            type = PyMultiarray.commonType(type, bs[i]._typecode);
        }
        a = PyMultiarray.ascontiguous((PyObject)a, 'i');
        int[] sizes = new int[n];
        for (int i = 0; i < n; ++i) {
            if (a.dimensions.length < bs[i].dimensions.length) {
                throw Py.ValueError((String)("choice array has too many dimensions: " + bs[i].dimensions.length + " > " + a.dimensions.length));
            }
            for (int j = 0; j < bs[i].dimensions.length; ++j) {
                if (a.dimensions[j + a.dimensions.length - bs[i].dimensions.length] == bs[i].dimensions[j]) continue;
                throw Py.ValueError((String)"array dimensions must agree.");
            }
            bs[i] = PyMultiarray.array((PyObject)bs[i], type);
            sizes[i] = Array.getLength(bs[i].data);
        }
        PyMultiarray result = PyMultiarray.zeros(a.dimensions, type);
        PyMultiarray flat = PyMultiarray.reshape((PyObject)result, new int[]{-1});
        for (int i = 0; i < Array.getLength(flat.data); ++i) {
            int index = Array.getInt(a.data, i);
            if (index < 0 || index >= n) {
                throw Py.ValueError((String)"invalid entry in choice array");
            }
            Array.set(flat.data, i, Array.get(bs[index].data, i % sizes[index]));
        }
        return result;
    }

    public static PyMultiarray concatenate(PyObject po, int axis) {
        if (po.__len__() == 0) {
            return PyMultiarray.zeros(new int[0], 'i');
        }
        PyMultiarray proto = PyMultiarray.asarray(po.__getitem__(0));
        if (axis < 0) {
            axis += proto.dimensions.length;
        }
        if (axis < 0 || axis >= proto.dimensions.length) {
            throw Py.ValueError((String)"illegal axis");
        }
        PyMultiarray[] as = new PyMultiarray[po.__len__()];
        as[0] = proto = PyMultiarray.rotateAxes(proto, -axis);
        char type = proto.typecode();
        int[] dimensions = (int[])proto.dimensions.clone();
        for (int i = 1; i < as.length; ++i) {
            as[i] = PyMultiarray.rotateAxes(PyMultiarray.asarray(po.__getitem__(i)), -axis);
            type = PyMultiarray.commonType(type, as[i]._typecode);
            if (as[i].dimensions.length != proto.dimensions.length) {
                throw Py.ValueError((String)"mismatched array dimensions");
            }
            for (int j = 1; j < proto.dimensions.length; ++j) {
                if (as[i].dimensions[j] == proto.dimensions[j]) continue;
                throw Py.ValueError((String)"mismatched array dimensions");
            }
            dimensions[0] = dimensions[0] + as[i].dimensions[0];
        }
        PyMultiarray result = PyMultiarray.zeros(dimensions, type);
        int start = 0;
        for (PyMultiarray element : as) {
            int end = start + element.dimensions[0];
            result.setslice(start, end, 1, (PyObject)element);
            start = end;
        }
        return PyMultiarray.rotateAxes(result, axis);
    }

    public static PyMultiarray diagonal(PyObject o, int offset, int axis) {
        boolean debug_this = false;
        PyMultiarray a = PyMultiarray.rotateAxes(PyMultiarray.asarray(o), -2 - axis);
        int lastDimension = a.dimensions[a.dimensions.length - 1];
        int[] shape = new int[a.dimensions.length - 1];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = a.dimensions[i];
        }
        int n = shape.length - 1;
        shape[n] = shape[n] * lastDimension;
        int oldAshape = a.dimensions[a.dimensions.length - 1];
        a = PyMultiarray.reshape((PyObject)a, shape);
        int shapeLastDim = shape[shape.length - 1] / lastDimension;
        int oldShape = shape[shape.length - 1];
        if (offset > 0 && offset > lastDimension - shapeLastDim) {
            int n2 = shape.length - 1;
            shape[n2] = shape[n2] - (offset - (lastDimension - shapeLastDim)) * lastDimension;
        }
        if (offset < 0) {
            offset = -lastDimension * offset;
        }
        a = PyMultiarray.take((PyObject)a, (PyObject)PyMultiarray.arrayRange(offset, shape[shape.length - 1], lastDimension + 1, 'i'), -1);
        return PyMultiarray.rotateAxes(a, 2 + axis);
    }

    public static PyObject innerProduct(PyObject oA, PyObject oB, int axisA, int axisB) {
        int i;
        int i2;
        PyMultiarray a = PyMultiarray.ascontiguous(oA);
        PyMultiarray b = PyMultiarray.ascontiguous(oB);
        if (a.dimensions.length == 0 || b.dimensions.length == 0) {
            return a.__mul__((PyObject)b);
        }
        char type = PyMultiarray.commonType(a._typecode, b._typecode);
        if (axisA < 0) {
            axisA += a.dimensions.length;
        }
        if (axisB < 0) {
            axisB += b.dimensions.length;
        }
        if (axisA < 0 || axisA >= a.dimensions.length || axisB < 0 || axisB >= b.dimensions.length) {
            throw Py.ValueError((String)"illegal axis");
        }
        if (a.dimensions[axisA] != b.dimensions[axisB]) {
            throw Py.ValueError((String)"arrays must be of same length along given axes");
        }
        a = PyMultiarray.rotateAxes(a, -axisA);
        b = PyMultiarray.rotateAxes(b, -axisB);
        int nDimsA = a.dimensions.length;
        int nDimsB = b.dimensions.length;
        int[] dimensions = new int[nDimsA + nDimsB - 2];
        int[] aDimensions = new int[nDimsA + nDimsB - 1];
        int[] bDimensions = new int[nDimsA + nDimsB - 1];
        for (i2 = 1; i2 < nDimsA; ++i2) {
            dimensions[i2 - 1] = aDimensions[i2] = a.dimensions[i2];
            bDimensions[i2] = 1;
        }
        for (i2 = 1; i2 < nDimsB; ++i2) {
            int n = b.dimensions[i2];
            bDimensions[nDimsA + i2 - 1] = n;
            dimensions[nDimsA + i2 - 2] = n;
            aDimensions[nDimsA + i2 - 1] = 1;
        }
        aDimensions[0] = bDimensions[0] = a.dimensions[0];
        a = PyMultiarray.reshape((PyObject)a, aDimensions);
        b = PyMultiarray.reshape((PyObject)b, bDimensions);
        PyMultiarray result = PyMultiarray.zeros(dimensions, type);
        for (int i3 = 0; i3 < a.dimensions[0]; ++i3) {
            result.__add__((PyObject)PyMultiarray.asarray(PyMultiarray.asarray(a.get(i3)).__mul__(b.get(i3))), result);
        }
        int[] axes = new int[result.dimensions.length];
        for (i = 0; i < nDimsA - 1; ++i) {
            axes[i] = (i + axisA) % (nDimsA - 1);
        }
        for (i = 0; i < nDimsB - 1; ++i) {
            axes[nDimsA - 1 + i] = nDimsA - 1 + (i + axisB - 1) % (nDimsB - 1);
        }
        return PyMultiarray.returnValue(PyMultiarray.transpose((PyObject)result, axes));
    }

    public static PyObject searchSorted(PyObject o, PyObject v) {
        boolean singleValue;
        PyMultiarray a = PyMultiarray.ascontiguous(o);
        PyMultiarray values = PyMultiarray.ascontiguous(v);
        if (a.dimensions.length != 1 || values.dimensions.length > 1) {
            throw Py.ValueError((String)"searchSorted only works on 1D arrays");
        }
        if (a._typecode == 'F' || a._typecode == 'D') {
            throw Py.ValueError((String)"cannot search complex arrays");
        }
        boolean bl = singleValue = values.dimensions.length == 0;
        if (singleValue) {
            values = PyMultiarray.stretchAxes(values);
        }
        PyMultiarray result = PyMultiarray.zeros(new int[]{values.dimensions[0]}, 'i');
        for (int i = 0; i < values.dimensions[0]; ++i) {
            int start = 0;
            int stop = a.dimensions[0] - 1;
            int j = (start + stop) / 2;
            if (a._typecode != 'O' && values._typecode != 'O') {
                double val;
                double value = ((Number)Array.get(values.data, values.start + i)).doubleValue();
                while (start != stop && (val = ((Number)Array.get(a.data, a.start + j)).doubleValue()) != value && stop != j) {
                    if (val < value) {
                        start = j;
                    } else {
                        stop = j;
                    }
                    j = (start + stop + 1) / 2;
                }
            } else {
                PyObject val;
                PyObject value = values.get(i);
                while (start != stop && !(val = a.get(j))._eq(value).__nonzero__() && stop != j) {
                    if (val._le(value).__nonzero__()) {
                        start = j;
                    } else {
                        stop = j;
                    }
                    j = (start + stop + 1) / 2;
                }
            }
            Array.setInt(result.data, i, j);
        }
        if (singleValue) {
            return result.get(0);
        }
        return result;
    }

    public static PyMultiarray convolve(PyObject oA0, PyObject oB0, int mode) {
        PyMultiarray a0 = PyMultiarray.asarray(oA0);
        PyMultiarray b0 = PyMultiarray.asarray(oB0);
        if (a0.dimensions.length != 1 || b0.dimensions.length != 1) {
            throw Py.ValueError((String)"convolve only works on 1D arrays");
        }
        a0 = PyMultiarray.ascontiguous((PyObject)a0);
        b0 = PyMultiarray.ascontiguous((PyObject)b0);
        PyMultiarray a = new PyMultiarray(a0.data, a0._typecode, a0.start, (int[])a0.dimensions.clone(), (int[])a0.strides.clone());
        PyMultiarray b = new PyMultiarray(b0.data, b0._typecode, b0.start, (int[])b0.dimensions.clone(), (int[])b0.strides.clone());
        char type = PyMultiarray.commonType(a._typecode, b._typecode);
        int padl = 0;
        int length = Math.max(a.dimensions[0], b.dimensions[0]);
        int n = Math.min(a.dimensions[0], b.dimensions[0]);
        switch (mode) {
            case 0: {
                length = length - n + 1;
                break;
            }
            case 1: {
                padl = n / 2;
                break;
            }
            case 2: {
                length = length + n - 1;
                padl = n - 1;
                break;
            }
            default: {
                throw Py.ValueError((String)"mode must be 0, 1, or 2");
            }
        }
        PyMultiarray result = PyMultiarray.zeros(new int[]{length}, type);
        int aSize = PyMultiarray.typeToNElements(a._typecode);
        int bSize = PyMultiarray.typeToNElements(b._typecode);
        a.strides[0] = -1;
        a.isContiguous = false;
        for (int i = n - padl - 1; i < length + (n - padl - 1); ++i) {
            int j0 = Math.max(0, i - (a0.dimensions[0] - 1));
            int j1 = Math.min(i + 1, b0.dimensions[0]);
            a.start = a0.start + aSize * (i - j0);
            b.start = b0.start + bSize * j0;
            a.dimensions[0] = b.dimensions[0] = j1 - j0;
            result.set(i - (n - padl - 1), Umath.add.reduce(a.__mul__((PyObject)b)));
        }
        return result;
    }

    public static int XC_padded_length(int length) {
        return (int)Math.pow(2.0, Math.ceil(Math.log(2.0 * (double)length) / Math.log(2.0)));
    }

    public static PyMultiarray XC_pad_vector(PyMultiarray V, int padl) {
        char type = V.typecode();
        PyMultiarray V_pad = PyMultiarray.zeros(new int[]{padl}, type);
        int V_dim = V.dimensions[0];
        int Lv2 = V_dim / 2;
        if (V_dim % 2 == 0) {
            V_pad.setslice(0, Lv2, 1, V.getslice(Lv2, V_dim, 1));
            V_pad.setslice(padl - Lv2, padl, 1, V.getslice(0, Lv2, 1));
        } else {
            V_pad.setslice(0, Lv2 + 1, 1, V.getslice(Lv2, V_dim, 1));
            V_pad.setslice(padl - Lv2, padl, 1, V.getslice(0, Lv2, 1));
        }
        return V_pad;
    }

    public static PyMultiarray XC_unpad_vector(PyMultiarray R, int lenA, int lenB, int mode) {
        PyMultiarray result;
        boolean debug_this = false;
        lenB = Math.max(lenA, lenB);
        lenA = Math.min(lenA, lenB);
        int L = lenA + lenB;
        int L2 = L / 2;
        char type = R.typecode();
        int R_dim = R.dimensions[0];
        PyMultiarray tmp = PyMultiarray.zeros(new int[]{L - 1}, type);
        if (L % 2 == 1) {
            tmp.setslice(0, L2 + 1, 1, R.getslice(R_dim - (L2 + 1), R_dim + 1, 1));
            tmp.setslice(L2, L - 1, 1, R.getslice(0, L2 - 1, 1));
        } else {
            tmp.setslice(0, L2 - 1, 1, R.getslice(R_dim - L2 + 1, R_dim, 1));
            tmp.setslice(L2 - 1, L + 1, 1, R.getslice(0, L2, 1));
        }
        int start = L - lenB;
        switch (mode) {
            case 0: {
                result = PyMultiarray.zeros(new int[]{lenB - lenA + 1}, type);
                result.setslice(0, L - 2 * start + 1, 1, tmp.getslice(start - 1, L - start, 1));
                break;
            }
            case 1: {
                result = PyMultiarray.zeros(new int[]{lenB}, type);
                result.setslice(0, lenB, 1, tmp.getslice(start / 2, lenB + start / 2, 1));
                break;
            }
            case 2: {
                result = tmp;
                break;
            }
            default: {
                throw Py.ValueError((String)"mode must be 0,1, or 2");
            }
        }
        result.setslice(0, result.dimensions[0], 1, result.getslice(result.dimensions[0], -1, -1));
        return result;
    }

    public static PyMultiarray cross_correlate(PyObject oA0, PyObject oB0, int mode) {
        PyMultiarray result;
        boolean debug_this = false;
        PyMultiarray a0 = PyMultiarray.asarray(oA0);
        PyMultiarray b0 = PyMultiarray.asarray(oB0);
        if (a0.dimensions.length != 1 || b0.dimensions.length != 1) {
            throw Py.ValueError((String)"cross_correlate only works on 1D arrays");
        }
        a0 = PyMultiarray.ascontiguous((PyObject)a0);
        b0 = PyMultiarray.ascontiguous((PyObject)b0);
        PyMultiarray a = new PyMultiarray(a0.data, a0._typecode, a0.start, (int[])a0.dimensions.clone(), (int[])a0.strides.clone());
        PyMultiarray b = new PyMultiarray(b0.data, b0._typecode, b0.start, (int[])b0.dimensions.clone(), (int[])b0.strides.clone());
        char type = PyMultiarray.commonType(a._typecode, b._typecode);
        int length = Math.max(a.dimensions[0], b.dimensions[0]);
        int padl = PyMultiarray.XC_padded_length(length);
        PyMultiarray a_pad = PyMultiarray.XC_pad_vector(a, padl);
        PyMultiarray fft_a = FFT.fft((PyObject)a_pad);
        PyMultiarray b_pad = PyMultiarray.XC_pad_vector(b, padl);
        PyMultiarray prod = PyMultiarray.zeros(new int[]{padl}, 'D');
        fft_a.__mul__(Umath.conjugate.__call__((PyObject)FFT.fft((PyObject)b_pad)), prod);
        PyMultiarray inverse_prod_real = FFT.inverse_fft((PyObject)prod).getReal();
        if (PyMultiarray.typeToKind(type) == 1) {
            PyMultiarray inverse_prod_real_round;
            inverse_prod_real = (PyMultiarray)inverse_prod_real.__add__((PyObject)Py.newFloat((double)0.5));
            inverse_prod_real = inverse_prod_real_round = PyMultiarray.asarray((PyObject)inverse_prod_real, type);
            result = PyMultiarray.XC_unpad_vector(inverse_prod_real_round, a.dimensions[0], b.dimensions[0], mode);
        } else {
            result = PyMultiarray.XC_unpad_vector(inverse_prod_real, a.dimensions[0], b.dimensions[0], mode);
        }
        return result;
    }

    final PyMultiarray getReal() {
        if (this._typecode == 'F' || this._typecode == 'D') {
            int[] dims = (int[])this.dimensions.clone();
            int[] strs = (int[])this.strides.clone();
            char type = this._typecode == 'F' ? (char)'f' : 'd';
            return new PyMultiarray(this.data, type, this.start, dims, strs);
        }
        return this;
    }

    final PyMultiarray getImag() {
        if (this._typecode == 'F' || this._typecode == 'D') {
            int[] dims = (int[])this.dimensions.clone();
            int[] strs = (int[])this.strides.clone();
            char type = this._typecode == 'F' ? (char)'f' : 'd';
            return new PyMultiarray(this.data, type, this.start + 1, dims, strs);
        }
        return null;
    }

    public static final int[] shapeOf(PyObject seq) {
        if (seq instanceof PyMultiarray) {
            return (int[])((PyMultiarray)seq).dimensions.clone();
        }
        return PyMultiarray._shapeOf(seq, 0);
    }

    private static final int[] _shapeOf(PyObject seq, int depth) {
        int items;
        if (seq instanceof PyString) {
            return new int[depth];
        }
        try {
            items = seq.__len__();
        }
        catch (Throwable e) {
            return new int[depth];
        }
        if (items == 0) {
            return new int[depth + 1];
        }
        int[] shape = PyMultiarray._shapeOf(seq.__getitem__(0), depth + 1);
        shape[depth] = items;
        for (int i = 1; i < items; ++i) {
            int[] shape2 = PyMultiarray._shapeOf(seq.__getitem__(i), depth + 1);
            if (shape.length != shape2.length) {
                throw Py.ValueError((String)"malformed array");
            }
            for (int j = depth + 1; j < shape.length; ++j) {
                if (shape[j] == shape2[j]) continue;
                throw Py.ValueError((String)"malformed array");
            }
        }
        return shape;
    }

    static PyMultiarray rotateAxes(PyMultiarray a, int n) {
        PyMultiarray result = new PyMultiarray(a.data, a._typecode, a.start, (int[])a.dimensions.clone(), (int[])a.strides.clone());
        while (n < 0) {
            n += a.dimensions.length;
        }
        for (int i = 0; i < a.dimensions.length; ++i) {
            result.dimensions[(i + n) % a.dimensions.length] = a.dimensions[i];
            result.strides[(i + n) % a.dimensions.length] = a.strides[i];
        }
        result.setIsContiguous();
        return result;
    }

    static PyMultiarray swapAxes(PyMultiarray a, int n0, int n1) {
        PyMultiarray result = new PyMultiarray(a.data, a._typecode, a.start, (int[])a.dimensions.clone(), (int[])a.strides.clone());
        if (n0 < 0) {
            n0 += a.dimensions.length;
        }
        if (n1 < 0) {
            n1 += a.dimensions.length;
        }
        if (n0 < 0 || n0 >= a.dimensions.length || n1 < 0 || n1 >= a.dimensions.length) {
            throw Py.ValueError((String)"illegal axis");
        }
        result.dimensions[n0] = a.dimensions[n1];
        result.strides[n0] = a.strides[n1];
        result.dimensions[n1] = a.dimensions[n0];
        result.strides[n1] = a.strides[n0];
        result.setIsContiguous();
        return result;
    }

    static final int typeToNElements(char typecode) {
        switch (typecode) {
            case 'D': 
            case 'F': {
                return 2;
            }
        }
        return 1;
    }

    static final char commonType(char a, char b) {
        short bsize;
        short btype;
        short newtype;
        if (a == b) {
            return a;
        }
        short atype = PyMultiarray.typeToKind(a);
        short s = newtype = atype > (btype = PyMultiarray.typeToKind(b)) ? atype : btype;
        if (newtype == 4) {
            return 'O';
        }
        short asize = PyMultiarray.typeToNBytes(a);
        short newsize = asize > (bsize = PyMultiarray.typeToNBytes(b)) ? asize : bsize;
        return PyMultiarray.kindAndNBytesToType(newtype, newsize);
    }

    static int[] objectToInts(Object jo, boolean forgiving) {
        int length;
        if (jo instanceof int[]) {
            return (int[])jo;
        }
        if (!(jo instanceof PyObject)) {
            throw Py.ValueError((String)"cannot convert argument to array of ints");
        }
        PyObject o = (PyObject)jo;
        if (PyMultiarray.shapeOf(o).length == 0) {
            if (forgiving) {
                o = PyMultiarray.asarray(o).__getitem__(Py.Ellipsis);
            } else {
                throw Py.ValueError((String)"cannot convert argument to array of ints");
            }
        }
        try {
            length = o.__len__();
        }
        catch (Throwable t) {
            return new int[]{Py.py2int((PyObject)o)};
        }
        int[] intArray = new int[length];
        for (int i = 0; i < intArray.length; ++i) {
            PyObject item = o.__getitem__(i);
            if (!forgiving && !(item instanceof PyInteger)) {
                throw Py.ValueError((String)"cannot convert argument to array of ints");
            }
            intArray[i] = Py.py2int((PyObject)o.__getitem__(i));
        }
        return intArray;
    }

    private static final PyObject[] seqToObjects(PyObject seq, int size) {
        PyObject[] flat = new PyObject[size];
        PyMultiarray._seqToObjects(seq, flat, 0);
        return flat;
    }

    private static final int _seqToObjects(PyObject seq, PyObject[] flat, int offset) {
        int items;
        if (seq instanceof PyString) {
            flat[offset] = seq;
            return offset + 1;
        }
        try {
            items = seq.__len__();
        }
        catch (Throwable t) {
            flat[offset] = seq;
            return offset + 1;
        }
        for (int i = 0; i < items; ++i) {
            offset = PyMultiarray._seqToObjects(seq.__getitem__(i), flat, offset);
        }
        return offset;
    }

    private static int[] fixedShape(int[] shape, int totalSize) {
        shape = (int[])shape.clone();
        int size = 1;
        int rubberAxis = -1;
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] == -1) {
                if (rubberAxis != -1) {
                    throw Py.ValueError((String)"illegal shape");
                }
                rubberAxis = i;
                continue;
            }
            size *= shape[i];
        }
        if (rubberAxis != -1) {
            shape[rubberAxis] = totalSize / size;
            size *= shape[rubberAxis];
        }
        if (totalSize != size) {
            throw Py.ValueError((String)"total size of new array must be unchanged");
        }
        return shape;
    }

    private static final Object objectToJava(PyObject o, char typecode, boolean returnReal) {
        if (typecode == 'O') {
            return o;
        }
        if (o instanceof PyComplex) {
            o = Py.newFloat((double)(returnReal ? ((PyComplex)o).real : ((PyComplex)o).imag));
        } else if (!returnReal) {
            o = Py.Zero;
        }
        Object number = o.__tojava__(PyMultiarray.typeToClass(typecode));
        if (number == Py.NoConversion) {
            throw Py.ValueError((String)"coercion error");
        }
        return number;
    }

    private static final char objectToType(PyObject o) {
        if (o instanceof PyInteger) {
            return 'i';
        }
        if (o instanceof PyFloat) {
            return 'd';
        }
        if (o instanceof PyComplex) {
            return 'D';
        }
        return 'O';
    }

    private static final char objectsToType(PyObject[] objects) {
        if (objects.length == 0) {
            return 'i';
        }
        short no = -1;
        short sz = -1;
        for (PyObject o : objects) {
            char _typecode = PyMultiarray.objectToType(o);
            short new_no = PyMultiarray.typeToKind(_typecode);
            short new_sz = PyMultiarray.typeToNBytes(_typecode);
            no = no > new_no ? no : new_no;
            sz = sz > new_sz ? sz : new_sz;
        }
        return PyMultiarray.kindAndNBytesToType(no, sz);
    }

    private static final Class<?> typeToClass(char typecode) {
        switch (typecode) {
            case '1': {
                return Byte.TYPE;
            }
            case 's': {
                return Short.TYPE;
            }
            case 'i': {
                return Integer.TYPE;
            }
            case 'l': {
                return Long.TYPE;
            }
            case 'F': 
            case 'f': {
                return Float.TYPE;
            }
            case 'D': 
            case 'd': {
                return Double.TYPE;
            }
            case 'O': {
                return PyObject.class;
            }
        }
        throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
    }

    private static final char classToType(Class<?> klass) {
        if (klass.equals(Byte.TYPE)) {
            return '1';
        }
        if (klass.equals(Short.TYPE)) {
            return 's';
        }
        if (klass.equals(Integer.TYPE)) {
            return 'i';
        }
        if (klass.equals(Long.TYPE)) {
            return 'l';
        }
        if (klass.equals(Float.TYPE)) {
            return 'f';
        }
        if (klass.equals(Double.TYPE)) {
            return 'd';
        }
        if (klass.equals(PyObject.class)) {
            return 'O';
        }
        throw Py.ValueError((String)"unknown class in classToType");
    }

    private static final int shapeToNItems(int[] shape) {
        int size = 1;
        for (int element : shape) {
            if (element < 0) {
                throw Py.ValueError((String)"negative dimensions are not allowed");
            }
            size *= element;
        }
        return size;
    }

    private static final int[] shapeToStrides(int[] shape, int nElements) {
        int[] strides = new int[shape.length];
        int stride = nElements;
        for (int i = shape.length - 1; i >= 0; --i) {
            strides[i] = stride;
            stride *= shape[i];
        }
        return strides;
    }

    private static final short typeToKind(char typecode) {
        switch (typecode) {
            case '1': 
            case 'i': 
            case 'l': 
            case 's': {
                return 1;
            }
            case 'd': 
            case 'f': {
                return 2;
            }
            case 'D': 
            case 'F': {
                return 3;
            }
            case 'O': {
                return 4;
            }
        }
        throw Py.ValueError((String)"internal error in typeToKind");
    }

    private static final short typeToNBytes(char typecode) {
        switch (typecode) {
            case '1': {
                return 1;
            }
            case 's': {
                return 2;
            }
            case 'F': 
            case 'f': 
            case 'i': {
                return 4;
            }
            case 'D': 
            case 'd': 
            case 'l': {
                return 8;
            }
            case 'O': {
                return 0;
            }
        }
        throw Py.ValueError((String)"internal error in typeToNBytes");
    }

    private static final char kindAndNBytesToType(short kind, short nbytes) {
        switch (kind) {
            case 1: {
                switch (nbytes) {
                    case 1: {
                        return '1';
                    }
                    case 2: {
                        return 's';
                    }
                    case 4: {
                        return 'i';
                    }
                    case 8: {
                        return 'l';
                    }
                }
                break;
            }
            case 2: {
                switch (nbytes) {
                    case 4: {
                        return 'f';
                    }
                    case 8: {
                        return 'd';
                    }
                }
                break;
            }
            case 3: {
                switch (nbytes) {
                    case 4: {
                        return 'F';
                    }
                    case 8: {
                        return 'D';
                    }
                }
                break;
            }
            case 4: {
                return 'O';
            }
        }
        throw Py.ValueError((String)"internal error in kindAndNBytesToType");
    }

    private final void setIsContiguous() {
        int[] contiguousStrides = PyMultiarray.shapeToStrides(this.dimensions, PyMultiarray.typeToNElements(this._typecode));
        for (int i = 0; i < this.strides.length; ++i) {
            if (this.strides[i] == contiguousStrides[i]) continue;
            this.isContiguous = false;
            break;
        }
    }

    private static final PyMultiarray stretchAxes(PyMultiarray a, PyMultiarray b) {
        int excess;
        if (a.dimensions.length > b.dimensions.length) {
            int excess2;
            int[] dimensions = (int[])a.dimensions.clone();
            int[] strides = (int[])a.strides.clone();
            for (int i = excess2 = a.dimensions.length - b.dimensions.length; i < dimensions.length; ++i) {
                if (dimensions[i] == b.dimensions[i - excess2]) continue;
                if (dimensions[i] == 1) {
                    dimensions[i] = b.dimensions[i - excess2];
                    strides[i] = 0;
                    continue;
                }
                if (b.dimensions[i - excess2] == 1) continue;
                throw Py.ValueError((String)"matrices not aligned");
            }
            return new PyMultiarray(a.data, a._typecode, a.start, dimensions, strides);
        }
        int[] dimensions = (int[])b.dimensions.clone();
        int[] strides = new int[dimensions.length];
        for (int i = excess = b.dimensions.length - a.dimensions.length; i < dimensions.length; ++i) {
            if (dimensions[i] != a.dimensions[i - excess]) {
                if (dimensions[i] == 1) {
                    dimensions[i] = a.dimensions[i - excess];
                } else {
                    if (a.dimensions[i - excess] == 1) continue;
                    throw Py.ValueError((String)"matrices not aligned");
                }
            }
            strides[i] = a.strides[i - excess];
        }
        return new PyMultiarray(a.data, a._typecode, a.start, dimensions, strides);
    }

    private static final PyMultiarray stretchAxes(PyMultiarray a) {
        int[] dimensions = new int[]{1};
        int[] strides = new int[]{1};
        return new PyMultiarray(a.data, a._typecode, a.start, dimensions, strides);
    }

    private static final PyMultiarray getResultArray(PyMultiarray a, PyMultiarray b, char type) {
        if (type == '\u0000') {
            type = a._typecode;
        }
        int[] dimensions = new int[a.dimensions.length];
        for (int i = 0; i < a.dimensions.length; ++i) {
            dimensions[i] = Math.max(a.dimensions[i], b.dimensions[i]);
        }
        return PyMultiarray.zeros(dimensions, type);
    }

    private static final void checkResultArray(PyMultiarray result, PyMultiarray a, PyMultiarray b) {
        if (result._typecode != a._typecode) {
            throw Py.ValueError((String)"return array has incorrect type.");
        }
        if (result.dimensions.length != a.dimensions.length) {
            throw Py.ValueError((String)"return array has the wrong number of dimensions");
        }
        for (int i = 0; i < result.dimensions.length; ++i) {
            if (result.dimensions[i] == Math.max(a.dimensions[i], b.dimensions[i])) continue;
            throw Py.ValueError((String)"return array has incorrect dimensions");
        }
    }

    public Object __tojava__(Class<?> c) {
        Class<?> type = PyMultiarray.typeToClass(this._typecode);
        if (this.dimensions.length == 0 || this._typecode == 'F' || this._typecode == 'D') {
            return super.__tojava__(c);
        }
        if (c == Object.class || c.isArray() && c.getComponentType().isAssignableFrom(type)) {
            Object jarray = Array.newInstance(type, this.dimensions);
            PyMultiarray contiguous = PyMultiarray.ascontiguous((PyObject)this);
            if (this.dimensions.length == 1) {
                for (int i = 0; i < contiguous.__len__(); ++i) {
                    Array.set(jarray, i, Array.get(contiguous.data, contiguous.start + i));
                }
                return jarray;
            }
            for (int i = 0; i < contiguous.__len__(); ++i) {
                Object subData = this.get(i).__tojava__(c);
                Array.set(jarray, i, subData);
            }
            return jarray;
        }
        return super.__tojava__(c);
    }

    public int __len__() {
        if (this.dimensions.length == 0) {
            throw Py.ValueError((String)"__len__ of zero dimensional array");
        }
        return this.dimensions[0];
    }

    public PyObject __getitem__(int index) {
        return this.get(index);
    }

    public int __cmp__(PyObject other) {
        boolean debug_this = false;
        if (!(other instanceof PyMultiarray)) {
            return -2;
        }
        PyMultiarray o = (PyMultiarray)other;
        throw Py.TypeError((String)"Comparison of multiarray objects is not implemented.");
    }

    public PyObject __getitem__(PyObject indices) {
        return PyMultiarray.returnValue(this.indicesToStructure(indices));
    }

    public void __setitem__(PyObject indices, PyObject pyValue) {
        int i;
        PyMultiarray toStructure = this.indicesToStructure(indices);
        PyMultiarray value = PyMultiarray.array(pyValue, this._typecode);
        int[] shape = (int[])toStructure.dimensions.clone();
        int[] strides = new int[toStructure.dimensions.length];
        int excess = toStructure.dimensions.length - value.dimensions.length;
        if (toStructure.dimensions.length < value.dimensions.length) {
            throw Py.ValueError((String)"object too deep for desired array");
        }
        for (i = 0; i < excess; ++i) {
            shape[i] = toStructure.dimensions[i];
        }
        for (i = excess; i < toStructure.dimensions.length; ++i) {
            shape[i] = value.dimensions[i - excess];
            strides[i] = value.strides[i - excess];
        }
        value.dimensions = shape;
        value.strides = strides;
        value.setIsContiguous();
        PyMultiarray.copyAToB(value, toStructure);
    }

    protected void setslice(int start, int stop, int step, PyObject value) {
        PyObject startObject = start >= 0 ? Py.newInteger((int)start) : Py.None;
        PyObject stopObject = stop >= 0 ? Py.newInteger((int)stop) : Py.None;
        this.__setitem__((PyObject)new PySlice(startObject, stopObject, (PyObject)Py.newInteger((int)step)), value);
    }

    protected PyObject getslice(int start, int stop, int step) {
        PyObject startObject = start >= 0 ? Py.newInteger((int)start) : Py.None;
        PyObject stopObject = stop >= 0 ? Py.newInteger((int)stop) : Py.None;
        return this.__getitem__((PyObject)new PySlice(startObject, stopObject, (PyObject)Py.newInteger((int)step)));
    }

    public PyString __repr__() {
        return Py.newString((String)PyMultiarrayPrinter.array2string(this, maxLineWidth, precision, suppressSmall, ", ", true));
    }

    public PyString __str__() {
        return Py.newString((String)PyMultiarrayPrinter.array2string(this, maxLineWidth, precision, suppressSmall, " ", false));
    }

    public PyObject __findattr_ex__(String name) {
        if (name == "__doc__") {
            return Py.newString((String)this.docString);
        }
        if (name == "shape") {
            return PyTuple.fromIterable((PyObject)new PyArray(Integer.TYPE, (Object)this.dimensions));
        }
        if (name == "real") {
            return this.getReal();
        }
        if (name == "imag" || name == "imaginary") {
            return this.getImag();
        }
        if (name == "flat" && this.isContiguous) {
            return PyMultiarray.reshape((PyObject)this, new int[]{-1});
        }
        if (name == "T" && this.dimensions.length == 2) {
            return PyMultiarray.transpose((PyObject)this, new int[]{1, 0});
        }
        return super.__findattr_ex__(name);
    }

    public void __setattr__(String name, PyObject value) throws PyException {
        PyMultiarray imag;
        if (name == "shape") {
            if (!this.isContiguous) {
                throw Py.ValueError((String)"reshape only works on contiguous matrices");
            }
            int[] shape = (int[])value.__tojava__(this.dimensions.getClass());
            this.dimensions = PyMultiarray.fixedShape(shape, PyMultiarray.shapeToNItems(this.dimensions));
            this.strides = PyMultiarray.shapeToStrides(shape, PyMultiarray.typeToNElements(this._typecode));
            return;
        }
        if ((name == "imag" || name == "imaginary") && (imag = this.getImag()) != null) {
            imag.__setitem__((PyObject)new PySlice(null, null, null), value);
            return;
        }
        if (name == "real") {
            this.getReal().__setitem__((PyObject)new PySlice(null, null, null), value);
            return;
        }
        super.__setattr__(name, value);
    }

    protected PyObject get(int i) {
        if (this.dimensions.length < 1) {
            throw Py.IndexError((String)"too few dimensions");
        }
        int newStart = this.start + this.fixIndex(i, 0) * this.strides[0];
        int[] newDimensions = new int[this.dimensions.length - 1];
        int[] newStrides = new int[this.dimensions.length - 1];
        for (int j = 0; j < this.dimensions.length - 1; ++j) {
            newDimensions[j] = this.dimensions[j + 1];
            newStrides[j] = this.strides[j + 1];
        }
        return PyMultiarray.returnValue(new PyMultiarray(this.data, this._typecode, newStart, newDimensions, newStrides));
    }

    protected PyObject pyget(int i) {
        return this.get(i);
    }

    protected PyObject repeat(int count) {
        throw Py.TypeError((String)"can't apply '*' to arrays");
    }

    protected void del(int i) {
        throw Py.TypeError((String)"can't remove from array");
    }

    protected void delRange(int start, int stop, int step) {
        throw Py.TypeError((String)"can't remove from array");
    }

    protected void set(int i, PyObject pyValue) {
        if (this.dimensions.length < 1) {
            throw Py.IndexError((String)"too few dimensions");
        }
        int newStart = this.start + this.fixIndex(i, 0) * this.strides[0];
        int[] newDimensions = new int[this.dimensions.length - 1];
        int[] newStrides = new int[this.dimensions.length - 1];
        for (int j = 0; j < this.dimensions.length - 1; ++j) {
            newDimensions[j] = this.dimensions[j + 1];
            newStrides[j] = this.strides[j + 1];
        }
        PyMultiarray.copyAToB(PyMultiarray.asarray(pyValue, this._typecode), new PyMultiarray(this.data, this._typecode, newStart, newDimensions, newStrides));
    }

    protected int fixIndex(int index, int axis) {
        if (index < 0) {
            index += this.dimensions[axis];
        }
        if (index < 0 || index >= this.dimensions[axis]) {
            throw Py.IndexError((String)"index out of range");
        }
        return index;
    }

    private static final int getIndex(PyObject index, int defaultValue) {
        if (index == Py.None || index == null) {
            return defaultValue;
        }
        if (!(index instanceof PyInteger)) {
            throw Py.TypeError((String)"slice index must be int");
        }
        return ((PyInteger)index).getValue();
    }

    protected static final int getStep1(PyObject s_step) {
        int step = PyMultiarray.getIndex(s_step, 1);
        if (step == 0) {
            throw Py.TypeError((String)"slice step of zero not allowed");
        }
        return step;
    }

    protected static final int getStart1(PyObject s_start, int step, int length) {
        int start;
        if (step < 0) {
            start = PyMultiarray.getIndex(s_start, length - 1);
            if (start < -1) {
                start = length + start;
            }
            if (start < -1) {
                start = -1;
            }
            if (start > length - 1) {
                start = length - 1;
            }
        } else {
            start = PyMultiarray.getIndex(s_start, 0);
            if (start < 0) {
                start = length + start;
            }
            if (start < 0) {
                start = 0;
            }
            if (start > length) {
                start = length;
            }
        }
        return start;
    }

    protected static final int getStop1(PyObject s_stop, int start, int step, int length) {
        int stop;
        if (step < 0) {
            stop = PyMultiarray.getIndex(s_stop, -1);
            if (stop < -1) {
                stop = length + stop;
            }
            if (stop < -1) {
                stop = -1;
            }
            if (stop > length - 1) {
                stop = length - 1;
            }
        } else {
            stop = PyMultiarray.getIndex(s_stop, length);
            if (stop < 0) {
                stop = length + stop;
            }
            if (stop < 0) {
                stop = 0;
            }
            if (stop > length) {
                stop = length;
            }
        }
        if ((stop - start) * step < 0) {
            stop = start;
        }
        return stop;
    }

    private final PyMultiarray indicesToStructure(PyObject pyIndices) {
        PyObject[] pyObjectArray;
        if (pyIndices instanceof PyTuple) {
            pyObjectArray = ((PyTuple)pyIndices).getArray();
        } else {
            PyObject[] pyObjectArray2 = new PyObject[1];
            pyObjectArray = pyObjectArray2;
            pyObjectArray2[0] = pyIndices;
        }
        PyObject[] indices = pyObjectArray;
        int nDimensions = this.dimensions.length;
        int ellipsisLength = 0;
        int axis = 0;
        for (int i = 0; i < indices.length; ++i) {
            PyObject index = indices[i];
            if (index instanceof PyEllipsis) {
                if (ellipsisLength > 0) continue;
                ellipsisLength = this.dimensions.length - (indices.length - i - 1 + axis);
                for (int j = i + 1; j < indices.length; ++j) {
                    if (!(indices[j] instanceof PyNone)) continue;
                    ++ellipsisLength;
                }
                if (ellipsisLength < 0) {
                    throw Py.IndexError((String)"too many indices");
                }
                axis += ellipsisLength;
                continue;
            }
            if (index instanceof PyNone) {
                ++nDimensions;
                continue;
            }
            if (index instanceof PyInteger) {
                --nDimensions;
                ++axis;
                continue;
            }
            if (index instanceof PySlice) {
                ++axis;
                continue;
            }
            throw Py.ValueError((String)"invalid index");
        }
        if (axis > this.dimensions.length) {
            throw Py.ValueError((String)"invalid index");
        }
        int newStart = this.start;
        int newAxis = 0;
        int oldAxis = 0;
        int[] newDimensions = new int[nDimensions];
        int[] newStrides = new int[nDimensions];
        for (PyObject index : indices) {
            if (index instanceof PyEllipsis) {
                if (ellipsisLength <= 0) continue;
                for (int j = 0; j < ellipsisLength; ++j) {
                    newDimensions[newAxis + j] = this.dimensions[oldAxis + j];
                    newStrides[newAxis + j] = this.strides[oldAxis + j];
                }
                oldAxis += ellipsisLength;
                newAxis += ellipsisLength;
                ellipsisLength = 0;
                continue;
            }
            if (index instanceof PyNone) {
                newDimensions[newAxis] = 1;
                newStrides[newAxis] = 0;
                ++newAxis;
                continue;
            }
            if (oldAxis >= this.dimensions.length) {
                throw Py.IndexError((String)"too many dimensions");
            }
            if (index instanceof PyInteger) {
                PyInteger integer = (PyInteger)index;
                newStart += this.fixIndex(integer.getValue(), oldAxis) * this.strides[oldAxis];
                ++oldAxis;
                continue;
            }
            if (index instanceof PySlice) {
                PySlice slice = (PySlice)index;
                int sliceStep = PyMultiarray.getStep1(slice.step);
                int sliceStart = PyMultiarray.getStart1(slice.start, sliceStep, this.dimensions[oldAxis]);
                int sliceStop = PyMultiarray.getStop1(slice.stop, sliceStart, sliceStep, this.dimensions[oldAxis]);
                newDimensions[newAxis] = sliceStep > 0 ? 1 + (sliceStop - sliceStart - 1) / sliceStep : 1 - (sliceStart - sliceStop - 1) / sliceStep;
                newStart += sliceStart * this.strides[oldAxis];
                newStrides[newAxis] = sliceStep * this.strides[oldAxis];
                ++oldAxis;
                ++newAxis;
                continue;
            }
            throw Py.ValueError((String)"illegal index");
        }
        for (int i = 0; i < nDimensions - newAxis; ++i) {
            newDimensions[newAxis + i] = this.dimensions[oldAxis + i];
            newStrides[newAxis + i] = this.strides[oldAxis + i];
        }
        return new PyMultiarray(this.data, this._typecode, newStart, newDimensions, newStrides);
    }

    static final PyObject returnValue(PyMultiarray a) {
        if (a.dimensions.length == 0) {
            if (PyMultiarray.typeToNElements(a._typecode) == 1) {
                return Py.java2py((Object)Array.get(a.data, a.start));
            }
            return new PyComplex(((Number)Array.get(a.data, a.start)).doubleValue(), ((Number)Array.get(a.data, a.start + 1)).doubleValue());
        }
        return a;
    }

    static void copyAToB(PyMultiarray a, PyMultiarray b) {
        if (a.dimensions.length != b.dimensions.length) {
            throw Py.ValueError((String)"copied matrices must have the same number of dimensions");
        }
        for (int i = 0; i < a.dimensions.length; ++i) {
            if (a.dimensions[i] == b.dimensions[i]) continue;
            throw Py.ValueError((String)"matrices not aligned for copy");
        }
        if (a._typecode == b._typecode && a.isContiguous && b.isContiguous) {
            System.arraycopy(a.data, a.start, b.data, b.start, PyMultiarray.typeToNElements(a._typecode) * PyMultiarray.shapeToNItems(a.dimensions));
        } else if (a.dimensions.length == 0) {
            b.__setitem__(Py.Ellipsis, a.__getitem__(Py.Ellipsis));
        } else if (a._typecode == b._typecode && a._typecode != 'F' && a._typecode != 'D') {
            PyMultiarray.copyAxToBx(a.data, a.start, a.strides, b.data, b.start, b.strides, b.dimensions, 0);
        } else if (a._typecode == 'O') {
            PyMultiarray.copyAOToB(a.data, a.start, a.strides, b.data, b.start, b.strides, b._typecode, b.dimensions, 0);
        } else {
            switch (b._typecode) {
                case '1': {
                    PyMultiarray.copyAToBb(a.data, a.start, a.strides, b.data, b.start, b.strides, b.dimensions, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.copyAToBs(a.data, a.start, a.strides, b.data, b.start, b.strides, b.dimensions, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.copyAToBi(a.data, a.start, a.strides, b.data, b.start, b.strides, b.dimensions, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.copyAToBl(a.data, a.start, a.strides, b.data, b.start, b.strides, b.dimensions, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.copyAToBf(a.data, a.start, a.strides, b.data, b.start, b.strides, b.dimensions, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.copyAToBd(a.data, a.start, a.strides, b.data, b.start, b.strides, b.dimensions, 0);
                    break;
                }
                case 'F': {
                    if (a._typecode == 'F' || a._typecode == 'D') {
                        PyMultiarray.copyAToBF(a.data, a.start, a.strides, b.data, b.start, b.strides, b.dimensions, 0);
                        break;
                    }
                    PyMultiarray.copyAToBf(a.data, a.start, a.strides, b.data, b.start, b.strides, b.dimensions, 0);
                    break;
                }
                case 'D': {
                    if (a._typecode == 'F' || a._typecode == 'D') {
                        PyMultiarray.copyAToBD(a.data, a.start, a.strides, b.data, b.start, b.strides, b.dimensions, 0);
                        break;
                    }
                    PyMultiarray.copyAToBd(a.data, a.start, a.strides, b.data, b.start, b.strides, b.dimensions, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.copyAToBO(a.data, a.start, a.strides, b.data, b.start, b.strides, b.dimensions, 0);
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
    }

    static void copyAxToBx(Object aData, int aStart, int[] aStrides, Object bData, int bStart, int[] bStrides, int[] dimensions, int depth) {
        int jMax = bStart + dimensions[depth] * bStrides[depth];
        if (depth < dimensions.length - 1) {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                PyMultiarray.copyAxToBx(aData, i, aStrides, bData, j, bStrides, dimensions, depth + 1);
                i += aStrides[depth];
            }
        } else {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                Array.set(bData, j, Array.get(aData, i));
                i += aStrides[depth];
            }
        }
    }

    static void copyAOToB(Object aData, int aStart, int[] aStrides, Object bData, int bStart, int[] bStrides, char bType, int[] dimensions, int depth) {
        int jMax = bStart + dimensions[depth] * bStrides[depth];
        if (depth < dimensions.length - 1) {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                PyMultiarray.copyAOToB(aData, i, aStrides, bData, j, bStrides, bType, dimensions, depth + 1);
                i += aStrides[depth];
            }
        } else {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                Array.set(bData, j, ((PyObject)Array.get(aData, i)).__tojava__(PyMultiarray.typeToClass(bType)));
                i += aStrides[depth];
            }
        }
    }

    static void copyAToBb(Object aData, int aStart, int[] aStrides, Object bData, int bStart, int[] bStrides, int[] dimensions, int depth) {
        int jMax = bStart + dimensions[depth] * bStrides[depth];
        if (depth < dimensions.length - 1) {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                PyMultiarray.copyAToBb(aData, i, aStrides, bData, j, bStrides, dimensions, depth + 1);
                i += aStrides[depth];
            }
        } else {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                Array.setByte(bData, j, ((Number)Array.get(aData, i)).byteValue());
                i += aStrides[depth];
            }
        }
    }

    static void copyAToBs(Object aData, int aStart, int[] aStrides, Object bData, int bStart, int[] bStrides, int[] dimensions, int depth) {
        int jMax = bStart + dimensions[depth] * bStrides[depth];
        if (depth < dimensions.length - 1) {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                PyMultiarray.copyAToBs(aData, i, aStrides, bData, j, bStrides, dimensions, depth + 1);
                i += aStrides[depth];
            }
        } else {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                Array.setShort(bData, j, ((Number)Array.get(aData, i)).shortValue());
                i += aStrides[depth];
            }
        }
    }

    static void copyAToBi(Object aData, int aStart, int[] aStrides, Object bData, int bStart, int[] bStrides, int[] dimensions, int depth) {
        int jMax = bStart + dimensions[depth] * bStrides[depth];
        if (depth < dimensions.length - 1) {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                PyMultiarray.copyAToBi(aData, i, aStrides, bData, j, bStrides, dimensions, depth + 1);
                i += aStrides[depth];
            }
        } else {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                Array.setInt(bData, j, ((Number)Array.get(aData, i)).intValue());
                i += aStrides[depth];
            }
        }
    }

    static void copyAToBl(Object aData, int aStart, int[] aStrides, Object bData, int bStart, int[] bStrides, int[] dimensions, int depth) {
        int jMax = bStart + dimensions[depth] * bStrides[depth];
        if (depth < dimensions.length - 1) {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                PyMultiarray.copyAToBl(aData, i, aStrides, bData, j, bStrides, dimensions, depth + 1);
                i += aStrides[depth];
            }
        } else {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                Array.setLong(bData, j, ((Number)Array.get(aData, i)).longValue());
                i += aStrides[depth];
            }
        }
    }

    static void copyAToBf(Object aData, int aStart, int[] aStrides, Object bData, int bStart, int[] bStrides, int[] dimensions, int depth) {
        int jMax = bStart + dimensions[depth] * bStrides[depth];
        if (depth < dimensions.length - 1) {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                PyMultiarray.copyAToBf(aData, i, aStrides, bData, j, bStrides, dimensions, depth + 1);
                i += aStrides[depth];
            }
        } else {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                Array.setFloat(bData, j, ((Number)Array.get(aData, i)).floatValue());
                i += aStrides[depth];
            }
        }
    }

    static void copyAToBd(Object aData, int aStart, int[] aStrides, Object bData, int bStart, int[] bStrides, int[] dimensions, int depth) {
        int jMax = bStart + dimensions[depth] * bStrides[depth];
        if (depth < dimensions.length - 1) {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                PyMultiarray.copyAToBd(aData, i, aStrides, bData, j, bStrides, dimensions, depth + 1);
                i += aStrides[depth];
            }
        } else {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                Array.setDouble(bData, j, ((Number)Array.get(aData, i)).doubleValue());
                i += aStrides[depth];
            }
        }
    }

    static void copyAToBF(Object aData, int aStart, int[] aStrides, Object bData, int bStart, int[] bStrides, int[] dimensions, int depth) {
        int jMax = bStart + dimensions[depth] * bStrides[depth];
        if (depth < dimensions.length - 1) {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                PyMultiarray.copyAToBF(aData, i, aStrides, bData, j, bStrides, dimensions, depth + 1);
                i += aStrides[depth];
            }
        } else {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                Array.setFloat(bData, j, ((Number)Array.get(aData, i)).floatValue());
                Array.setFloat(bData, j + 1, ((Number)Array.get(aData, i + 1)).floatValue());
                i += aStrides[depth];
            }
        }
    }

    static void copyAToBD(Object aData, int aStart, int[] aStrides, Object bData, int bStart, int[] bStrides, int[] dimensions, int depth) {
        int jMax = bStart + dimensions[depth] * bStrides[depth];
        if (depth < dimensions.length - 1) {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                PyMultiarray.copyAToBD(aData, i, aStrides, bData, j, bStrides, dimensions, depth + 1);
                i += aStrides[depth];
            }
        } else {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                Array.setDouble(bData, j, ((Number)Array.get(aData, i)).doubleValue());
                Array.setDouble(bData, j + 1, ((Number)Array.get(aData, i + 1)).doubleValue());
                i += aStrides[depth];
            }
        }
    }

    static void copyAToBO(Object aData, int aStart, int[] aStrides, Object bData, int bStart, int[] bStrides, int[] dimensions, int depth) {
        int jMax = bStart + dimensions[depth] * bStrides[depth];
        if (depth < dimensions.length - 1) {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                PyMultiarray.copyAToBO(aData, i, aStrides, bData, j, bStrides, dimensions, depth + 1);
                i += aStrides[depth];
            }
        } else {
            int i = aStart;
            for (int j = bStart; j != jMax; j += bStrides[depth]) {
                Array.set(bData, j, Py.java2py((Object)Array.get(aData, i)));
                i += aStrides[depth];
            }
        }
    }

    static byte[] toByteArray(Object data, char type) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(byteStream);
            switch (type) {
                case '1': {
                    for (int i = 0; i < Array.getLength(data); ++i) {
                        dataStream.writeByte(Array.getByte(data, i));
                    }
                    break;
                }
                case 's': {
                    for (int i = 0; i < Array.getLength(data); ++i) {
                        dataStream.writeShort(Array.getShort(data, i));
                    }
                    break;
                }
                case 'i': {
                    for (int i = 0; i < Array.getLength(data); ++i) {
                        dataStream.writeInt(Array.getInt(data, i));
                    }
                    break;
                }
                case 'l': {
                    for (int i = 0; i < Array.getLength(data); ++i) {
                        dataStream.writeLong(Array.getLong(data, i));
                    }
                    break;
                }
                case 'F': 
                case 'f': {
                    for (int i = 0; i < Array.getLength(data); ++i) {
                        dataStream.writeFloat(Array.getFloat(data, i));
                    }
                    break;
                }
                case 'D': 
                case 'd': {
                    for (int i = 0; i < Array.getLength(data); ++i) {
                        dataStream.writeDouble(Array.getDouble(data, i));
                    }
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
            return byteStream.toByteArray();
        }
        catch (IOException e) {
            throw Py.RuntimeError((String)("ioexception:" + e.getMessage()));
        }
    }

    static Object fromByteArray(byte[] bytes, char type) {
        if (bytes.length % PyMultiarray.typeToNBytes(type) != 0) {
            throw Py.ValueError((String)"array size must be a multiple of the type size");
        }
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            DataInputStream dataStream = new DataInputStream(byteStream);
            Object data = Array.newInstance(PyMultiarray.typeToClass(type), bytes.length / PyMultiarray.typeToNBytes(type));
            switch (type) {
                case '1': {
                    for (int i = 0; i < Array.getLength(data); ++i) {
                        Array.setByte(data, i, dataStream.readByte());
                    }
                    break;
                }
                case 's': {
                    for (int i = 0; i < Array.getLength(data); ++i) {
                        Array.setShort(data, i, dataStream.readShort());
                    }
                    break;
                }
                case 'i': {
                    for (int i = 0; i < Array.getLength(data); ++i) {
                        Array.setInt(data, i, dataStream.readInt());
                    }
                    break;
                }
                case 'l': {
                    for (int i = 0; i < Array.getLength(data); ++i) {
                        Array.setLong(data, i, dataStream.readLong());
                    }
                    break;
                }
                case 'F': 
                case 'f': {
                    for (int i = 0; i < Array.getLength(data); ++i) {
                        Array.setFloat(data, i, dataStream.readFloat());
                    }
                    break;
                }
                case 'D': 
                case 'd': {
                    for (int i = 0; i < Array.getLength(data); ++i) {
                        Array.setDouble(data, i, dataStream.readDouble());
                    }
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
            return data;
        }
        catch (IOException e) {
            throw Py.RuntimeError((String)("ioexception:" + e.getMessage()));
        }
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer("arrayObject(data=[");
        int dataLength = Array.getLength(this.data);
        for (i = 0; i < dataLength - 1; ++i) {
            buf.append(Array.get(this.data, i).toString());
            buf.append(", ");
        }
        if (dataLength > 0) {
            buf.append(Array.get(this.data, dataLength - 1).toString());
        }
        buf.append("], typecode=");
        buf.append(this._typecode);
        buf.append(", start=");
        buf.append(new Integer(this.start).toString());
        buf.append(", dimensions=[");
        for (i = 0; i < this.dimensions.length - 1; ++i) {
            buf.append(new Integer(this.dimensions[i]).toString());
            buf.append(",");
        }
        if (this.dimensions.length > 0) {
            buf.append(new Integer(this.dimensions[this.dimensions.length - 1]).toString());
        }
        buf.append("], strides=[");
        for (i = 0; i < this.strides.length - 1; ++i) {
            buf.append(new Integer(this.strides[i]).toString());
            buf.append(",");
        }
        if (this.strides.length > 0) {
            buf.append(new Integer(this.strides[this.strides.length - 1]).toString());
        }
        buf.append("])");
        return buf.toString();
    }

    public PyObject __radd__(PyObject po) {
        return this.__add__(po);
    }

    public PyObject __rsub__(PyObject po) {
        return PyMultiarray.array(po).__sub__((PyObject)this);
    }

    public PyObject __rmul__(PyObject po) {
        return this.__mul__(po);
    }

    public PyObject __rdiv__(PyObject po) {
        return PyMultiarray.array(po).__div__((PyObject)this);
    }

    public PyObject __rmod__(PyObject po) {
        return PyMultiarray.array(po).__mod__((PyObject)this);
    }

    public PyObject __divmod__(PyObject po) {
        PyObject mod = this.__mod__(po);
        PyObject div = this.__sub__(mod).__div__(po);
        return new PyTuple(new PyObject[]{div, mod});
    }

    public PyObject __rdivmod__(PyObject po) {
        return PyMultiarray.array(po).__divmod__((PyObject)this);
    }

    static final void mulComplexFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != finalSr) {
                float re = aData[sa] * bData[sb] - aData[sa + 1] * bData[sb + 1];
                rData[sr + 1] = aData[sa] * bData[sb + 1] + aData[sa + 1] * bData[sb];
                rData[sr] = re;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.mulComplexFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void mulComplexDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != finalSr) {
                double re = aData[sa] * bData[sb] - aData[sa + 1] * bData[sb + 1];
                rData[sr + 1] = aData[sa] * bData[sb + 1] + aData[sa + 1] * bData[sb];
                rData[sr] = re;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.mulComplexDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void divComplexFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != finalSr) {
                float den = bData[sb] * bData[sb] + bData[sb + 1] * bData[sb + 1];
                float re = (aData[sa] * bData[sb] + aData[sa + 1] * bData[sb + 1]) / den;
                rData[sr + 1] = (-aData[sa] * bData[sb + 1] + aData[sa + 1] * bData[sb]) / den;
                rData[sr] = re;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.divComplexFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void divComplexDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != finalSr) {
                double den = bData[sb] * bData[sb] + bData[sb + 1] * bData[sb + 1];
                double re = (aData[sa] * bData[sb] + aData[sa + 1] * bData[sb + 1]) / den;
                rData[sr + 1] = (-aData[sa] * bData[sb + 1] + aData[sa + 1] * bData[sb]) / den;
                rData[sr] = re;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.divComplexDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void addComplexFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != finalSr) {
                rData[sr] = aData[sa] + bData[sb];
                rData[sr + 1] = aData[sa + 1] + bData[sb + 1];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.addComplexFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void addComplexDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != finalSr) {
                rData[sr] = aData[sa] + bData[sb];
                rData[sr + 1] = aData[sa + 1] + bData[sb + 1];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.addComplexDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void subComplexFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != finalSr) {
                rData[sr] = aData[sa] - bData[sb];
                rData[sr + 1] = aData[sa + 1] - bData[sb + 1];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.subComplexFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void subComplexDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != finalSr) {
                rData[sr] = aData[sa] - bData[sb];
                rData[sr + 1] = aData[sa + 1] - bData[sb + 1];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.subComplexDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void modComplexFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != finalSr) {
                float reA = aData[sa];
                float imA = aData[sa + 1];
                float reB = bData[sb];
                float imB = bData[sb + 1];
                float den = reB * reB + imB * imB;
                float n = (float)Math.floor((reA * reB + imA * imB) / den);
                rData[sr] = reA - n * reB;
                rData[sr + 1] = imA - n * imB;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.modComplexFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void modComplexDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != finalSr) {
                double reA = aData[sa];
                double imA = aData[sa + 1];
                double reB = bData[sb];
                double imB = bData[sb + 1];
                double den = reB * reB + imB * imB;
                double n = Math.floor((reA * reB + imA * imB) / den);
                rData[sr] = reA - n * reB;
                rData[sr + 1] = imA - n * imB;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.modComplexDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void powComplexFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != finalSr) {
                PyComplex Z = (PyComplex)new PyComplex((double)aData[sa], (double)aData[sa + 1]).__pow__((PyObject)new PyComplex((double)bData[sb], (double)bData[sb + 1]));
                rData[sr] = (float)Z.real;
                rData[sr + 1] = (float)Z.imag;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.powComplexFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void powComplexDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != finalSr) {
                PyComplex Z = (PyComplex)new PyComplex(aData[sa], aData[sa + 1]).__pow__((PyObject)new PyComplex(bData[sb], bData[sb + 1]));
                rData[sr] = Z.real;
                rData[sr + 1] = Z.imag;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.powComplexDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void maxComplexFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        throw Py.ValueError((String)"cannot perform ordered compare on complex numbers");
    }

    static final void maxComplexDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        throw Py.ValueError((String)"cannot perform ordered compare on complex numbers");
    }

    static final void minComplexFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        throw Py.ValueError((String)"cannot perform ordered compare on complex numbers");
    }

    static final void minComplexDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        throw Py.ValueError((String)"cannot perform ordered compare on complex numbers");
    }

    static final void eqComplexFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != finalSr) {
                rData[sa] = aData[sa] == bData[sb] && aData[sa + 1] == bData[sb + 1] ? 1.0f : 0.0f;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.eqComplexFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void eqComplexDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != finalSr) {
                rData[sa] = aData[sa] == bData[sb] && aData[sa + 1] == bData[sb + 1] ? 1.0 : 0.0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.eqComplexDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void neqComplexFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != finalSr) {
                rData[sa] = aData[sa] == bData[sb] && aData[sa + 1] == bData[sb + 1] ? 0.0f : 1.0f;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.neqComplexFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void neqComplexDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != finalSr) {
                rData[sa] = aData[sa] == bData[sb] && aData[sa + 1] == bData[sb + 1] ? 0.0 : 1.0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.neqComplexDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void landComplexFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            int[] rData = (int[])r.data;
            while (sr != finalSr) {
                rData[sa] = !(aData[sa] == 0.0f && aData[sa + 1] == 0.0f || bData[sb] == 0.0f && bData[sb + 1] == 0.0f) ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.landComplexFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void landComplexDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            int[] rData = (int[])r.data;
            while (sr != finalSr) {
                rData[sa] = !(aData[sa] == 0.0 && aData[sa + 1] == 0.0 || bData[sb] == 0.0 && bData[sb + 1] == 0.0) ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.landComplexDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void lorComplexFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            int[] rData = (int[])r.data;
            while (sr != finalSr) {
                rData[sa] = aData[sa] != 0.0f || aData[sa + 1] != 0.0f || bData[sb] != 0.0f || bData[sb + 1] != 0.0f ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.lorComplexFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    static final void lorComplexDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int finalSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            int[] rData = (int[])r.data;
            while (sr != finalSr) {
                rData[sa] = aData[sa] != 0.0 || aData[sa + 1] != 0.0 || bData[sb] != 0.0 || bData[sb + 1] != 0.0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != finalSr) {
                PyMultiarray.lorComplexDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void lxorComplexFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sa] = (aData[sa] != 0.0f || aData[sa + 1] != 0.0f) ^ (bData[sb] != 0.0f || bData[sb + 1] != 0.0f) ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lxorComplexFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void lxorComplexDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sa] = (aData[sa] != 0.0 || aData[sa + 1] != 0.0) ^ (bData[sb] != 0.0 || bData[sb + 1] != 0.0) ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lxorComplexDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    PyMultiarray absComplexFloat(PyMultiarray a) {
        int length = PyMultiarray.shapeToNItems(a.dimensions);
        float[] aData = (float[])a.data;
        float[] result = new float[length];
        int i = a.start;
        for (int j = 0; j < length; ++j) {
            result[j] = (float)Math.sqrt(aData[i] * aData[i] + aData[i + 1] * aData[i + 1]);
            i += 2;
        }
        return new PyMultiarray(result, 'f', 0, new int[]{length}, new int[]{1});
    }

    PyMultiarray absComplexDouble(PyMultiarray a) {
        int length = PyMultiarray.shapeToNItems(a.dimensions);
        double[] aData = (double[])a.data;
        double[] result = new double[length];
        int i = a.start;
        for (int j = 0; j < length; ++j) {
            result[j] = Math.sqrt(aData[i] * aData[i] + aData[i + 1] * aData[i + 1]);
            i += 2;
        }
        return new PyMultiarray(result, 'd', 0, new int[]{length}, new int[]{1});
    }

    PyMultiarray negComplexFloat(PyMultiarray a) {
        float[] aData = (float[])a.data;
        for (int i = 0; i < aData.length; ++i) {
            aData[i] = -aData[i];
        }
        return a;
    }

    PyMultiarray negComplexDouble(PyMultiarray a) {
        double[] aData = (double[])a.data;
        for (int i = 0; i < aData.length; ++i) {
            aData[i] = -aData[i];
        }
        return a;
    }

    static final long pow(long x, long n) {
        double logtwox;
        int nbits = 63;
        long r = 1L;
        long p = x;
        long mask = 1L;
        if (n < 0L) {
            throw Py.ValueError((String)"Integer to a negative power");
        }
        if (x != 0L && (logtwox = Math.log(Math.abs((double)x)) / Math.log(2.0)) * (double)n > 63.0) {
            throw new PyException(Py.ArithmeticError, "Integer overflow in power.");
        }
        while (mask > 0L && n >= mask) {
            if ((n & mask) != 0L) {
                r *= p;
            }
            mask <<= 1;
            p *= p;
        }
        return r;
    }

    static final int pow(int x, int n) {
        double logtwox;
        int nbits = 31;
        long r = 1L;
        long p = x;
        long mask = 1L;
        if (n < 0) {
            throw Py.ValueError((String)"Integer to a negative power");
        }
        if (x != 0 && (logtwox = Math.log(Math.abs((double)x)) / Math.log(2.0)) * (double)n > 31.0) {
            throw new PyException(Py.ArithmeticError, "Integer overflow in power.");
        }
        while (mask > 0L && (long)n >= mask) {
            if (((long)n & mask) != 0L) {
                r *= p;
            }
            mask <<= 1;
            p *= p;
        }
        return (int)r;
    }

    static final short pow(short x, short n) {
        double logtwox;
        int nbits = 15;
        long r = 1L;
        long p = x;
        long mask = 1L;
        if (n < 0) {
            throw Py.ValueError((String)"Integer to a negative power");
        }
        if (x != 0 && (logtwox = Math.log(Math.abs((double)x)) / Math.log(2.0)) * (double)n > 15.0) {
            throw new PyException(Py.ArithmeticError, "Integer overflow in power.");
        }
        while (mask > 0L && (long)n >= mask) {
            if (((long)n & mask) != 0L) {
                r *= p;
            }
            mask <<= 1;
            p *= p;
        }
        return (short)r;
    }

    static final byte pow(byte x, byte n) {
        double logtwox;
        int nbits = 7;
        long r = 1L;
        long p = x;
        long mask = 1L;
        if (n < 0) {
            throw Py.ValueError((String)"Integer to a negative power");
        }
        if (x != 0 && (logtwox = Math.log(Math.abs((double)x)) / Math.log(2.0)) * (double)n > 7.0) {
            throw new PyException(Py.ArithmeticError, "Integer overflow in power.");
        }
        while (mask > 0L && (long)n >= mask) {
            if (((long)n & mask) != 0L) {
                r *= p;
            }
            mask <<= 1;
            p *= p;
        }
        return (byte)r;
    }

    static final double pow(double x, double n) {
        return Math.pow(x, n);
    }

    static final float pow(float x, float n) {
        return (float)Math.pow(x, n);
    }

    private static final void addByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            byte[] rData = (byte[])r.data;
            while (sr != maxSr) {
                rData[sr] = (byte)(aData[sa] + bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.addByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void addShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            short[] rData = (short[])r.data;
            while (sr != maxSr) {
                rData[sr] = (short)(aData[sa] + bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.addShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void addInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] + bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.addInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void addLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            long[] rData = (long[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] + bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.addLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void addFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] + bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.addFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void addDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] + bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.addDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void addObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            PyObject[] rData = (PyObject[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa]._add(bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.addObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __add__(PyObject o) {
        return this.__add__(o, null);
    }

    PyObject __add__(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, '\u0000');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__add__((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.addByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.addShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.addInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.addLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.addFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.addDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.addObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    PyMultiarray.addComplexFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'D': {
                    PyMultiarray.addComplexDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void subByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            byte[] rData = (byte[])r.data;
            while (sr != maxSr) {
                rData[sr] = (byte)(aData[sa] - bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.subByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void subShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            short[] rData = (short[])r.data;
            while (sr != maxSr) {
                rData[sr] = (short)(aData[sa] - bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.subShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void subInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] - bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.subInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void subLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            long[] rData = (long[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] - bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.subLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void subFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] - bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.subFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void subDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] - bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.subDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void subObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            PyObject[] rData = (PyObject[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa]._sub(bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.subObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __sub__(PyObject o) {
        return this.__sub__(o, null);
    }

    PyObject __sub__(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, '\u0000');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__sub__((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.subByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.subShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.subInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.subLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.subFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.subDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.subObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    PyMultiarray.subComplexFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'D': {
                    PyMultiarray.subComplexDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void mulByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            byte[] rData = (byte[])r.data;
            while (sr != maxSr) {
                rData[sr] = (byte)(aData[sa] * bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.mulByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void mulShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            short[] rData = (short[])r.data;
            while (sr != maxSr) {
                rData[sr] = (short)(aData[sa] * bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.mulShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void mulInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] * bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.mulInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void mulLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            long[] rData = (long[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] * bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.mulLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void mulFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] * bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.mulFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void mulDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] * bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.mulDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void mulObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            PyObject[] rData = (PyObject[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa]._mul(bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.mulObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __mul__(PyObject o) {
        return this.__mul__(o, null);
    }

    PyObject __mul__(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, '\u0000');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__mul__((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.mulByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.mulShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.mulInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.mulLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.mulFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.mulDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.mulObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    PyMultiarray.mulComplexFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'D': {
                    PyMultiarray.mulComplexDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void divByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            byte[] rData = (byte[])r.data;
            while (sr != maxSr) {
                rData[sr] = (byte)(aData[sa] / bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.divByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void divShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            short[] rData = (short[])r.data;
            while (sr != maxSr) {
                rData[sr] = (short)(aData[sa] / bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.divShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void divInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] / bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.divInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void divLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            long[] rData = (long[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] / bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.divLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void divFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] / bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.divFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void divDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] / bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.divDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void divObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            PyObject[] rData = (PyObject[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa]._div(bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.divObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __div__(PyObject o) {
        return this.__div__(o, null);
    }

    PyObject __div__(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = this.astype(type);
        b = b.astype(type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, '\u0000');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        try {
            if (result.dimensions.length == 0) {
                result.__setitem__(Py.Ellipsis, a.__div__((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
            } else {
                switch (type) {
                    case '1': {
                        PyMultiarray.divByte(a.start, a, b.start, b, result.start, result, 0);
                        break;
                    }
                    case 's': {
                        PyMultiarray.divShort(a.start, a, b.start, b, result.start, result, 0);
                        break;
                    }
                    case 'i': {
                        PyMultiarray.divInt(a.start, a, b.start, b, result.start, result, 0);
                        break;
                    }
                    case 'l': {
                        PyMultiarray.divLong(a.start, a, b.start, b, result.start, result, 0);
                        break;
                    }
                    case 'f': {
                        PyMultiarray.divFloat(a.start, a, b.start, b, result.start, result, 0);
                        break;
                    }
                    case 'd': {
                        PyMultiarray.divDouble(a.start, a, b.start, b, result.start, result, 0);
                        break;
                    }
                    case 'O': {
                        PyMultiarray.divObject(a.start, a, b.start, b, result.start, result, 0);
                        break;
                    }
                    case 'F': {
                        PyMultiarray.divComplexFloat(a.start, a, b.start, b, result.start, result, 0);
                        break;
                    }
                    case 'D': {
                        PyMultiarray.divComplexDouble(a.start, a, b.start, b, result.start, result, 0);
                        break;
                    }
                    default: {
                        throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                    }
                }
            }
        }
        catch (ArithmeticException ex) {
            if (ex.getMessage().equals("/ by zero")) {
                throw Py.ZeroDivisionError((String)"divide by zero");
            }
            throw ex;
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void modByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            byte[] rData = (byte[])r.data;
            while (sr != maxSr) {
                rData[sr] = (byte)(aData[sa] % bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.modByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void modShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            short[] rData = (short[])r.data;
            while (sr != maxSr) {
                rData[sr] = (short)(aData[sa] % bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.modShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void modInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] % bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.modInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void modLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            long[] rData = (long[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] % bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.modLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void modFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] % bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.modFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void modDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] % bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.modDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void modObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            PyObject[] rData = (PyObject[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa]._mod(bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.modObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __mod__(PyObject o) {
        return this.__mod__(o, null);
    }

    PyObject __mod__(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, '\u0000');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__mod__((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.modByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.modShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.modInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.modLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.modFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.modDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.modObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    PyMultiarray.modComplexFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'D': {
                    PyMultiarray.modComplexDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void powByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            byte[] rData = (byte[])r.data;
            while (sr != maxSr) {
                rData[sr] = PyMultiarray.pow(aData[sa], bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.powByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void powShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            short[] rData = (short[])r.data;
            while (sr != maxSr) {
                rData[sr] = PyMultiarray.pow(aData[sa], bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.powShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void powInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = PyMultiarray.pow(aData[sa], bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.powInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void powLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            long[] rData = (long[])r.data;
            while (sr != maxSr) {
                rData[sr] = PyMultiarray.pow(aData[sa], bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.powLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void powFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != maxSr) {
                rData[sr] = PyMultiarray.pow(aData[sa], bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.powFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void powDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != maxSr) {
                rData[sr] = PyMultiarray.pow(aData[sa], bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.powDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void powObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            PyObject[] rData = (PyObject[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa]._pow(bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.powObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __pow__(PyObject o) {
        return this.__pow__(o, null);
    }

    PyObject __pow__(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, '\u0000');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__pow__((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.powByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.powShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.powInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.powLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.powFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.powDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.powObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    PyMultiarray.powComplexFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'D': {
                    PyMultiarray.powComplexDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void maxByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            byte[] rData = (byte[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] > bData[sb] ? aData[sa] : bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.maxByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void maxShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            short[] rData = (short[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] > bData[sb] ? aData[sa] : bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.maxShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void maxInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] > bData[sb] ? aData[sa] : bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.maxInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void maxLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            long[] rData = (long[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] > bData[sb] ? aData[sa] : bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.maxLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void maxFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] > bData[sb] ? aData[sa] : bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.maxFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void maxDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] > bData[sb] ? aData[sa] : bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.maxDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public static PyObject myMax(PyObject a, PyObject b) {
        return b._gt(a).__nonzero__() ? b : a;
    }

    public static PyObject myMin(PyObject a, PyObject b) {
        return b._lt(a).__nonzero__() ? b : a;
    }

    private static final void maxObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            PyObject[] rData = (PyObject[])r.data;
            while (sr != maxSr) {
                rData[sr] = PyMultiarray.myMax(aData[sa], bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.maxObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __max(PyObject o) {
        return this.__max(o, null);
    }

    PyObject __max(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, '\u0000');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__max((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.maxByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.maxShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.maxInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.maxLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.maxFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.maxDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.maxObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    PyMultiarray.maxComplexFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'D': {
                    PyMultiarray.maxComplexDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void minByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            byte[] rData = (byte[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] < bData[sb] ? aData[sa] : bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.minByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void minShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            short[] rData = (short[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] < bData[sb] ? aData[sa] : bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.minShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void minInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] < bData[sb] ? aData[sa] : bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.minInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void minLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            long[] rData = (long[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] < bData[sb] ? aData[sa] : bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.minLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void minFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            float[] rData = (float[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] < bData[sb] ? aData[sa] : bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.minFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void minDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            double[] rData = (double[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] < bData[sb] ? aData[sa] : bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.minDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void minObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            PyObject[] rData = (PyObject[])r.data;
            while (sr != maxSr) {
                rData[sr] = PyMultiarray.myMin(aData[sa], bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.minObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __min(PyObject o) {
        return this.__min(o, null);
    }

    PyObject __min(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, '\u0000');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__min((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.minByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.minShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.minInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.minLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.minFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.minDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.minObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    PyMultiarray.minComplexFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'D': {
                    PyMultiarray.minComplexDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void eqByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] == bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.eqByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void eqShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] == bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.eqShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void eqInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] == bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.eqInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void eqLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] == bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.eqLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void eqFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] == bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.eqFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void eqDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] == bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.eqDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void eqObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = __builtin__.cmp((PyObject)aData[sa], (PyObject)bData[sb]) == 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.eqObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __eq(PyObject o) {
        return this.__eq(o, null);
    }

    PyObject __eq(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, 'i');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__eq((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.eqByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.eqShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.eqInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.eqLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.eqFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.eqDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.eqObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    PyMultiarray.eqComplexFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'D': {
                    PyMultiarray.eqComplexDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void neqByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.neqByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void neqShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.neqShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void neqInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.neqInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void neqLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.neqLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void neqFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.neqFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void neqDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.neqDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void neqObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = __builtin__.cmp((PyObject)aData[sa], (PyObject)bData[sb]) != 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.neqObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __neq(PyObject o) {
        return this.__neq(o, null);
    }

    PyObject __neq(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, 'i');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__neq((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.neqByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.neqShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.neqInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.neqLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.neqFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.neqDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.neqObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    PyMultiarray.neqComplexFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'D': {
                    PyMultiarray.neqComplexDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void leByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] <= bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.leByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void leShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] <= bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.leShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void leInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] <= bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.leInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void leLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] <= bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.leLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void leFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] <= bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.leFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void leDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] <= bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.leDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void leObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = __builtin__.cmp((PyObject)aData[sa], (PyObject)bData[sb]) <= 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.leObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __le(PyObject o) {
        return this.__le(o, null);
    }

    PyObject __le(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, 'i');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__le((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.leByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.leShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.leInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.leLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.leFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.leDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.leObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    throw Py.ValueError((String)"le not supported for type ComplexFloat");
                }
                case 'D': {
                    throw Py.ValueError((String)"le not supported for type ComplexDouble");
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void ltByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] < bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.ltByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void ltShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] < bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.ltShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void ltInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] < bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.ltInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void ltLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] < bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.ltLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void ltFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] < bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.ltFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void ltDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] < bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.ltDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void ltObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = __builtin__.cmp((PyObject)aData[sa], (PyObject)bData[sb]) < 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.ltObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __lt(PyObject o) {
        return this.__lt(o, null);
    }

    PyObject __lt(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, 'i');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__lt((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.ltByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.ltShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.ltInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.ltLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.ltFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.ltDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.ltObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    throw Py.ValueError((String)"lt not supported for type ComplexFloat");
                }
                case 'D': {
                    throw Py.ValueError((String)"lt not supported for type ComplexDouble");
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void geByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] >= bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.geByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void geShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] >= bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.geShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void geInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] >= bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.geInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void geLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] >= bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.geLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void geFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] >= bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.geFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void geDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] >= bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.geDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void geObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = __builtin__.cmp((PyObject)aData[sa], (PyObject)bData[sb]) >= 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.geObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __ge(PyObject o) {
        return this.__ge(o, null);
    }

    PyObject __ge(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, 'i');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__ge((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.geByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.geShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.geInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.geLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.geFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.geDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.geObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    throw Py.ValueError((String)"ge not supported for type ComplexFloat");
                }
                case 'D': {
                    throw Py.ValueError((String)"ge not supported for type ComplexDouble");
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void gtByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] > bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.gtByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void gtShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] > bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.gtShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void gtInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] > bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.gtInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void gtLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] > bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.gtLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void gtFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] > bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.gtFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void gtDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] > bData[sb] ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.gtDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void gtObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = __builtin__.cmp((PyObject)aData[sa], (PyObject)bData[sb]) > 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.gtObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __gt(PyObject o) {
        return this.__gt(o, null);
    }

    PyObject __gt(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, 'i');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__gt((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.gtByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.gtShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.gtInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.gtLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.gtFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.gtDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.gtObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    throw Py.ValueError((String)"gt not supported for type ComplexFloat");
                }
                case 'D': {
                    throw Py.ValueError((String)"gt not supported for type ComplexDouble");
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void landByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0 & bData[sb] != 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.landByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void landShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0 & bData[sb] != 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.landShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void landInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0 & bData[sb] != 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.landInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void landLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0L & bData[sb] != 0L ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.landLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void landFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0.0f & bData[sb] != 0.0f ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.landFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void landDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0.0 & bData[sb] != 0.0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.landDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void landObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa].__nonzero__() & bData[sb].__nonzero__() ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.landObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __land(PyObject o) {
        return this.__land(o, null);
    }

    PyObject __land(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, 'i');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__land((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.landByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.landShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.landInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.landLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.landFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.landDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.landObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    PyMultiarray.landComplexFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'D': {
                    PyMultiarray.landComplexDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void lorByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0 | bData[sb] != 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lorByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void lorShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0 | bData[sb] != 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lorShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void lorInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0 | bData[sb] != 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lorInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void lorLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0L | bData[sb] != 0L ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lorLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void lorFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0.0f | bData[sb] != 0.0f ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lorFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void lorDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0.0 | bData[sb] != 0.0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lorDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void lorObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa].__nonzero__() | bData[sb].__nonzero__() ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lorObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __lor(PyObject o) {
        return this.__lor(o, null);
    }

    PyObject __lor(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, 'i');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__lor((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.lorByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.lorShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.lorInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.lorLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.lorFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.lorDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.lorObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    PyMultiarray.lorComplexFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'D': {
                    PyMultiarray.lorComplexDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void lxorByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0 ^ bData[sb] != 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lxorByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void lxorShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0 ^ bData[sb] != 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lxorShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void lxorInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0 ^ bData[sb] != 0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lxorInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void lxorLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0L ^ bData[sb] != 0L ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lxorLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void lxorFloat(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            float[] aData = (float[])a.data;
            float[] bData = (float[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0.0f ^ bData[sb] != 0.0f ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lxorFloat(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void lxorDouble(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            double[] aData = (double[])a.data;
            double[] bData = (double[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] != 0.0 ^ bData[sb] != 0.0 ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lxorDouble(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void lxorObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa].__nonzero__() ^ bData[sb].__nonzero__() ? 1 : 0;
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.lxorObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __lxor(PyObject o) {
        return this.__lxor(o, null);
    }

    PyObject __lxor(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, 'i');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__lxor((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.lxorByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.lxorShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.lxorInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.lxorLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    PyMultiarray.lxorFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'd': {
                    PyMultiarray.lxorDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'O': {
                    PyMultiarray.lxorObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    PyMultiarray.lxorComplexFloat(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'D': {
                    PyMultiarray.lxorComplexDouble(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void andByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            byte[] rData = (byte[])r.data;
            while (sr != maxSr) {
                rData[sr] = (byte)(aData[sa] & bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.andByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void andShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            short[] rData = (short[])r.data;
            while (sr != maxSr) {
                rData[sr] = (short)(aData[sa] & bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.andShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void andInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] & bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.andInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void andLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            long[] rData = (long[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] & bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.andLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void andObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            PyObject[] rData = (PyObject[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa].__and__(bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.andObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __and__(PyObject o) {
        return this.__and__(o, null);
    }

    PyObject __and__(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, '\u0000');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__and__((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.andByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.andShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.andInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.andLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    throw Py.ValueError((String)"and not supported for type Float");
                }
                case 'd': {
                    throw Py.ValueError((String)"and not supported for type Double");
                }
                case 'O': {
                    PyMultiarray.andObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    throw Py.ValueError((String)"and not supported for type ComplexFloat");
                }
                case 'D': {
                    throw Py.ValueError((String)"and not supported for type ComplexDouble");
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void orByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            byte[] rData = (byte[])r.data;
            while (sr != maxSr) {
                rData[sr] = (byte)(aData[sa] | bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.orByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void orShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            short[] rData = (short[])r.data;
            while (sr != maxSr) {
                rData[sr] = (short)(aData[sa] | bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.orShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void orInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] | bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.orInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void orLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            long[] rData = (long[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] | bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.orLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void orObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            PyObject[] rData = (PyObject[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa].__or__(bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.orObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __or__(PyObject o) {
        return this.__or__(o, null);
    }

    PyObject __or__(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, '\u0000');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__or__((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.orByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.orShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.orInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.orLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    throw Py.ValueError((String)"or not supported for type Float");
                }
                case 'd': {
                    throw Py.ValueError((String)"or not supported for type Double");
                }
                case 'O': {
                    PyMultiarray.orObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    throw Py.ValueError((String)"or not supported for type ComplexFloat");
                }
                case 'D': {
                    throw Py.ValueError((String)"or not supported for type ComplexDouble");
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    private static final void xorByte(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            byte[] aData = (byte[])a.data;
            byte[] bData = (byte[])b.data;
            byte[] rData = (byte[])r.data;
            while (sr != maxSr) {
                rData[sr] = (byte)(aData[sa] ^ bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.xorByte(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void xorShort(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            short[] aData = (short[])a.data;
            short[] bData = (short[])b.data;
            short[] rData = (short[])r.data;
            while (sr != maxSr) {
                rData[sr] = (short)(aData[sa] ^ bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.xorShort(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void xorInt(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            int[] aData = (int[])a.data;
            int[] bData = (int[])b.data;
            int[] rData = (int[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] ^ bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.xorInt(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void xorLong(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            long[] aData = (long[])a.data;
            long[] bData = (long[])b.data;
            long[] rData = (long[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa] ^ bData[sb];
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.xorLong(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    private static final void xorObject(int sa, PyMultiarray a, int sb, PyMultiarray b, int sr, PyMultiarray r, int d) {
        int dsa = a.strides[d];
        int dsb = b.strides[d];
        int dsr = r.strides[d];
        int maxSr = sr + r.dimensions[d] * r.strides[d];
        if (d == r.dimensions.length - 1) {
            PyObject[] aData = (PyObject[])a.data;
            PyObject[] bData = (PyObject[])b.data;
            PyObject[] rData = (PyObject[])r.data;
            while (sr != maxSr) {
                rData[sr] = aData[sa].__xor__(bData[sb]);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        } else {
            while (sr != maxSr) {
                PyMultiarray.xorObject(sa, a, sb, b, sr, r, d + 1);
                sa += dsa;
                sb += dsb;
                sr += dsr;
            }
        }
    }

    public PyObject __xor__(PyObject o) {
        return this.__xor__(o, null);
    }

    PyObject __xor__(PyObject o, PyMultiarray result) {
        PyMultiarray b = PyMultiarray.asarray(o);
        char type = PyMultiarray.commonType(this._typecode, b._typecode);
        PyMultiarray a = PyMultiarray.asarray((PyObject)this, type);
        b = PyMultiarray.asarray((PyObject)b, type);
        a = PyMultiarray.stretchAxes(a, b);
        b = PyMultiarray.stretchAxes(b, this);
        if (result == null) {
            result = PyMultiarray.getResultArray(a, b, '\u0000');
        } else {
            PyMultiarray.checkResultArray(result, a, b);
        }
        if (result.dimensions.length == 0) {
            result.__setitem__(Py.Ellipsis, a.__xor__((PyObject)PyMultiarray.stretchAxes(b)).__getitem__(0));
        } else {
            switch (type) {
                case '1': {
                    PyMultiarray.xorByte(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 's': {
                    PyMultiarray.xorShort(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'i': {
                    PyMultiarray.xorInt(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'l': {
                    PyMultiarray.xorLong(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'f': {
                    throw Py.ValueError((String)"xor not supported for type Float");
                }
                case 'd': {
                    throw Py.ValueError((String)"xor not supported for type Double");
                }
                case 'O': {
                    PyMultiarray.xorObject(a.start, a, b.start, b, result.start, result, 0);
                    break;
                }
                case 'F': {
                    throw Py.ValueError((String)"xor not supported for type ComplexFloat");
                }
                case 'D': {
                    throw Py.ValueError((String)"xor not supported for type ComplexDouble");
                }
                default: {
                    throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
                }
            }
        }
        return PyMultiarray.returnValue(result);
    }

    public boolean isNumberType() throws PyIgnoreMethodTag {
        return true;
    }

    public PyObject __abs__() {
        return PyMultiarray.returnValue(this.__abs__(PyMultiarray.array((PyObject)this)));
    }

    PyMultiarray __abs__(PyMultiarray a) {
        if (!a.isContiguous) {
            throw Py.ValueError((String)"internal __abs__ requires contiguous matrix as argument");
        }
        switch (a._typecode) {
            case '1': {
                byte[] aData1 = (byte[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aData1[i] = aData1[i] > 0 ? aData1[i] : -aData1[i];
                }
                break;
            }
            case 's': {
                short[] aDatas = (short[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDatas[i] = aDatas[i] > 0 ? aDatas[i] : -aDatas[i];
                }
                break;
            }
            case 'i': {
                int[] aDatai = (int[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDatai[i] = aDatai[i] > 0 ? aDatai[i] : -aDatai[i];
                }
                break;
            }
            case 'l': {
                long[] aDatal = (long[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDatal[i] = aDatal[i] > 0L ? aDatal[i] : -aDatal[i];
                }
                break;
            }
            case 'f': {
                float[] aDataf = (float[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDataf[i] = aDataf[i] > 0.0f ? aDataf[i] : -aDataf[i];
                }
                break;
            }
            case 'd': {
                double[] aDatad = (double[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDatad[i] = aDatad[i] > 0.0 ? aDatad[i] : -aDatad[i];
                }
                break;
            }
            case 'O': {
                PyObject[] aDataO = (PyObject[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDataO[i] = aDataO[i].__abs__();
                }
                break;
            }
            case 'F': {
                a = this.absComplexFloat(a);
                break;
            }
            case 'D': {
                a = this.absComplexDouble(a);
                break;
            }
            default: {
                throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
            }
        }
        return a;
    }

    public PyObject __neg__() {
        return PyMultiarray.returnValue(this.__neg__(PyMultiarray.array((PyObject)this)));
    }

    PyMultiarray __neg__(PyMultiarray a) {
        if (!a.isContiguous) {
            throw Py.ValueError((String)"internal __neg__ requires contiguous matrix as argument");
        }
        switch (a._typecode) {
            case '1': {
                byte[] aData1 = (byte[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aData1[i] = -aData1[i];
                }
                break;
            }
            case 's': {
                short[] aDatas = (short[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDatas[i] = -aDatas[i];
                }
                break;
            }
            case 'i': {
                int[] aDatai = (int[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDatai[i] = -aDatai[i];
                }
                break;
            }
            case 'l': {
                long[] aDatal = (long[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDatal[i] = -aDatal[i];
                }
                break;
            }
            case 'f': {
                float[] aDataf = (float[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDataf[i] = -aDataf[i];
                }
                break;
            }
            case 'd': {
                double[] aDatad = (double[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDatad[i] = -aDatad[i];
                }
                break;
            }
            case 'O': {
                PyObject[] aDataO = (PyObject[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDataO[i] = aDataO[i].__neg__();
                }
                break;
            }
            case 'F': {
                a = this.negComplexFloat(a);
                break;
            }
            case 'D': {
                a = this.negComplexDouble(a);
                break;
            }
            default: {
                throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
            }
        }
        return a;
    }

    public PyObject __not__() {
        return PyMultiarray.returnValue(this.__not__(PyMultiarray.array((PyObject)this)));
    }

    PyMultiarray __not__(PyMultiarray a) {
        if (!a.isContiguous) {
            throw Py.ValueError((String)"internal __not__ requires contiguous matrix as argument");
        }
        switch (a._typecode) {
            case '1': {
                byte[] aData1 = (byte[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aData1[i] = ~aData1[i];
                }
                break;
            }
            case 's': {
                short[] aDatas = (short[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDatas[i] = ~aDatas[i];
                }
                break;
            }
            case 'i': {
                int[] aDatai = (int[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDatai[i] = ~aDatai[i];
                }
                break;
            }
            case 'l': {
                long[] aDatal = (long[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDatal[i] = aDatal[i] ^ 0xFFFFFFFFFFFFFFFFL;
                }
                break;
            }
            case 'f': {
                throw Py.ValueError((String)"not not supported for type Float");
            }
            case 'd': {
                throw Py.ValueError((String)"not not supported for type Double");
            }
            case 'O': {
                PyObject[] aDataO = (PyObject[])a.data;
                for (int i = 0; i < Array.getLength(a.data); ++i) {
                    aDataO[i] = aDataO[i].__not__();
                }
                break;
            }
            case 'F': {
                throw Py.ValueError((String)"not not supported for type ComplexFloat");
            }
            case 'D': {
                throw Py.ValueError((String)"not not supported for type ComplexDouble");
            }
            default: {
                throw Py.ValueError((String)"typecode must be in [1silfFdDO]");
            }
        }
        return a;
    }
}

