/*
 * Decompiled with CFR 0.152.
 */
package com.github.tbekolay.jnumeric;

import com.github.tbekolay.jnumeric.BinaryFunction;
import com.github.tbekolay.jnumeric.PyMultiarray;
import org.python.core.Py;
import org.python.core.PyObject;

final class Remainder
extends BinaryFunction {
    Remainder() {
    }

    @Override
    final PyMultiarray identity() {
        return BinaryFunction.one;
    }

    @Override
    final void accumulate(Object aData, int sa, int dim, int dsa, Object rData, int sr, int rDim, int dsr, char type) {
        int maxSa = sa + dim * dsa;
        switch (type) {
            case '1': {
                byte last1 = 1;
                byte[] rData1 = (byte[])rData;
                byte[] aData1 = (byte[])aData;
                while (sa != maxSa) {
                    rData1[sr] = last1 = (byte)(last1 % aData1[sa]);
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 's': {
                short lasts = 1;
                short[] rDatas = (short[])rData;
                short[] aDatas = (short[])aData;
                while (sa != maxSa) {
                    rDatas[sr] = lasts = (short)(lasts % aDatas[sa]);
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'i': {
                int lasti = 1;
                int[] rDatai = (int[])rData;
                int[] aDatai = (int[])aData;
                while (sa != maxSa) {
                    rDatai[sr] = lasti %= aDatai[sa];
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'l': {
                long lastl = 1L;
                long[] rDatal = (long[])rData;
                long[] aDatal = (long[])aData;
                while (sa != maxSa) {
                    rDatal[sr] = lastl %= aDatal[sa];
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'f': {
                float lastf = 1.0f;
                float[] rDataf = (float[])rData;
                float[] aDataf = (float[])aData;
                while (sa != maxSa) {
                    rDataf[sr] = lastf %= aDataf[sa];
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'd': {
                double lastd = 1.0;
                double[] rDatad = (double[])rData;
                double[] aDatad = (double[])aData;
                while (sa != maxSa) {
                    rDatad[sr] = lastd %= aDatad[sa];
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'F': {
                float lastfr = 1.0f;
                float lastfi = 0.0f;
                float[] rDataF = (float[])rData;
                float[] aDataF = (float[])aData;
                while (sa != maxSa) {
                    float reA = lastfr;
                    float imA = lastfi;
                    float reB = aDataF[sa];
                    float imB = aDataF[sa + 1];
                    float den = reB * reB + imB * imB;
                    float n = (float)Math.floor((reA * reB + imA * imB) / den);
                    rDataF[sr] = lastfr = reA - n * reB;
                    rDataF[sr + 1] = lastfi = imA - n * imB;
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'D': {
                double lastdr = 1.0;
                double lastdi = 0.0;
                double[] rDataD = (double[])rData;
                double[] aDataD = (double[])aData;
                while (sa != maxSa) {
                    double reA = lastdr;
                    double imA = lastdi;
                    double reB = aDataD[sa];
                    double imB = aDataD[sa + 1];
                    double den = reB * reB + imB * imB;
                    double n = Math.floor((reA * reB + imA * imB) / den);
                    rDataD[sr] = lastdr = reA - n * reB;
                    rDataD[sr + 1] = lastdi = imA - n * imB;
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'O': {
                super.accumulate(aData, sa, dim, dsa, rData, sr, rDim, dsr, type);
                break;
            }
            default: {
                throw Py.ValueError((String)"typecd must be in [zcbhilfdFDO]");
            }
        }
    }

    @Override
    public final PyObject call(PyObject po1, PyObject po2) {
        return po1.__mod__(po2);
    }

    @Override
    final PyObject call(PyMultiarray a, PyMultiarray b, PyMultiarray result) {
        return a.__mod__((PyObject)b, result);
    }
}

