/*
 * Decompiled with CFR 0.152.
 */
package com.github.tbekolay.jnumeric;

import com.github.tbekolay.jnumeric.PyMultiarray;
import com.github.tbekolay.jnumeric.UnaryFunction;
import java.lang.reflect.Array;

final class Sqrt
extends UnaryFunction {
    Sqrt() {
    }

    @Override
    String docString() {
        return "sqrt(a [,r]) returns sqrt(a) and stores the result in r if supplied.\n";
    }

    @Override
    public PyMultiarray Double(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); ++i) {
            Array.setDouble(a.data, i, Math.sqrt(Array.getDouble(a.data, i)));
        }
        return a;
    }

    @Override
    public PyMultiarray ComplexDouble(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); i += 2) {
            double re = Array.getDouble(a.data, i);
            double im = Array.getDouble(a.data, i + 1);
            double mag = Math.pow(re * re + im * im, 0.25);
            double phi = Math.atan2(im, re) / 2.0;
            Array.setDouble(a.data, i, mag * Math.cos(phi));
            Array.setDouble(a.data, i + 1, mag * Math.sin(phi));
        }
        return a;
    }
}

