/*
 * Decompiled with CFR 0.152.
 */
package com.github.tbekolay.jnumeric;

import com.github.tbekolay.jnumeric.BinaryFunction;
import com.github.tbekolay.jnumeric.PyMultiarray;
import org.python.core.Py;
import org.python.core.PyObject;

final class Subtract
extends BinaryFunction {
    Subtract() {
    }

    @Override
    String docString() {
        return "subtract(a, b [,r]) returns a-b and stores the result in r if supplied.\n";
    }

    @Override
    final PyMultiarray identity() {
        return BinaryFunction.zero;
    }

    @Override
    final void accumulate(Object aData, int sa, int dim, int dsa, Object rData, int sr, int rDim, int dsr, char type) {
        int maxSa = sa + dim * dsa;
        switch (type) {
            case '1': {
                byte last1 = 0;
                byte[] rData1 = (byte[])rData;
                byte[] aData1 = (byte[])aData;
                while (sa != maxSa) {
                    rData1[sr] = last1 = (byte)(last1 - aData1[sa]);
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 's': {
                short lasts = 0;
                short[] rDatas = (short[])rData;
                short[] aDatas = (short[])aData;
                while (sa != maxSa) {
                    rDatas[sr] = lasts = (short)(lasts - aDatas[sa]);
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'i': {
                int lasti = 0;
                int[] rDatai = (int[])rData;
                int[] aDatai = (int[])aData;
                while (sa != maxSa) {
                    rDatai[sr] = lasti -= aDatai[sa];
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'l': {
                long lastl = 0L;
                long[] rDatal = (long[])rData;
                long[] aDatal = (long[])aData;
                while (sa != maxSa) {
                    rDatal[sr] = lastl -= aDatal[sa];
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'f': {
                float lastf = 0.0f;
                float[] rDataf = (float[])rData;
                float[] aDataf = (float[])aData;
                while (sa != maxSa) {
                    rDataf[sr] = lastf -= aDataf[sa];
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'd': {
                double lastd = 0.0;
                double[] rDatad = (double[])rData;
                double[] aDatad = (double[])aData;
                while (sa != maxSa) {
                    rDatad[sr] = lastd -= aDatad[sa];
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'F': {
                float lastfr = 0.0f;
                float lastfi = 0.0f;
                float[] rDataF = (float[])rData;
                float[] aDataF = (float[])aData;
                while (sa != maxSa) {
                    rDataF[sr] = lastfr -= aDataF[sa];
                    rDataF[sr + 1] = lastfi -= aDataF[sa + 1];
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'D': {
                double lastdr = 0.0;
                double lastdi = 0.0;
                double[] rDataD = (double[])rData;
                double[] aDataD = (double[])aData;
                while (sa != maxSa) {
                    rDataD[sr] = lastdr -= aDataD[sa];
                    rDataD[sr + 1] = lastdi -= aDataD[sa + 1];
                    sa += dsa;
                    sr += dsr;
                }
                break;
            }
            case 'O': {
                super.accumulate(aData, sa, dim, dsa, rData, sr, rDim, dsr, type);
                break;
            }
            default: {
                throw Py.ValueError((String)"typecd must be in [zcbhilfdFDO]");
            }
        }
    }

    @Override
    final PyObject call(PyObject po1, PyObject po2) {
        return po1.__sub__(po2);
    }

    @Override
    final PyObject call(PyMultiarray a, PyMultiarray b, PyMultiarray result) {
        return a.__sub__((PyObject)b, result);
    }
}

