/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.clip;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.TopologyException;
import es.unex.sextante.core.Sextante;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;

public class ClipOperation
extends GeometryOperation {
    private Geometry clippingConvexHull = null;

    public ClipOperation(org.gvsig.fmap.geom.Geometry clip, AbstractSextanteGeoProcess p) {
        super(p);
        this.clippingConvexHull = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)clip);
    }

    public EditableFeature invoke(org.gvsig.fmap.geom.Geometry g, Feature feature) {
        if (g == null) {
            return this.lastEditFeature;
        }
        Geometry jtsGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g);
        if (!jtsGeom.getEnvelope().intersects(this.clippingConvexHull.getEnvelope())) {
            return this.lastEditFeature;
        }
        if (jtsGeom.intersects(this.clippingConvexHull)) {
            try {
                Geometry newGeom = jtsGeom.intersection(this.clippingConvexHull);
                this.lastEditFeature = this.persister.addFeature(feature, newGeom);
            }
            catch (TopologyException e) {
                Sextante.addErrorToLog((Throwable)e);
                if (!jtsGeom.isValid()) {
                    System.out.println("La geometria de entrada no es valida");
                    jtsGeom = GeometryUtil.removeDuplicatesFrom((Geometry)jtsGeom);
                }
                if (!this.clippingConvexHull.isValid()) {
                    System.out.println("La geometria de recorte no es valida");
                    this.clippingConvexHull = GeometryUtil.removeDuplicatesFrom((Geometry)this.clippingConvexHull);
                }
                try {
                    Geometry newGeom = jtsGeom.intersection(this.clippingConvexHull);
                    this.lastEditFeature = this.persister.addFeature(feature, newGeom);
                }
                catch (TopologyException ee) {
                    Sextante.addErrorToLog((Throwable)ee);
                }
                catch (CreateGeometryException ee) {
                    Sextante.addErrorToLog((Throwable)ee);
                }
                catch (DataException ee) {
                    Sextante.addErrorToLog((Throwable)ee);
                }
            }
            catch (CreateGeometryException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            catch (DataException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        return this.lastEditFeature;
    }

    public void invoke(org.gvsig.fmap.geom.Geometry g, EditableFeature feature) {
        if (g == null) {
            return;
        }
        this.lastEditFeature = feature;
        Geometry jtsGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g);
        if (!jtsGeom.getEnvelope().intersects(this.clippingConvexHull.getEnvelope())) {
            return;
        }
        if (jtsGeom.intersects(this.clippingConvexHull)) {
            try {
                Geometry newGeom = jtsGeom.intersection(this.clippingConvexHull);
                this.persister.addFeature((Feature)feature, newGeom);
            }
            catch (TopologyException e) {
                Sextante.addErrorToLog((Throwable)e);
                if (!jtsGeom.isValid()) {
                    System.out.println("La geometria de entrada no es valida");
                    jtsGeom = GeometryUtil.removeDuplicatesFrom((Geometry)jtsGeom);
                }
                if (!this.clippingConvexHull.isValid()) {
                    System.out.println("La geometria de recorte no es valida");
                    this.clippingConvexHull = GeometryUtil.removeDuplicatesFrom((Geometry)this.clippingConvexHull);
                }
                try {
                    Geometry newGeom = jtsGeom.intersection(this.clippingConvexHull);
                    this.persister.addFeature((Feature)feature, newGeom);
                }
                catch (TopologyException ee) {
                    Sextante.addErrorToLog((Throwable)ee);
                }
                catch (CreateGeometryException ee) {
                    Sextante.addErrorToLog((Throwable)ee);
                }
                catch (DataException ee) {
                    Sextante.addErrorToLog((Throwable)ee);
                }
            }
            catch (CreateGeometryException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            catch (DataException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    public void end() {
        this.persister.end();
    }

    public String getProcessDescription() {
        return "Clipping features agaisnt a clip geometry";
    }
}

