/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.impl;

import org.gvsig.catalog.CatalogLibrary;
import org.gvsig.catalog.CatalogLocator;
import org.gvsig.catalog.CatalogManager;
import org.gvsig.catalog.csw.drivers.CSWISO19115CatalogServiceDriver;
import org.gvsig.catalog.csw.drivers.CSWebRIMCatalogServiceDriver;
import org.gvsig.catalog.impl.DefaultCatalogManager;
import org.gvsig.catalog.schemas.DeegreeISO19115Record;
import org.gvsig.catalog.schemas.DublinCoreRecord;
import org.gvsig.catalog.schemas.GeonetworkISO19115Record;
import org.gvsig.catalog.schemas.IdecISO19115Record;
import org.gvsig.catalog.schemas.IdeeISO19115Record;
import org.gvsig.catalog.schemas.Iso19139Record;
import org.gvsig.catalog.schemas.LaitsGmuEbRIMRecord;
import org.gvsig.catalog.schemas.LaitsGmuISO19115Record;
import org.gvsig.catalog.schemas.LaitsGmuServicesRecord;
import org.gvsig.catalog.srw.drivers.SRWCatalogServiceDriver;
import org.gvsig.catalog.z3950.drivers.Z3950CatalogServiceDriver;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;

public class DefaultCatalogLibrary
extends AbstractLibrary {
    public void doRegistration() {
        this.registerAsImplementationOf(CatalogLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
        CatalogLocator.registerCatalogManager(DefaultCatalogManager.class);
    }

    protected void doPostInitialize() throws LibraryException {
        CatalogManager catalogManager = CatalogLocator.getCatalogManager();
        catalogManager.register("z3950", Z3950CatalogServiceDriver.class);
        catalogManager.register("srw", SRWCatalogServiceDriver.class);
        catalogManager.register("csw/iso 19115", CSWISO19115CatalogServiceDriver.class);
        catalogManager.register("csw/ebrim", CSWebRIMCatalogServiceDriver.class);
        catalogManager.addRecord(new GeonetworkISO19115Record());
        catalogManager.addRecord(new DeegreeISO19115Record());
        catalogManager.addRecord(new DublinCoreRecord());
        catalogManager.addRecord(new IdecISO19115Record());
        catalogManager.addRecord(new IdeeISO19115Record());
        catalogManager.addRecord(new Iso19139Record());
        catalogManager.addRecord(new LaitsGmuISO19115Record());
        catalogManager.addRecord(new LaitsGmuServicesRecord());
        catalogManager.addRecord(new LaitsGmuEbRIMRecord());
    }
}

