/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.schemas;

import java.net.URI;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.metadataxml.XMLTree;
import org.gvsig.catalog.schemas.Record;
import org.gvsig.catalog.schemas.Resource;

public class IdecISO19115Record
extends Record {
    public IdecISO19115Record() {
    }

    public IdecISO19115Record(URI uri, XMLNode node) {
        super(uri, node);
        this.setTitle(XMLTree.searchNodeValue(node, "identificationInfo->MD_DataIdentification->citation->title"));
        this.setAbstract_(XMLTree.searchNodeValue(node, "identificationInfo->MD_DataIdentification->abstract"));
        this.setPurpose(XMLTree.searchNodeValue(node, "identificationInfo->MD_DataIdentification->purpose"));
        this.setKeyWords(XMLTree.searchMultipleNodeValue(node, "identificationInfo->MD_DataIdentification->descriptiveKeywords->keyword"));
        this.setResources(this.getResources("distributionInfo->distributor->distributorTransferOptions->onLine"));
    }

    private Resource[] getResources(String label) {
        XMLNode[] nodes = XMLTree.searchMultipleNode(this.getNode(), label);
        if (nodes == null) {
            return null;
        }
        Resource[] resources = new Resource[nodes.length];
        for (int i = 0; i < resources.length; ++i) {
            String sProtocol = XMLTree.searchNodeValue(nodes[i], "protocol");
            String sName = XMLTree.searchNodeValue(nodes[i], "orName");
            if (sProtocol == null) {
                sProtocol = "WWW:LINK";
                sName = "orName";
            }
            resources[i] = new Resource(XMLTree.searchNodeValue(nodes[i], "linkage"), sProtocol, sName, "orDesc", "", "", null);
        }
        return resources;
    }

    @Override
    public boolean accept(URI uri, XMLNode node) {
        return node.getName().endsWith("MD_Metadata") && node.searchNode("identificationInfo->MD_DataIdentification->citation->title") != null;
    }
}

