/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.schemas;

import java.net.URI;
import java.util.ArrayList;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.schemas.DeegreeISO19115Record;
import org.gvsig.catalog.schemas.DublinCoreRecord;
import org.gvsig.catalog.schemas.GeonetworkISO19115Record;
import org.gvsig.catalog.schemas.IdecISO19115Record;
import org.gvsig.catalog.schemas.IdeeISO19115Record;
import org.gvsig.catalog.schemas.Iso19139Record;
import org.gvsig.catalog.schemas.Iso19139_119Record;
import org.gvsig.catalog.schemas.LaitsGmuEbRIMRecord;
import org.gvsig.catalog.schemas.LaitsGmuISO19115Record;
import org.gvsig.catalog.schemas.LaitsGmuServicesRecord;
import org.gvsig.catalog.schemas.Record;
import org.gvsig.catalog.schemas.UnknownRecord;

public class RecordFactory {
    private static ArrayList records = null;

    public static void addRecord(Record record) {
        records.add(record);
    }

    public static Record createRecord(URI uri, XMLNode node) {
        for (int i = 0; i < records.size(); ++i) {
            Record record = (Record)records.get(i);
            if (node == null || !record.accept(uri, node)) continue;
            Object[] values = new Object[]{uri, node};
            Class[] types = new Class[]{URI.class, XMLNode.class};
            try {
                return (Record)record.getClass().getConstructor(types).newInstance(values);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new UnknownRecord(uri, node);
    }

    static {
        records = new ArrayList();
        records.add(new GeonetworkISO19115Record());
        records.add(new DeegreeISO19115Record());
        records.add(new DublinCoreRecord());
        records.add(new IdecISO19115Record());
        records.add(new IdeeISO19115Record());
        records.add(new Iso19139Record());
        records.add(new Iso19139_119Record());
        records.add(new LaitsGmuISO19115Record());
        records.add(new LaitsGmuServicesRecord());
        records.add(new LaitsGmuEbRIMRecord());
    }
}

