/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.utils.resourcestable;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import org.gvsig.catalog.schemas.Resource;
import org.gvsig.catalog.ui.chooseresource.ChooseResourceDialogPanel;

public class ButtonEditor
extends DefaultCellEditor {
    protected JButton button;
    private String label;
    private boolean isPushed;
    private ChooseResourceDialogPanel dialog;
    private Collection resources = new ArrayList();

    public ButtonEditor(JCheckBox checkBox, Collection resources, ChooseResourceDialogPanel dialog) {
        super(checkBox);
        this.resources = resources;
        this.dialog = dialog;
        this.button = new JButton();
        this.button.setOpaque(true);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.button.setForeground(table.getSelectionForeground());
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setForeground(table.getForeground());
            this.button.setBackground(table.getBackground());
        }
        this.label = value == null ? "" : value.toString();
        this.button.setText(this.label);
        this.button.setName(String.valueOf(row));
        this.isPushed = true;
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isPushed) {
            Resource resource = (Resource)this.resources.toArray()[Integer.valueOf(this.button.getName())];
            this.dialog.resourceButtonActionPerformed(resource);
        }
        this.isPushed = false;
        return new String(this.label);
    }

    @Override
    public boolean stopCellEditing() {
        this.isPushed = false;
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

