/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.DelegatedGeometryExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionEvaluatorLocator;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.exception.SQLBuilderUnsupportedOperationException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.SQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.sqlite.dal.SQLiteHelper;
import org.gvsig.sqlite.dal.expressionbuilderformatter.SQLiteFormatter;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryBuilder;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryColumns;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.gvsig.sqlite.dal.geopackage.index.GeopackageIndexRTree;
import org.gvsig.sqlite.dal.utils.TemplateUtils;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.util.Bitmask;
import org.sqlite.SQLiteConnection;

public class SQLiteSQLBuilder
extends JDBCSQLBuilderBase {
    protected Formatter formatter = null;

    public SQLiteSQLBuilder(SQLiteHelper helper) {
        super((JDBCHelper)helper);
        this.defaultSchema = "";
        this.supportSchemas = false;
        this.allowAutomaticValues = true;
        this.geometrySupportType = this.helper.getGeometrySupportType();
        this.hasSpatialFunctions = this.helper.hasSpatialFunctions();
        this.expression().geometry_support_type(this.geometrySupportType);
        this.STMT_DELETE_GEOMETRY_COLUMN_FROM_TABLE_schema_table = null;
        this.STMT_DELETE_GEOMETRY_COLUMN_FROM_TABLE_table = "DELETE FROM gpkg_geometry_columns WHERE table_name = {0}";
        this.STMT_UPDATE_TABLE_STATISTICS_table = "ANALYZE {0}";
        this.type_boolean = "BOOLEAN";
        this.type_byte = "TINYINT";
        this.type_bytearray = "BLOB";
        this.type_geometry = "BLOB";
        this.type_char = "CHARACTER(1)";
        this.type_date = "DATE";
        this.type_double = "DOUBLE PRECISION";
        this.type_decimal_ps = "DECIMAL({0,Number,##########},{1,Number,##########})";
        this.type_decimal_p = "DECIMAL({0,Number,##########})";
        this.type_float = "FLOAT";
        this.type_int = "INTEGER";
        this.type_long = "BIGINT";
        this.type_string = "TEXT";
        this.type_string_p = "VARCHAR({0,Number,#######})";
        this.type_time = "TIME";
        this.type_timestamp = "DATETIME";
        this.type_version = "VARCHAR(30)";
        this.type_URI = "TEXT";
        this.type_URL = "TEXT";
        this.type_FILE = "TEXT";
        this.type_FOLDER = "TEXT";
    }

    public Object sqlgeometrydimension(int type, int subtype) {
        switch (subtype) {
            default: {
                return "XY";
            }
            case 2: {
                return "XYM";
            }
            case 1: {
                return "XYZ";
            }
            case 3: 
        }
        return "XYZM";
    }

    public SQLiteHelper getHelper() {
        return (SQLiteHelper)this.helper;
    }

    public Disposable setParameters(PreparedStatement st, FeatureProvider feature) {
        try {
            FeatureType featureType = feature.getType();
            ArrayList<Object> values = new ArrayList<Object>();
            block10: for (ExpressionBuilder.Parameter parameter : this.parameters()) {
                if (parameter.is_constant()) {
                    values.add(parameter.value());
                    continue;
                }
                String name = parameter.name();
                FeatureAttributeDescriptor descriptor = featureType.getAttributeDescriptor(name);
                switch (descriptor.getType()) {
                    case 9: {
                        Date value = (Date)feature.get(name);
                        if (value == null) {
                            values.add(null);
                            continue block10;
                        }
                        LocalDateTime localDate = DataTypeUtils.toLocalDateTime((Date)value);
                        DateTimeFormatter dtFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                        values.add(localDate.format(dtFormatter));
                        continue block10;
                    }
                    case 10: {
                        Time time = (Time)feature.get(name);
                        if (time == null) {
                            values.add(null);
                            continue block10;
                        }
                        LocalDateTime localDate = DataTypeUtils.toLocalDateTime((Date)time);
                        DateTimeFormatter dtFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
                        values.add(localDate.format(dtFormatter));
                        continue block10;
                    }
                    case 11: {
                        Timestamp timestamp = (Timestamp)feature.get(name);
                        if (timestamp == null) {
                            values.add(null);
                            continue block10;
                        }
                        LocalDateTime localDate = DataTypeUtils.toLocalDateTime((Date)timestamp);
                        DateTimeFormatter dtFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        values.add(localDate.format(dtFormatter));
                        continue block10;
                    }
                    case 66: {
                        Geometry geom = this.forceGeometryType(descriptor.getGeomType(), (Geometry)feature.get(name));
                        values.add(geom);
                        continue block10;
                    }
                }
                values.add(feature.get(name));
            }
            return this.setStatementParameters(st, values, this.geometry_support_type());
        }
        catch (SQLException | CreateGeometryException ex) {
            String f = "unknow";
            try {
                f = feature.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("Can't set parameters to prepared statement from the feature (" + f + ")", ex);
        }
    }

    protected byte[] getNativeBytes(Connection conn, Geometry geometry) throws Exception {
        GeopackageGeometryBuilder builder = GeopackageUtils.createGeometryBuilder();
        builder.setGeometry((SQLiteConnection)conn, geometry);
        byte[] bytes = builder.build();
        return bytes;
    }

    public SQLBuilder.TableNameBuilder createTableNameBuilder() {
        return new SQLiteTableNameBuilderBase();
    }

    protected SQLBuilder.AlterTableBuilder createAlterTableBuilder() {
        return new SQLiteAlterTableBuilder((SQLBuilderBase)this);
    }

    public SQLBuilder.CreateIndexBuilder createCreateIndexBuilder() {
        return new SQLiteCreateIndexBuilder();
    }

    protected SQLBuilder.DropTableBuilder createDropTableBuilder() {
        return new SQLiteDropTableBuilder();
    }

    protected SQLBuilder.CreateTableBuilder createCreateTableBuilder() {
        return new SQLiteCreateTableBuilder();
    }

    public SQLBuilder.SelectBuilder createSelectBuilder() {
        return new SQLiteSelectBuilderBase();
    }

    public Formatter formatter() {
        if (this.formatter == null) {
            this.formatter = new SQLiteFormatter((SQLBuilder)this);
        }
        return this.formatter;
    }

    public GeometryExpressionBuilder expression() {
        if (this.expressionBuilder instanceof SQLiteGeometryExpressionBuilder) {
            return this.expressionBuilder;
        }
        GeometryExpressionBuilder standardBuilder = GeometryExpressionEvaluatorLocator.getGeometryExpressionEvaluatorManager().createExpressionBuilder();
        this.expressionBuilder = new SQLiteGeometryExpressionBuilder(standardBuilder);
        this.expressionBuilder.setProperty("SQLBUILDER", (Object)this);
        return this.expressionBuilder;
    }

    private static class SQLiteGeometryExpressionBuilder
    extends DelegatedGeometryExpressionBuilder {
        public SQLiteGeometryExpressionBuilder(GeometryExpressionBuilder builder) {
            super(builder);
        }

        public ExpressionBuilder.Value as_geometry(ExpressionBuilder.Value value) {
            return this.group(value);
        }
    }

    public class SQLiteAlterTableBuilder
    extends SQLBuilderBase.AlterTableBuilderBase
    implements SQLBuilder.AlterTableBuilder {
        public SQLiteAlterTableBuilder(SQLBuilderBase sqlbuilder) {
            super((SQLBuilderBase)SQLiteSQLBuilder.this, sqlbuilder);
        }

        protected List<String> create_index_sqls(Formatter<ExpressionBuilder.Value> formatter, SQLBuilder.ColumnDescriptor column) {
            SQLBuilder.CreateIndexBuilder createIndex = this.sqlbuilder.createCreateIndexBuilder();
            FeatureType type = (FeatureType)this.getProperty("FeatureType");
            createIndex.setFeatureType(type);
            if (column.isGeometry()) {
                createIndex.spatial();
            }
            createIndex.if_not_exist();
            createIndex.name(SQLiteSQLBuilder.this.as_identifier(this.getConstrainName("IDX", column.getName())));
            createIndex.column(column.getName());
            createIndex.table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getName());
            if (!column.allowIndexDuplicateds()) {
                createIndex.unique();
            }
            return createIndex.toStrings();
        }

        protected List<String> drop_index_sqls(Formatter<ExpressionBuilder.Value> formatter, SQLBuilder.ColumnDescriptor column) {
            SQLBuilder.DropIndexBuilder dropIndex = this.sqlbuilder.createDropIndexBuilder();
            dropIndex.if_exist();
            dropIndex.name(SQLiteSQLBuilder.this.as_identifier(this.getConstrainName("IDX", column.getName())));
            return dropIndex.toStrings();
        }

        protected List<String> alter_table_add_column_sqls(Formatter<ExpressionBuilder.Value> formatter, SQLBuilder.ColumnDescriptor column) {
            ArrayList<String> sqls = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            builder.append("ALTER TABLE ");
            builder.append(this.table.toString(formatter));
            builder.append(" ADD COLUMN ");
            builder.append(SQLiteSQLBuilder.this.as_identifier(column.getName()));
            builder.append(" ");
            if (column.getType() == 4 && column.isAutomatic()) {
                builder.append(" SERIAL");
            } else {
                builder.append(SQLiteSQLBuilder.this.sqltype(column.getType(), column.getSize(), column.getPrecision(), column.getScale(), column.getGeometryType(), column.getGeometrySubtype()));
            }
            if (column.getDefaultValue() == null) {
                if (column.allowNulls()) {
                    builder.append(" DEFAULT NULL");
                }
            } else {
                builder.append(" DEFAULT '");
                builder.append(Objects.toString(column.getDefaultValue(), ""));
                builder.append("'");
            }
            if (column.allowNulls()) {
                builder.append(" NULL");
            } else {
                builder.append(" NOT NULL");
            }
            if (column.isPrimaryKey()) {
                builder.append(" PRIMARY KEY");
            }
            sqls.add(builder.toString());
            if (column.isGeometry()) {
                sqls.addAll(this.alter_column_add_geometry_constraint_sqls(formatter, column));
            }
            if (column.isIndexed()) {
                sqls.addAll(this.create_index_sqls(formatter, column));
            }
            return sqls;
        }

        protected List<String> alter_column_add_geometry_constraint_sqls(Formatter<ExpressionBuilder.Value> formatter, SQLBuilder.ColumnDescriptor column) {
            return Collections.EMPTY_LIST;
        }

        public SQLBuilder.AlterTableBuilder alter_geometry_column(Bitmask operation, String columnName, int type, int subtype, IProjection proj, boolean isIndexed, boolean allowNulls) {
            if (StringUtils.isEmpty((CharSequence)columnName)) {
                throw new IllegalArgumentException("Argument 'columnName' can't be empty.");
            }
            SQLBuilderBase.ColumnDescriptorBase column = new SQLBuilderBase.ColumnDescriptorBase((SQLBuilderBase)SQLiteSQLBuilder.this, columnName, type, subtype, proj, isIndexed, allowNulls);
            this.update_or_add_alters(column);
            if (operation == null) {
                operation = Bitmask.createBitmask((int)0);
            }
            if (operation.isEmpty()) {
                operation.setBit(1);
                operation.setBit(2);
            }
            this.operations.add(new ImmutablePair((Object)operation, (Object)column));
            return this;
        }

        public SQLBuilder.AlterTableBuilder alter_geometry_column(Bitmask operation, String columnName, int type, int subtype, Object srsdbcode, boolean isIndexed, boolean allowNulls) {
            if (StringUtils.isEmpty((CharSequence)columnName)) {
                throw new IllegalArgumentException("Argument 'columnName' can't be empty.");
            }
            SQLBuilderBase.ColumnDescriptorBase column = new SQLBuilderBase.ColumnDescriptorBase((SQLBuilderBase)SQLiteSQLBuilder.this, columnName, type, subtype, srsdbcode, isIndexed, allowNulls);
            this.update_or_add_alters(column);
            if (operation == null) {
                operation = Bitmask.createBitmask((int)0);
                operation.setBit(2);
            }
            this.operations.add(new ImmutablePair((Object)operation, (Object)column));
            return this;
        }

        public List<String> toStrings(Formatter formatter) {
            ArrayList<String> sqls = new ArrayList<String>();
            if (this.isEmpty()) {
                return sqls;
            }
            Iterator iterator = this.drops.iterator();
            if (iterator.hasNext()) {
                String column = (String)iterator.next();
                throw new SQLBuilderUnsupportedOperationException("Can't alter column in SQLite");
            }
            for (SQLBuilder.ColumnDescriptor column : this.adds) {
                sqls.addAll(this.alter_table_add_column_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
            }
            for (Pair operationAndColumn : this.getOperations()) {
                Bitmask operation = (Bitmask)operationAndColumn.getLeft();
                SQLBuilder.ColumnDescriptor column = (SQLBuilder.ColumnDescriptor)operationAndColumn.getRight();
                if (operation.isSetBit(1)) {
                    throw new SQLBuilderUnsupportedOperationException("Can't alter column in SQLite");
                }
                if (operation.isSetBit(4)) {
                    throw new SQLBuilderUnsupportedOperationException("Can't alter column in SQLite");
                }
                if (operation.isSetBit(5)) {
                    throw new SQLBuilderUnsupportedOperationException("Can't alter column in SQLite");
                }
                if (operation.isSetBit(6)) {
                    throw new SQLBuilderUnsupportedOperationException("Can't alter column in SQLite");
                }
                if (operation.isSetBit(7)) {
                    throw new SQLBuilderUnsupportedOperationException("Can't alter column in SQLite");
                }
                if (operation.isSetBit(3)) {
                    throw new SQLBuilderUnsupportedOperationException("Can't alter column in SQLite");
                }
                if (operation.isSetBit(8)) {
                    sqls.addAll(this.create_index_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                }
                if (operation.isSetBit(9)) {
                    sqls.addAll(this.drop_index_sqls((Formatter<ExpressionBuilder.Value>)formatter, column));
                }
                if (!operation.isSetBit(2)) continue;
                throw new SQLBuilderUnsupportedOperationException("Can't alter column in SQLite");
            }
            iterator = this.renames.iterator();
            if (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                throw new SQLBuilderUnsupportedOperationException("Can't alter column in SQLite");
            }
            return sqls;
        }
    }

    public class SQLiteCreateIndexBuilder
    extends SQLBuilderBase.CreateIndexBuilderBase
    implements SQLBuilder.CreateIndexBuilder {
        public SQLiteCreateIndexBuilder() {
            super((SQLBuilderBase)SQLiteSQLBuilder.this);
        }

        public List<String> toStrings(Formatter formatter) {
            ArrayList<String> sqls = new ArrayList<String>();
            if (this.isSpatial) {
                String pkName = this.type.getPrimaryKey()[0].getName();
                GeopackageIndexRTree index = new GeopackageIndexRTree();
                sqls.addAll(index.getCreateIndexSQL(this.table.getName(), (String)this.columns.get(0), pkName));
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("CREATE ");
                if (this.isUnique) {
                    builder.append("UNIQUE ");
                }
                builder.append("INDEX ");
                if (this.ifNotExist) {
                    builder.append("IF NOT EXISTS ");
                }
                builder.append(SQLiteSQLBuilder.this.as_identifier(this.indexName));
                builder.append(" ON ");
                builder.append(this.table.toString(formatter));
                builder.append(" ( ");
                boolean is_first_column = true;
                for (String column : this.columns) {
                    if (is_first_column) {
                        is_first_column = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(SQLiteSQLBuilder.this.as_identifier(column));
                }
                builder.append(" )");
                sqls.add(builder.toString());
            }
            return sqls;
        }
    }

    public class SQLiteSelectBuilderBase
    extends SQLBuilderBase.SelectBuilderBase {
        public SQLiteSelectBuilderBase() {
            super((SQLBuilderBase)SQLiteSQLBuilder.this);
        }

        protected boolean isValid(StringBuilder message) {
            if (message == null) {
                message = new StringBuilder();
            }
            if (this.has_offset() && !this.has_order_by()) {
                message.append("Can't use OFFSET without an ORDER BY.");
                return false;
            }
            return true;
        }

        public String toString(Formatter formatter) {
            StringBuilder builder = new StringBuilder();
            if (!this.isValid(builder)) {
                throw new IllegalStateException(builder.toString());
            }
            builder.append("SELECT ");
            if (this.distinct) {
                builder.append("DISTINCT ");
            }
            boolean first = true;
            for (SQLBuilder.SelectColumnBuilder column : this.columns) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(column.toString(formatter));
            }
            if (this.has_from()) {
                builder.append(" FROM ");
                builder.append(this.from.toString(formatter));
            }
            if (this.has_where()) {
                builder.append(" WHERE ");
                builder.append(this.where.toString(formatter));
            }
            if (this.has_group_by()) {
                builder.append(" GROUP BY ");
                builder.append(((ExpressionBuilder.Value)this.groupColumn.get(0)).toString(formatter));
                for (int i = 1; i < this.groupColumn.size(); ++i) {
                    builder.append(", ");
                    builder.append(((ExpressionBuilder.Value)this.groupColumn.get(i)).toString(formatter));
                }
            }
            if (this.has_order_by()) {
                builder.append(" ORDER BY ");
                first = true;
                for (SQLBuilder.OrderByBuilder item : this.order_by) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(item.toString(formatter));
                }
            }
            if (this.has_limit() && this.has_offset()) {
                builder.append(" LIMIT ");
                builder.append(this.limit);
                builder.append(" OFFSET ");
                builder.append(this.offset);
            } else if (this.has_limit()) {
                builder.append(" LIMIT ");
                builder.append(this.limit);
            } else if (this.has_offset()) {
                builder.append(" LIMIT -1 OFFSET ");
                builder.append(this.offset);
            }
            return builder.toString();
        }
    }

    protected class SQLiteDropTableBuilder
    extends SQLBuilderBase.DropTableBuilderBase {
        protected SQLiteDropTableBuilder() {
            super((SQLBuilderBase)SQLiteSQLBuilder.this);
        }

        public List<String> toStrings(Formatter formatter) {
            ArrayList<String> sqls = new ArrayList<String>();
            sqls.add(GeopackageGeometryColumns.buildDeleteSQL(this.table.getName()));
            sqls.add(String.format("DELETE FROM \"gpkg_contents\" WHERE \"identifier\" = '%s'", this.table.getName()));
            sqls.add(String.format("DELETE FROM \"gpkg_extensions\" WHERE \"table_name\" = '%s'", this.table.getName()));
            sqls.add(MessageFormat.format(SQLiteSQLBuilder.this.STMT_DROP_TABLE_table, this.table.toString(formatter)));
            return sqls;
        }
    }

    protected class SQLiteCreateTableBuilder
    extends SQLBuilderBase.CreateTableBuilderBase {
        protected SQLiteCreateTableBuilder() {
            super((SQLBuilderBase)SQLiteSQLBuilder.this);
        }

        public List<String> toStrings(Formatter formatter) {
            ArrayList<String> sqls = new ArrayList<String>();
            sqls.add("CREATE TABLE IF NOT EXISTS gpkg_contents (table_name TEXT NOT NULL PRIMARY KEY,data_type TEXT NOT NULL,identifier TEXT UNIQUE,description TEXT DEFAULT '',last_change DATETIME NOT NULL DEFAULT (strftime('%Y-%m-%dT%H:%M:%fZ','now')),min_x DOUBLE, min_y DOUBLE,max_x DOUBLE, max_y DOUBLE,srs_id INTEGER,CONSTRAINT fk_gc_r_srs_id FOREIGN KEY (srs_id) REFERENCES gpkg_spatial_ref_sys(srs_id))");
            if (this.hasGeometry()) {
                sqls.add(TemplateUtils.getSqlTemplate("rtree", "create_table_gpkg_extensions", new Object[0]));
                sqls.add(GeopackageGeometryColumns.buildCreateTableSQLIfNotExists());
                sqls.add(String.format("INSERT INTO \"gpkg_contents\" (\"table_name\", \"data_type\", \"identifier\", \"description\", \"last_change\", \"min_x\", \"min_y\", \"max_x\", \"max_y\", \"srs_id\") VALUES ('%s', '%s', '%s', '', '%s', NULL, NULL, NULL, NULL, NULL)", this.table.getName(), "features", this.table.getName(), new Timestamp(new Date().getTime()).toString()));
            } else {
                sqls.add(String.format("INSERT INTO \"gpkg_contents\" (\"table_name\", \"data_type\", \"identifier\", \"description\", \"last_change\", \"min_x\", \"min_y\", \"max_x\", \"max_y\", \"srs_id\") VALUES ('%s', '%s', '%s', '', '%s', NULL, NULL, NULL, NULL, NULL)", this.table.getName(), "attributes", this.table.getName(), new Timestamp(new Date().getTime()).toString()));
            }
            StringBuilder builder = new StringBuilder();
            String pkName = null;
            builder.append("CREATE TABLE ");
            builder.append(this.table.toString(formatter));
            builder.append(" (");
            boolean first = true;
            for (SQLBuilder.ColumnDescriptor column : this.columns) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(SQLiteSQLBuilder.this.as_identifier(column.getName()));
                builder.append(" ");
                builder.append(SQLiteSQLBuilder.this.sqltype(column.getType(), column.getSize(), column.getPrecision(), column.getScale(), column.getGeometryType(), column.getGeometrySubtype()));
                if (column.isPrimaryKey()) {
                    builder.append(" PRIMARY KEY");
                    pkName = column.getName();
                }
                if (column.isAutomatic()) {
                    builder.append(" AUTOINCREMENT");
                }
                if (column.getDefaultValue() == null) {
                    if (column.allowNulls()) {
                        builder.append(" DEFAULT NULL");
                    }
                } else if (column.getType() == 9) {
                    builder.append(" DEFAULT ( date('");
                    builder.append(column.getDefaultValue().toString());
                    builder.append("') )");
                } else {
                    builder.append(" DEFAULT '");
                    builder.append(column.getDefaultValue().toString());
                    builder.append("'");
                }
                if (column.allowNulls()) continue;
                builder.append(" NOT NULL");
            }
            builder.append(" )");
            sqls.add(builder.toString());
            for (SQLBuilder.ColumnDescriptor column : this.columns) {
                if (!column.isGeometry()) continue;
                sqls.add(GeopackageGeometryColumns.buildInsertSQL(this.table.getName(), column.getName(), column.getGeometryType(), column.getGeometrySubtype(), column.getGeometrySRSId()));
            }
            return sqls;
        }

        private boolean hasGeometry() {
            for (SQLBuilder.ColumnDescriptor column : this.columns) {
                if (!column.isGeometry()) continue;
                return true;
            }
            return false;
        }
    }

    public class SQLiteTableNameBuilderBase
    extends SQLBuilderBase.TableNameBuilderBase {
        public SQLiteTableNameBuilderBase() {
            super((SQLBuilderBase)SQLiteSQLBuilder.this);
        }

        public boolean has_schema() {
            return false;
        }

        public boolean has_database() {
            return false;
        }
    }
}

