/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.functions;

import java.sql.SQLException;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.sqlite.dal.functions.Functions;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryBuilder;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryParser;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.sqlite.SQLiteConnection;

public class ST_SetSRID
extends Functions.AbstractFunction {
    public ST_SetSRID(SQLiteConnection conn) {
        super("ST_SetSRID", conn);
    }

    protected void xFunc() throws SQLException {
        try {
            byte[] bytes1 = this.value_blob(0);
            if (bytes1 == null) {
                this.result();
                return;
            }
            String srid = this.value_text(1);
            SQLiteConnection conn = this.getConnection();
            GeopackageGeometryParser parser = GeopackageUtils.createGeometryParser();
            Geometry geom = parser.parseToGeometry(conn, bytes1);
            if (geom == null) {
                this.result();
                return;
            }
            GeopackageGeometryBuilder builder = GeopackageUtils.createGeometryBuilder();
            IProjection proj = CRSFactory.getCRS((String)("EPSG:" + srid));
            if (proj == null) {
                throw new ExpressionRuntimeException("Invalid SRID '" + srid + "'.");
            }
            geom.setProjection(proj);
            builder.setGeometry(conn, geom);
            byte[] bytes = builder.build();
            if (bytes == null) {
                this.result();
            } else {
                this.result(bytes);
            }
        }
        catch (Throwable ex) {
            throw new SQLException("Can't assign the projection to the geometry", ex);
        }
    }
}

