/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.geopackage;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.sqlite.dal.operations.SQLiteFetchFeatureTypeOperation;
import org.sqlite.SQLiteException;

public class GeopackageGeometryColumns {
    /*
     * Loose catch block
     */
    static void load_gpkg_geometry_columns(Map<String, SQLiteFetchFeatureTypeOperation.SQLiteColumnInfo> columns_info, JDBCConnection conn, String tableName, JDBCSQLBuilderBase sqlbuilder) {
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        sqlbuilder.select().column().name("table_name");
        sqlbuilder.select().column().name("column_name");
        sqlbuilder.select().column().name("geometry_type_name");
        sqlbuilder.select().column().name("srs_id");
        sqlbuilder.select().column().name("z");
        sqlbuilder.select().column().name("m");
        sqlbuilder.select().where().set((ExpressionBuilder.Value)expbuilder.eq((ExpressionBuilder.Value)expbuilder.column("table_name"), (ExpressionBuilder.Value)expbuilder.constant((Object)tableName)));
        sqlbuilder.select().from().table().name("gpkg_geometry_columns");
        Statement st = null;
        ResultSet rs = null;
        try {
            String sql = sqlbuilder.toString();
            st = conn.createStatement(sql);
            rs = JDBCUtils.executeQuery((Statement)st, (String)sql);
            while (rs.next()) {
                String columnname = rs.getString("column_name");
                GeopackageGeometryColumn geominfo = new GeopackageGeometryColumn();
                geominfo.copyfrom(columns_info.get(columnname));
                geominfo.set(rs.getString("table_name"), columnname, rs.getString("geometry_type_name"), rs.getInt("srs_id"), rs.getInt("z"), rs.getInt("m"));
                columns_info.put(columnname, geominfo);
            }
        }
        catch (SQLiteException ex) {
            block7: {
                if (ex.getMessage().contains("no such table")) break block7;
                throw new RuntimeException("Can't load information from table gpkg_geometry_columns", ex);
            }
            JDBCUtils.closeQuietly(rs);
            JDBCUtils.closeQuietly((Statement)st);
        }
        catch (Throwable ex2) {
            throw new RuntimeException("Can't load information from table gpkg_geometry_columns", ex2);
            {
                catch (Throwable throwable) {
                    JDBCUtils.closeQuietly(rs);
                    JDBCUtils.closeQuietly(st);
                    throw throwable;
                }
            }
        }
        JDBCUtils.closeQuietly((ResultSet)rs);
        JDBCUtils.closeQuietly((Statement)st);
    }

    public static String buildCreateTableSQLIfNotExists() {
        return "CREATE TABLE IF NOT EXISTS \"gpkg_geometry_columns\" ( \"table_name\" TEXT NOT NULL, \"column_name\" TEXT NOT NULL, \"geometry_type_name\" TEXT NOT NULL, \"srs_id\" INTEGER NOT NULL, \"z\" TINYINT NOT NULL, \"m\" TINYINT NOT NULL, CONSTRAINT \"pk_geom_cols\" PRIMARY KEY(\"table_name\",\"column_name\"), CONSTRAINT \"fk_gc_tn\" FOREIGN KEY(\"table_name\") REFERENCES \"gpkg_contents\"(\"table_name\"), CONSTRAINT \"uk_gc_table_name\" UNIQUE(\"table_name\"), CONSTRAINT \"fk_gc_srs\" FOREIGN KEY(\"srs_id\") REFERENCES \"gpkg_spatial_ref_sys\"(\"srs_id\") )";
    }

    public static String buildInsertSQL(String tableName, String geomName, int geometryType, int geometrySubtype, Object geometrySRSId) {
        String geometryTypeName = "GEOMETRY";
        switch (geometryType) {
            case 1: {
                geometryTypeName = "POINT";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 23: 
            case 24: {
                geometryTypeName = "LINESTRING";
                break;
            }
            case 11: 
            case 13: 
            case 19: 
            case 25: {
                geometryTypeName = "POLYGON";
                break;
            }
            case 21: {
                geometryTypeName = "MULTILINESTRING";
                break;
            }
            case 7: {
                geometryTypeName = "MULTIPOINT";
                break;
            }
            case 22: {
                geometryTypeName = "MULTIPOLYGON";
            }
        }
        String s = String.format("INSERT INTO \"gpkg_geometry_columns\" (\"table_name\", \"column_name\", \"geometry_type_name\", \"srs_id\", \"z\", \"m\") VALUES ('%s', '%s', '%s', '%s', '%s', '%s')", tableName, geomName, geometryTypeName, geometrySRSId.toString(), geometrySubtype == 1 || geometrySubtype == 3 ? 1 : 0, geometrySubtype == 2 || geometrySubtype == 3 ? 1 : 0);
        return s;
    }

    public static String buildDeleteSQL(String tableName, String geomName) {
        String s = String.format("DELETE FROM \"gpkg_geometry_columns\" WHERE \"table_name\" = '%s' and \"column_name\" = '%s'", tableName, geomName);
        return s;
    }

    public static String buildDeleteSQL(String tableName) {
        String s = String.format("DELETE FROM \"gpkg_geometry_columns\" WHERE \"table_name\" = '%s'", tableName);
        return s;
    }

    public static class GeopackageGeometryColumn
    extends SQLiteFetchFeatureTypeOperation.SQLiteColumnInfo {
        private String geometry_type_name;
        private int srs_id;
        private int z;
        private int m;

        GeopackageGeometryColumn() {
        }

        public void set(String table_name, String column_column, String geometry_type_name, int srs_id, int z, int m) {
            this.table_name = table_name;
            this.column_column = column_column;
            this.geometry_type_name = geometry_type_name;
            this.srs_id = srs_id;
            this.z = z;
            this.m = m;
        }

        public String getGeometry_type_name() {
            return this.geometry_type_name;
        }

        public int getSrs_id() {
            return this.srs_id;
        }

        public int getZ() {
            return this.z;
        }

        public int getM() {
            return this.m;
        }
    }
}

