/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.geopackage.index;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.sqlite.dal.geopackage.index.GeopackageIndex;
import org.gvsig.sqlite.dal.utils.TemplateUtils;
import org.sqlite.SQLiteException;

public abstract class AbstractGeopackageIndex
implements GeopackageIndex {
    protected abstract String getGroup();

    protected abstract String getAttributeIndexFlagName();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasIndex(JDBCConnection conn, String tablename, String fieldnamegeom) {
        boolean bl;
        ResultSet rs;
        Statement st;
        block7: {
            String sql = TemplateUtils.getSqlTemplate(this.getGroup(), "has_index", tablename, fieldnamegeom);
            st = null;
            rs = null;
            st = conn.createStatement(sql);
            rs = JDBCUtils.executeQuery((Statement)st, (String)sql);
            if (rs.next()) break block7;
            boolean bl2 = false;
            JDBCUtils.closeQuietly((ResultSet)rs);
            JDBCUtils.closeQuietly((Statement)st);
            return bl2;
        }
        try {
            int n = rs.getInt(1);
            bl = n == 1;
        }
        catch (SQLiteException ex) {
            block8: {
                boolean bl3;
                try {
                    if (!ex.getMessage().contains("no such table")) break block8;
                    bl3 = false;
                }
                catch (Throwable throwable) {
                    JDBCUtils.closeQuietly(rs);
                    JDBCUtils.closeQuietly((Statement)st);
                    throw throwable;
                }
                JDBCUtils.closeQuietly((ResultSet)rs);
                JDBCUtils.closeQuietly((Statement)st);
                return bl3;
            }
            throw new RuntimeException("Can't get information about " + this.getGroup() + " index", ex);
            catch (SQLException ex2) {
                throw new RuntimeException("Can't get information about " + this.getGroup() + " index", ex2);
            }
        }
        JDBCUtils.closeQuietly((ResultSet)rs);
        JDBCUtils.closeQuietly((Statement)st);
        return bl;
    }

    @Override
    public void createIndex(JDBCConnection conn, String tablename, String fieldnamegeom, String fieldnameid) throws SQLException {
        for (String sql : this.getCreateIndexSQL(tablename, fieldnamegeom, fieldnameid)) {
            JDBCUtils.execute((Connection)conn.get(), (String)sql);
        }
    }

    @Override
    public String getBBoxIntersectsFilter(String tablename, String fieldnameid, String fieldnamegeom, double minX, double minY, double maxX, double maxY) {
        String sql = TemplateUtils.getSqlTemplate(this.getGroup(), "bboxintersects", tablename, fieldnameid, fieldnamegeom, minX, minY, maxX, maxY);
        return sql;
    }

    @Override
    public String getBBoxIntersectsFilter(String tablename, String fieldnameid, String fieldnamegeom, String minX, String minY, String maxX, String maxY) {
        String sql = TemplateUtils.getSqlTemplate(this.getGroup(), "bboxintersects", tablename, fieldnameid, fieldnamegeom, minX, minY, maxX, maxY);
        return sql;
    }

    @Override
    public String getBBoxIntersectsFilter(String tablename, String fieldnameid, String fieldnamegeom, Envelope env) {
        String sql = this.getBBoxIntersectsFilter(tablename, fieldnameid, fieldnamegeom, env.getMinimum(0), env.getMinimum(1), env.getMaximum(0), env.getMaximum(1));
        return sql;
    }

    @Override
    public String getBBoxIntersectsFilter(String tablename, String fieldnameid, String fieldnamegeom, Geometry geom) {
        return this.getBBoxIntersectsFilter(tablename, fieldnameid, fieldnamegeom, geom.getEnvelope());
    }

    @Override
    public void setHasIndex(FeatureAttributeDescriptor attr, boolean b) {
        attr.getTags().set(this.getAttributeIndexFlagName(), (Object)(b ? 1 : 0));
    }

    @Override
    public boolean hasIndex(FeatureAttributeDescriptor attr) {
        return attr.getTags().getInt(this.getAttributeIndexFlagName(), 0) == 1;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Envelope getEnvelope(JDBCConnection conn, String tablename, String fieldnamegeom) throws SQLException {
        Envelope envelope;
        ResultSet rs;
        Statement st;
        block9: {
            block8: {
                String sql = this.getEnvelopeSQL(tablename, fieldnamegeom);
                st = null;
                rs = null;
                st = conn.createStatement(sql);
                rs = JDBCUtils.executeQuery((Statement)st, (String)sql);
                if (rs.next()) break block8;
                Envelope envelope2 = null;
                JDBCUtils.closeQuietly((ResultSet)rs);
                JDBCUtils.closeQuietly((Statement)st);
                return envelope2;
            }
            if (rs.getInt("rows") != 0) break block9;
            Envelope envelope3 = null;
            JDBCUtils.closeQuietly((ResultSet)rs);
            JDBCUtils.closeQuietly((Statement)st);
            return envelope3;
        }
        try {
            Envelope env;
            double minx = rs.getDouble("minx");
            double miny = rs.getDouble("miny");
            double maxx = rs.getDouble("maxx");
            double maxy = rs.getDouble("maxy");
            GeometryManager geommanager = GeometryLocator.getGeometryManager();
            envelope = env = geommanager.createEnvelope(minx, miny, maxx, maxy, 0);
        }
        catch (SQLiteException ex) {
            block10: {
                Envelope envelope4;
                try {
                    if (!ex.getMessage().contains("no such table")) break block10;
                    envelope4 = null;
                }
                catch (Throwable throwable) {
                    JDBCUtils.closeQuietly(rs);
                    JDBCUtils.closeQuietly((Statement)st);
                    throw throwable;
                }
                JDBCUtils.closeQuietly((ResultSet)rs);
                JDBCUtils.closeQuietly((Statement)st);
                return envelope4;
            }
            throw new RuntimeException("Can't get envelop of index for group " + this.getGroup(), ex);
            catch (Throwable ex2) {
                throw new RuntimeException("Can't get envelop of index for group " + this.getGroup(), ex2);
            }
        }
        JDBCUtils.closeQuietly((ResultSet)rs);
        JDBCUtils.closeQuietly((Statement)st);
        return envelope;
    }
}

