/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.operations;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.FetchFeatureTypeOperation;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryColumns;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;

public class SQLiteFetchFeatureTypeOperation
extends FetchFeatureTypeOperation {
    private static final int DEFAULT_DISPLAY_SIZE = 200;
    private Map<String, SQLiteColumnInfo> columns_info;

    public SQLiteFetchFeatureTypeOperation(JDBCHelper helper) {
        super(helper);
    }

    public SQLiteFetchFeatureTypeOperation(JDBCHelper helper, EditableFeatureType featureType, OperationsFactory.TableReference table, List<String> primaryKeys, String defaultGeometryColumn, IProjection crs, int geometryType, int geometrySubtype) {
        super(helper, featureType, table, primaryKeys, defaultGeometryColumn, crs, geometryType, geometrySubtype);
    }

    public void fetch(JDBCConnection conn) throws DataException {
        this.columns_info = new HashMap<String, SQLiteColumnInfo>();
        this.load_columns_def(this.columns_info);
        GeopackageUtils.load_gpkg_geometry_columns(this.columns_info, conn, this.table.getTable(), this.createSQLBuilder());
        super.fetch(conn);
    }

    protected EditableFeatureAttributeDescriptor getAttributeFromMetadata(EditableFeatureType type, JDBCConnection conn, ResultSetMetaData rsMetadata, int colIndex) throws SQLException {
        EditableFeatureAttributeDescriptor attr = super.getAttributeFromMetadata(type, conn, rsMetadata, colIndex);
        switch (attr.getType()) {
            case 8: {
                if (attr.getSize() < 1) {
                    attr.setSize(4096);
                }
                attr.setDisplaySize(rsMetadata.getColumnDisplaySize(colIndex));
                if (attr.getDisplaySize() != Integer.MAX_VALUE) break;
                attr.setDisplaySize(0);
            }
        }
        int size = attr.getSize();
        if (attr.getDisplaySize() == Integer.MAX_VALUE) {
            if (size == 0) {
                attr.setDisplaySize(attr.getPrecision() + 2);
            } else {
                attr.setDisplaySize(size < 200 ? size : 200);
            }
        }
        return attr;
    }

    protected int getDataTypeFromMetadata(ResultSetMetaData rsMetadata, int colIndex) throws SQLException {
        String columnName = rsMetadata.getColumnName(colIndex);
        String typeName = rsMetadata.getColumnTypeName(colIndex);
        SQLiteColumnInfo columninfo = this.columns_info.get(columnName);
        if (columninfo != null) {
            int columnType;
            if (columninfo instanceof GeopackageGeometryColumns.GeopackageGeometryColumn) {
                return 66;
            }
            if (StringUtils.isNotBlank((CharSequence)columninfo.getColumn_def()) && (columnType = rsMetadata.getColumnType(colIndex)) == 4 && (StringUtils.contains((CharSequence)columninfo.getColumn_def(), (CharSequence)"date(") || StringUtils.contains((CharSequence)columninfo.getColumn_def(), (CharSequence)"datetime(") || StringUtils.contains((CharSequence)columninfo.getColumn_def(), (CharSequence)"strftime("))) {
                return 9;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"TIME")) {
                return 10;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"DATETIME")) {
                return 11;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"TIMESTAMP")) {
                return 11;
            }
        }
        return super.getDataTypeFromMetadata(rsMetadata, colIndex);
    }

    protected void fetchGeometryTypeAndSRS(EditableFeatureAttributeDescriptor attr, ResultSetMetaData rsMetadata, int colIndex) {
        if (attr.getType() != 66) {
            return;
        }
        SQLiteColumnInfo columninfo = this.columns_info.get(attr.getName());
        if (!(columninfo instanceof GeopackageGeometryColumns.GeopackageGeometryColumn)) {
            return;
        }
        try {
            GeopackageGeometryColumns.GeopackageGeometryColumn geominfo = (GeopackageGeometryColumns.GeopackageGeometryColumn)columninfo;
            IProjection proj = this.helper.getSRSSolver().getProjection(this.conn, (Object)geominfo.getSrs_id());
            int type = 0;
            int subtype = 0;
            if (!(geominfo.getZ() != 1 && geominfo.getZ() != 2 || geominfo.getM() != 1 && geominfo.getM() != 2)) {
                subtype = 3;
            } else if (geominfo.getZ() == 1 || geominfo.getZ() == 2) {
                subtype = 1;
            } else if (geominfo.getM() == 1 || geominfo.getM() == 2) {
                subtype = 2;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)geominfo.getGeometry_type_name(), (CharSequence)"POINT")) {
                type = 1;
            } else if (StringUtils.containsIgnoreCase((CharSequence)geominfo.getGeometry_type_name(), (CharSequence)"LINESTRING")) {
                type = 18;
            } else if (StringUtils.containsIgnoreCase((CharSequence)geominfo.getGeometry_type_name(), (CharSequence)"POLYGON")) {
                type = 19;
            } else if (StringUtils.containsIgnoreCase((CharSequence)geominfo.getGeometry_type_name(), (CharSequence)"MULTIPOINT")) {
                type = 7;
            } else if (StringUtils.containsIgnoreCase((CharSequence)geominfo.getGeometry_type_name(), (CharSequence)"MULTILINESTRING")) {
                type = 21;
            } else if (StringUtils.containsIgnoreCase((CharSequence)geominfo.getGeometry_type_name(), (CharSequence)"MULTIPOLYGON")) {
                type = 22;
            }
            attr.setSRS(proj);
            attr.setGeometryType(GeometryUtils.getGeometryType((int)type, (int)subtype));
            GeopackageUtils.getIndexManager().checkGeometryIndexes(this.conn, this.table.getTable(), (FeatureAttributeDescriptor)attr);
        }
        catch (Exception ex) {
            LOGGER.debug("Can't get geometry type and srs from column '" + attr.getName() + "'.", (Throwable)ex);
        }
    }

    private void load_columns_def(Map<String, SQLiteColumnInfo> columns_info) throws AccessResourceException {
        try {
            ResultSet dbmetadata = this.getConnection().getMetaData().getColumns(null, null, this.table.getTable(), null);
            while (dbmetadata.next()) {
                String columnname = dbmetadata.getString("COLUMN_NAME");
                SQLiteColumnInfo column_info = columns_info.get(columnname);
                if (column_info == null) {
                    column_info = new SQLiteColumnInfo();
                }
                column_info.column_def = StringUtils.defaultString((String)dbmetadata.getString("COLUMN_DEF"));
                columns_info.put(columnname, column_info);
            }
        }
        catch (SQLException ex) {
            LOGGER.warn("Can't read metadata from table '" + this.table + "'.", (Throwable)ex);
        }
    }

    protected List<String> getPrimaryKeysFromInformationSchema(JDBCConnection conn) throws SQLException {
        return Collections.EMPTY_LIST;
    }

    public String getSQLToRetrievePrimaryKeysFromInformationSchema() throws SQLException {
        return null;
    }

    public static class SQLiteColumnInfo {
        protected String table_name;
        protected String column_column;
        protected String column_def;

        public void set(String table_name, String column_column, String column_def) {
            this.table_name = table_name;
            this.column_column = column_column;
            this.column_def = column_def;
        }

        public void copyfrom(SQLiteColumnInfo other) {
            if (other == null) {
                return;
            }
            this.table_name = other.table_name;
            this.column_column = other.column_column;
            this.column_def = other.column_def;
        }

        public String getTable_name() {
            return this.table_name;
        }

        public String getColumn_column() {
            return this.column_column;
        }

        public String getColumn_def() {
            return this.column_def;
        }
    }
}

