/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.roimask.lib.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;
import java.util.regex.Pattern;
import org.gvsig.raster.roimask.lib.ROIMaskManager;
import org.gvsig.raster.roimask.lib.ROIMaskMessageException;
import org.gvsig.raster.roimask.lib.ROIMaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultROIMaskService
implements ROIMaskService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultROIMaskService.class);
    private static final String DEFAULT_FORTUNE_COOKIE_URL = "http://www.fullerdata.com/FortuneCookie/FortuneCookie.asmx/GetFortuneCookie";
    private String message = null;
    private ROIMaskManager manager;
    private Date date = null;
    private String url;

    public DefaultROIMaskService(ROIMaskManager manager) {
        this(manager, DEFAULT_FORTUNE_COOKIE_URL);
    }

    public DefaultROIMaskService(ROIMaskManager manager, String url) {
        this.manager = manager;
        this.url = url;
    }

    public String getMessage() throws ROIMaskMessageException {
        if (this.message == null) {
            try {
                this.message = this.getMessageFromUrl();
            }
            catch (IOException e) {
                throw new ROIMaskMessageException((Throwable)e);
            }
            this.date = new Date();
        }
        return this.message;
    }

    private String getMessageFromUrl() throws IOException {
        String str;
        LOG.debug("Getting the Raster message from the url: {}", (Object)this.url);
        URL url = new URL(this.url);
        StringBuffer message = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        Pattern p = Pattern.compile("\\<[^\\>]+\\>");
        StringBuffer data = null;
        if (LOG.isDebugEnabled()) {
            data = new StringBuffer();
        }
        while ((str = in.readLine()) != null) {
            if (LOG.isDebugEnabled()) {
                data.append(str).append('\n');
            }
            message.append(p.matcher(str).replaceAll("\n"));
        }
        in.close();
        LOG.debug("Raster message response:\n{}", (Object)data);
        return message.toString();
    }

    public ROIMaskManager getManager() {
        return this.manager;
    }

    public Date getDate() {
        return this.date;
    }
}

