/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.impl;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.util.Factory;
import org.gvsig.tools.util.IsEmpty;
import org.gvsig.tools.util.Size;
import org.gvsig.tools.util.Size64;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeSetImpl<K>
extends AbstractDisposable
implements Set<K>,
Size64,
Size,
IsEmpty,
Disposable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LargeSetImpl.class);
    private final File f;
    private MVStore mvstore;
    private MVMap<K, Boolean> mvMap;

    public LargeSetImpl() {
        FoldersManager folderManager = ToolsLocator.getFoldersManager();
        this.f = folderManager.getUniqueTemporaryFile(new String[]{"MinLargeSet.mv"});
        this.mvstore = MVStore.open((String)this.f.getAbsolutePath());
        this.mvMap = this.mvstore.openMap("DefaultMap");
    }

    protected void doDispose() throws BaseException {
        this.mvstore.closeImmediately();
        this.mvMap = null;
        this.mvstore = null;
        FileUtils.deleteQuietly((File)this.f);
    }

    @Override
    public int size() {
        return this.mvMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mvMap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.mvMap.containsKey(o);
    }

    @Override
    public Iterator<K> iterator() {
        return this.mvMap.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean add(K e) {
        return this.mvMap.put(e, (Object)Boolean.TRUE) != null;
    }

    @Override
    public boolean remove(Object o) {
        return this.mvMap.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.mvMap.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        boolean result = false;
        for (K k : c) {
            result |= this.add(k);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        for (K next : this) {
            if (c.contains(next)) continue;
            result |= this.remove(next);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object object : c) {
            result |= this.remove(object);
        }
        return result;
    }

    @Override
    public void clear() {
        this.mvMap.clear();
    }

    public long size64() {
        return this.mvMap.sizeAsLong();
    }

    public static void selfRegister() {
        DataManager dataManager = DALLocator.getDataManager();
        dataManager.registerLargeSet(new Factory(){

            public String getName() {
                return "MVStoreSetFactory";
            }

            public Object create(Object ... parameters) {
                return new LargeSetImpl();
            }
        });
    }
}

