/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.h2;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.h2.H2SpatialHelper;
import org.gvsig.fmap.dal.store.h2.H2SpatialStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCStoreProvider;
import org.gvsig.fmap.dal.store.jdbc2.impl.JDBCStoreProviderFactoryBase;

public class H2SpatialStoreProviderFactory
extends JDBCStoreProviderFactoryBase {
    private static final String NAME = "H2Spatial";
    private static final Set<String> ALLOWED_FUNCTIONS = new HashSet<String>(Arrays.asList("COUNT", "SUM", "MIN", "MAX", "AVG"));
    private static final Set<String> DENIED_FUNCTIONS = Collections.EMPTY_SET;

    public H2SpatialStoreProviderFactory() {
        super(NAME, "H2Spatial store");
    }

    public JDBCStoreProvider createProvider(DataParameters parameters, DataStoreProviderServices providerServices) throws InitializeException {
        H2SpatialHelper helper = new H2SpatialHelper((JDBCConnectionParameters)parameters);
        JDBCStoreProvider provider = helper.createProvider((JDBCStoreParameters)parameters, providerServices);
        return provider;
    }

    public JDBCStoreParameters createParameters() {
        H2SpatialStoreParameters params = new H2SpatialStoreParameters();
        return params;
    }

    public int hasVectorialSupport() {
        return 1;
    }

    public int hasRasterSupport() {
        return 2;
    }

    public int hasTabularSupport() {
        return 1;
    }

    public int hasSQLSupport() {
        return 1;
    }

    public Function<String, Integer> allowFunction() {
        return name -> {
            if (ALLOWED_FUNCTIONS.contains(name)) {
                return 1;
            }
            if (DENIED_FUNCTIONS.contains(name)) {
                return 2;
            }
            return 0;
        };
    }

    public int allowGroupBy() {
        return 1;
    }

    public int allowEditableFeatureType() {
        return 1;
    }
}

