/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.sextante.gui.core;

import es.unex.sextante.dataObjects.IDataObject;
import es.unex.sextante.gui.core.DefaultGUIFactory;
import es.unex.sextante.gui.core.NameAndIcon;
import es.unex.sextante.gui.core.ToolboxAction;
import es.unex.sextante.gui.exceptions.WrongViewNameException;
import es.unex.sextante.gui.toolbox.ToolboxPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.MDIManager;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.geoprocess.sextante.gui.cmd.BSHWindow;
import org.gvsig.geoprocess.sextante.gui.dataExplorer.DataExplorerWindow;
import org.gvsig.geoprocess.sextante.gui.history.HistoryWindow;
import org.gvsig.geoprocess.sextante.gui.modeler.ModelerWindow;
import org.gvsig.geoprocess.sextante.gui.toolbox.ToolboxWindow;

public class GUIFactory
extends DefaultGUIFactory {
    private ToolboxWindow toolbox;
    private MDIManager uiManager = ApplicationLocator.getManager().getUIManager();
    private static final HashMap<NameAndIcon, ArrayList<ToolboxAction>> map = new HashMap();

    public void showToolBoxDialog() {
        this.uiManager.addWindow((IWindow)this.getToolBoxWindow());
    }

    private ToolboxWindow getToolBoxWindow() {
        if (this.toolbox == null) {
            this.toolbox = new ToolboxWindow();
            m_Toolbox = this.toolbox.getToolboxPanel();
        }
        return this.toolbox;
    }

    public ToolboxPanel getToolboxPanel() {
        return m_Toolbox;
    }

    public void showModelerDialog() {
        ModelerWindow modeler = new ModelerWindow(this.getToolboxPanel());
        this.uiManager.addWindow((IWindow)modeler);
    }

    public void showHistoryDialog() {
        HistoryWindow history = new HistoryWindow(this.getToolboxPanel());
        this.uiManager.addWindow((IWindow)history);
    }

    public void showCommandLineDialog() {
        BSHWindow bsh = new BSHWindow(this.getToolboxPanel());
        this.uiManager.addWindow((IWindow)bsh);
    }

    public void showDataExplorer() {
        DataExplorerWindow dataExplorer = new DataExplorerWindow(this.getToolboxPanel());
        this.uiManager.addWindow((IWindow)dataExplorer);
    }

    public void addToView(IDataObject obj, String viewName) throws WrongViewNameException {
        Project project = ApplicationLocator.getManager().getCurrentProject();
        List views = project.getDocuments(ViewManager.TYPENAME);
        for (int i = 0; i < views.size(); ++i) {
            ViewDocument view = (ViewDocument)views.get(i);
            if (!view.getName().equals(viewName)) continue;
            FLayers layers = view.getMapContext().getLayers();
            Object layer = obj.getBaseDataObject();
            if (layer instanceof FLayer) {
                layers.addLayer((FLayer)layer);
            }
            return;
        }
        throw new WrongViewNameException();
    }

    public HashMap<NameAndIcon, ArrayList<ToolboxAction>> getToolboxActions() {
        return map;
    }

    public static void registerExternalTool(String groupName, ImageIcon icon, ToolboxAction toolBoxAction) {
        Iterator<NameAndIcon> it = map.keySet().iterator();
        ArrayList<ToolboxAction> algs = null;
        NameAndIcon key = null;
        while (it.hasNext()) {
            key = it.next();
            if (!key.getName().equals(groupName)) continue;
            algs = map.get(key);
            break;
        }
        if (algs == null) {
            algs = new ArrayList<ToolboxAction>();
            key = new NameAndIcon(groupName, icon);
        }
        algs.add(toolBoxAction);
        map.put(key, algs);
    }
}

