/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;
import java.util.regex.Pattern;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.RasterMessageException;
import org.gvsig.fmap.dal.coverage.RasterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRasterService
implements RasterService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRasterService.class);
    private static final String DEFAULT_FORTUNE_COOKIE_URL = "http://www.fullerdata.com/FortuneCookie/FortuneCookie.asmx/GetFortuneCookie";
    private String message = null;
    private RasterManager manager;
    private Date date = null;
    private String url;

    public DefaultRasterService(RasterManager manager) {
        this(manager, DEFAULT_FORTUNE_COOKIE_URL);
    }

    public DefaultRasterService(RasterManager manager, String url) {
        this.manager = manager;
        this.url = url;
    }

    public String getMessage() throws RasterMessageException {
        if (this.message == null) {
            try {
                this.message = this.getMessageFromUrl();
            }
            catch (IOException e) {
                throw new RasterMessageException((Throwable)e);
            }
            this.date = new Date();
        }
        return this.message;
    }

    private String getMessageFromUrl() throws IOException {
        String str;
        LOG.debug("Getting the Raster message from the url: {}", (Object)this.url);
        URL url = new URL(this.url);
        StringBuffer message = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        Pattern p = Pattern.compile("\\<[^\\>]+\\>");
        StringBuffer data = null;
        if (LOG.isDebugEnabled()) {
            data = new StringBuffer();
        }
        while ((str = in.readLine()) != null) {
            if (LOG.isDebugEnabled()) {
                data.append(str).append('\n');
            }
            message.append(p.matcher(str).replaceAll("\n"));
        }
        in.close();
        LOG.debug("Raster message response:\n{}", (Object)data);
        return message.toString();
    }

    public RasterManager getManager() {
        return this.manager;
    }

    public Date getDate() {
        return this.date;
    }
}

